/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.collections.ReadOnlyUnbackedObservableList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.IndexedCheckModel;

public class CheckComboBoxSkin<T>
extends SkinBase<CheckComboBox<T>> {
    private final ComboBox<T> comboBox;
    private final ListCell<T> buttonCell;
    private final CheckComboBox<T> control;
    private final ObservableList<T> items;
    private final ReadOnlyUnbackedObservableList<Integer> selectedIndices;
    private final ReadOnlyUnbackedObservableList<T> selectedItems;

    public CheckComboBoxSkin(CheckComboBox<T> checkComboBox) {
        super(checkComboBox);
        this.control = checkComboBox;
        this.items = checkComboBox.getItems();
        this.selectedIndices = (ReadOnlyUnbackedObservableList)checkComboBox.getCheckModel().getCheckedIndices();
        this.selectedItems = (ReadOnlyUnbackedObservableList)checkComboBox.getCheckModel().getCheckedItems();
        this.comboBox = new ComboBox<T>(this.items){

            protected Skin<?> createDefaultSkin() {
                return CheckComboBoxSkin.this.createComboBoxListViewSkin(this);
            }
        };
        this.comboBox.setFocusTraversable(false);
        this.comboBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        Bindings.bindContent((List)checkComboBox.getStyleClass(), (ObservableList)this.comboBox.getStyleClass());
        this.comboBox.setCellFactory(listView -> {
            CheckBoxListCell checkBoxListCell = new CheckBoxListCell(checkComboBox::getItemBooleanProperty);
            checkBoxListCell.setOnMouseClicked(mouseEvent -> {
                Object object = checkBoxListCell.getItem();
                if (checkComboBox.getCheckModel().isChecked(object)) {
                    checkComboBox.getCheckModel().clearCheck(object);
                } else {
                    checkComboBox.getCheckModel().check(object);
                }
            });
            checkBoxListCell.converterProperty().bind(checkComboBox.converterProperty());
            return checkBoxListCell;
        });
        this.buttonCell = new ListCell<T>(){

            protected void updateItem(T t2, boolean bl2) {
                this.setText(CheckComboBoxSkin.this.getTextString());
            }
        };
        this.comboBox.setButtonCell(this.buttonCell);
        this.comboBox.setValue((Object)this.getTextString());
        if (checkComboBox.getProperties().containsKey((Object)"comboBoxRowsToMeasureWidth")) {
            this.comboBox.getProperties().put((Object)"comboBoxRowsToMeasureWidth", checkComboBox.getProperties().get((Object)"comboBoxRowsToMeasureWidth"));
        }
        this.selectedIndices.addListener(change -> this.buttonCell.updateIndex(0));
        this.getChildren().add(this.comboBox);
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.comboBox.minWidth(d2);
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.comboBox.minHeight(d2);
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.comboBox.prefWidth(d2);
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.comboBox.prefHeight(d2);
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((CheckComboBox)this.getSkinnable()).prefWidth(d2);
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((CheckComboBox)this.getSkinnable()).prefHeight(d2);
    }

    public void show() {
        this.comboBox.show();
    }

    public void hide() {
        this.comboBox.hide();
    }

    protected String getTextString() {
        if (this.control.getTitle() != null) {
            String string = this.control.getTitle();
            if (this.control.isShowCheckedCount()) {
                string = String.format("%s (%d/%d)", string, this.selectedItems.size(), this.items.size());
            }
            return string;
        }
        return this.buildString();
    }

    private String buildString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.selectedItems.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            T t2 = this.selectedItems.get(i2);
            if (this.control.getConverter() == null) {
                stringBuilder.append(t2);
            } else {
                stringBuilder.append(this.control.getConverter().toString(t2));
            }
            if (i2 >= n2 - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private Skin<?> createComboBoxListViewSkin(ComboBox<T> comboBox) {
        ComboBoxListViewSkin comboBoxListViewSkin = new ComboBoxListViewSkin(comboBox);
        comboBoxListViewSkin.setHideOnClick(false);
        ListView listView = (ListView)comboBoxListViewSkin.getPopupContent();
        listView.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.SPACE) {
                IndexedCheckModel<Object> indexedCheckModel;
                Object object = listView.getSelectionModel().getSelectedItem();
                if (object != null && (indexedCheckModel = this.control.getCheckModel()) != null) {
                    indexedCheckModel.toggleCheckState(object);
                }
            } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                this.hide();
            } else if (keyEvent.getCode() == KeyCode.TAB || new KeyCodeCombination(KeyCode.TAB, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY}).match(keyEvent)) {
                keyEvent.consume();
                listView.requestFocus();
                this.hide();
                this.control.fireEvent(keyEvent);
            } else if (keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.RIGHT) {
                keyEvent.consume();
            }
        });
        return comboBoxListViewSkin;
    }
}

