/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.i18n;

import java.nio.file.Path;
import java.util.Locale;

public class Translation
implements Comparable<Translation> {
    private final String localeString;
    private final Locale locale;
    private final Path path;

    public Translation(String string, Path path) {
        this.localeString = string;
        this.path = path;
        String[] stringArray = this.localeString.split("_");
        if (stringArray.length == 1) {
            this.locale = new Locale(this.localeString);
        } else if (stringArray.length == 2) {
            this.locale = new Locale(stringArray[0], stringArray[1]);
        } else if (stringArray.length == 3) {
            this.locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
        } else {
            throw new IllegalArgumentException("Unknown locale string '" + string + "'");
        }
    }

    public final String getLocaleString() {
        return this.localeString;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final Path getPath() {
        return this.path;
    }

    public String toString() {
        return this.localeString;
    }

    @Override
    public int compareTo(Translation translation) {
        if (translation == null) {
            return 1;
        }
        return this.localeString.compareTo(translation.localeString);
    }
}

