/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableListBase;

public abstract class ReadOnlyUnbackedObservableList<E>
extends ObservableListBase<E> {
    public void callObservers(ListChangeListener.Change<E> change) {
        this.fireChange(change);
    }

    public abstract E get(int var1);

    public abstract int size();

    public int indexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            E e2 = this.get(i2);
            if (!object.equals(e2)) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            E e2 = this.get(i2);
            if (!object.equals(e2)) continue;
            return i2;
        }
        return -1;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public ListIterator<E> listIterator() {
        return new SelectionListIterator(this);
    }

    public ListIterator<E> listIterator(int n2) {
        return new SelectionListIterator(this, n2);
    }

    public Iterator<E> iterator() {
        return new SelectionListIterator(this);
    }

    public List<E> subList(int n2, int n3) {
        if (n2 < 0 || n3 > this.size() || n2 > n3) {
            throw new IndexOutOfBoundsException("[ fromIndex: " + n2 + ", toIndex: " + n3 + ", size: " + this.size() + " ]");
        }
        ReadOnlyUnbackedObservableList readOnlyUnbackedObservableList = this;
        return new ReadOnlyUnbackedObservableList<E>((List)((Object)readOnlyUnbackedObservableList), n2, n3){
            final /* synthetic */ List val$outer;
            final /* synthetic */ int val$fromIndex;
            final /* synthetic */ int val$toIndex;
            {
                this.val$outer = list;
                this.val$fromIndex = n2;
                this.val$toIndex = n3;
            }

            @Override
            public E get(int n2) {
                return this.val$outer.get(n2 + this.val$fromIndex);
            }

            @Override
            public int size() {
                return this.val$toIndex - this.val$fromIndex;
            }
        };
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        for (int i2 = 0; i2 < this.size(); ++i2) {
            objectArray[i2] = this.get(i2);
        }
        return objectArray;
    }

    public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = this.toArray();
        int n2 = objectArray.length;
        if (TArray.length < n2) {
            return Arrays.copyOf(objectArray, n2, TArray.getClass());
        }
        System.arraycopy(objectArray, 0, TArray, 0, n2);
        if (TArray.length > n2) {
            TArray[n2] = null;
        }
        return TArray;
    }

    public String toString() {
        Iterator<E> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        while (true) {
            E e2;
            stringBuilder.append((Object)((e2 = iterator.next()) == this ? "(this Collection)" : e2));
            if (!iterator.hasNext()) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
        }
    }

    public boolean add(E e2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void add(int n2, E e2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean addAll(int n2, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean addAll(E ... EArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public E set(int n2, E e2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean setAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean setAll(E ... EArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void clear() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public E remove(int n2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void remove(int n2, int n3) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean removeAll(E ... EArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean retainAll(E ... EArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    private static class SelectionListIterator<E>
    implements ListIterator<E> {
        private int index;
        private final ReadOnlyUnbackedObservableList<E> list;

        public SelectionListIterator(ReadOnlyUnbackedObservableList<E> readOnlyUnbackedObservableList) {
            this(readOnlyUnbackedObservableList, 0);
        }

        public SelectionListIterator(ReadOnlyUnbackedObservableList<E> readOnlyUnbackedObservableList, int n2) {
            this.list = readOnlyUnbackedObservableList;
            this.index = n2;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public E next() {
            return this.list.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E previous() {
            return this.list.get(this.index--);
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void set(E e2) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void add(E e2) {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

