/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.autocompletion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.util.Callback;
import org.controlsfx.control.textfield.AutoCompletionBinding;

public abstract class SuggestionProvider<T>
implements Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> {
    private final List<T> possibleSuggestions = new ArrayList<T>();
    private final Object possibleSuggestionsLock = new Object();
    private final BooleanProperty showAllIfEmptyProperty = new SimpleBooleanProperty(false);

    public final BooleanProperty showAllIfEmptyProperty() {
        return this.showAllIfEmptyProperty;
    }

    public final boolean isShowAllIfEmpty() {
        return this.showAllIfEmptyProperty.get();
    }

    public final void setShowAllIfEmpty(boolean bl2) {
        this.showAllIfEmptyProperty.set(bl2);
    }

    public void addPossibleSuggestions(T ... TArray) {
        this.addPossibleSuggestions((Collection<T>)Arrays.asList(TArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPossibleSuggestions(Collection<T> collection) {
        Object object = this.possibleSuggestionsLock;
        synchronized (object) {
            this.possibleSuggestions.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSuggestions() {
        Object object = this.possibleSuggestionsLock;
        synchronized (object) {
            this.possibleSuggestions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> call(AutoCompletionBinding.ISuggestionRequest iSuggestionRequest) {
        ArrayList<T> arrayList = new ArrayList<T>();
        if (!iSuggestionRequest.getUserText().isEmpty()) {
            Object object = this.possibleSuggestionsLock;
            synchronized (object) {
                for (T t2 : this.possibleSuggestions) {
                    if (!this.isMatch(t2, iSuggestionRequest)) continue;
                    arrayList.add(t2);
                }
            }
            Collections.sort(arrayList, this.getComparator());
        } else if (this.isShowAllIfEmpty()) {
            Object object = this.possibleSuggestionsLock;
            synchronized (object) {
                arrayList.addAll(this.possibleSuggestions);
            }
        }
        return arrayList;
    }

    protected abstract Comparator<T> getComparator();

    protected abstract boolean isMatch(T var1, AutoCompletionBinding.ISuggestionRequest var2);

    public static <T> SuggestionProvider<T> create(Collection<T> collection) {
        return SuggestionProvider.create(null, collection);
    }

    public static <T> SuggestionProvider<T> create(Callback<T, String> callback, Collection<T> collection) {
        SuggestionProviderString<T> suggestionProviderString = new SuggestionProviderString<T>(callback);
        suggestionProviderString.addPossibleSuggestions(collection);
        return suggestionProviderString;
    }

    private static class SuggestionProviderString<T>
    extends SuggestionProvider<T> {
        private Callback<T, String> stringConverter;
        private final Comparator<T> stringComparator = new Comparator<T>(){

            @Override
            public int compare(T t2, T t3) {
                String string = (String)stringConverter.call(t2);
                String string2 = (String)stringConverter.call(t3);
                return string.compareTo(string2);
            }
        };

        public SuggestionProviderString(Callback<T, String> callback) {
            this.stringConverter = callback;
            if (this.stringConverter == null) {
                this.stringConverter = new Callback<T, String>(){

                    public String call(T t2) {
                        return t2 != null ? t2.toString() : "";
                    }
                };
            }
        }

        @Override
        protected Comparator<T> getComparator() {
            return this.stringComparator;
        }

        @Override
        protected boolean isMatch(T t2, AutoCompletionBinding.ISuggestionRequest iSuggestionRequest) {
            String string = iSuggestionRequest.getUserText().toLowerCase();
            String string2 = ((String)this.stringConverter.call(t2)).toLowerCase();
            return string2.contains(string);
        }
    }
}

