/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.autocompletion;

import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;

public class AutoCompletionTextFieldBinding<T>
extends AutoCompletionBinding<T> {
    private StringConverter<T> converter;
    private final ChangeListener<String> textChangeListener = new ChangeListener<String>(){

        public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
            if (AutoCompletionTextFieldBinding.this.getCompletionTarget().isFocused()) {
                AutoCompletionTextFieldBinding.this.setUserInput(string2);
            }
        }
    };
    private final ChangeListener<Boolean> focusChangedListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl2, Boolean bl3) {
            if (!bl3.booleanValue()) {
                AutoCompletionTextFieldBinding.this.hidePopup();
            }
        }
    };

    private static <T> StringConverter<T> defaultStringConverter() {
        return new StringConverter<T>(){

            public String toString(T t2) {
                return t2 == null ? null : t2.toString();
            }

            public T fromString(String string) {
                return string;
            }
        };
    }

    public AutoCompletionTextFieldBinding(TextField textField, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> callback) {
        this(textField, callback, AutoCompletionTextFieldBinding.defaultStringConverter());
    }

    public AutoCompletionTextFieldBinding(TextField textField, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> callback, StringConverter<T> stringConverter) {
        super((Node)textField, callback, stringConverter);
        this.converter = stringConverter;
        this.getCompletionTarget().textProperty().addListener(this.textChangeListener);
        this.getCompletionTarget().focusedProperty().addListener(this.focusChangedListener);
    }

    public TextField getCompletionTarget() {
        return (TextField)super.getCompletionTarget();
    }

    @Override
    public void dispose() {
        this.getCompletionTarget().textProperty().removeListener(this.textChangeListener);
        this.getCompletionTarget().focusedProperty().removeListener(this.focusChangedListener);
    }

    @Override
    protected void completeUserInput(T t2) {
        String string = this.converter.toString(t2);
        this.getCompletionTarget().setText(string);
        this.getCompletionTarget().positionCaret(string.length());
    }
}

