/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.glyphs;

import de.jensd.fx.glyphs.GlyphIcon;
import de.jensd.fx.glyphs.GlyphStackIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.layout.StackPane;

public abstract class GlyphStackIcon<T extends Enum<T>, V extends GlyphIcon, W extends Enum<W>>
extends StackPane {
    public static final double DEFAULT_ICON_SIZE = 32.0;
    public static final String GLYPH_ICON_STACK = "glyph-icon-stack";
    private StringProperty glyphStyle;
    private ObjectProperty<String> glyphName;
    private DoubleProperty glyphSize;

    public GlyphStackIcon() {
        this(null, 32.0);
    }

    public GlyphStackIcon(T t2) {
        this(t2, 32.0);
    }

    public GlyphStackIcon(T t2, double d2) {
        T t3 = t2;
        if (t3 == null) {
            t3 = this.getDefaultGlyph();
        }
        this.getStyleClass().addAll((Object[])new String[]{"root", GLYPH_ICON_STACK, ((Enum)t3).name().toLowerCase()});
        this.setMinSize(d2, d2);
        this.setPrefSize(d2, d2);
        this.setPrefSize(-1.0, -1.0);
        this.initBindings();
        this.initValues(t3, d2);
    }

    private void initBindings() {
        this.glyphSizeProperty().addListener(observable -> this.updateSize());
        this.glyphStyleProperty().addListener(observable -> this.updateStyle());
        this.glyphNameProperty().addListener(observable -> this.updateIcon());
    }

    private void initValues(T t2, double d2) {
        for (int i2 = 0; i2 < ((GlyphStackIcons)t2).getGlyphs().length; ++i2) {
            Enum enum_ = ((GlyphStackIcons)t2).getGlyphs()[i2];
            V v2 = this.getGlyph(enum_, d2);
            v2.getStyleClass().add((Object)("glyph-icon-stack-" + i2));
            this.getChildren().add(v2);
        }
    }

    private void updateSize() {
        this.getChildren().stream().filter(node -> node instanceof GlyphIcon).forEach(node -> ((GlyphIcon)((Object)node)).setGlyphSize(this.getGlyphSize()));
        this.setMinSize(this.getGlyphSize(), this.getGlyphSize());
    }

    private void updateStyle() {
        this.setStyle(this.getGlyphStyle());
    }

    private void updateIcon() {
        this.getChildren().stream().filter(node -> node instanceof GlyphIcon).forEach(node -> ((GlyphIcon)((Object)node)).updateIcon());
    }

    public abstract T getDefaultGlyph();

    protected abstract V getGlyph(W var1, double var2);

    public final ObjectProperty<String> glyphNameProperty() {
        if (this.glyphName == null) {
            this.glyphName = new SimpleStyleableObjectProperty(StyleableProperties.GLYPH_NAME, (Object)this, "glyphName");
        }
        return this.glyphName;
    }

    public final String getGlyphName() {
        return (String)this.glyphNameProperty().getValue();
    }

    public final void setGlyphName(String string) {
        this.glyphNameProperty().setValue((Object)string);
    }

    public final void setGlyph(T t2) {
        this.setGlyphName(((Enum)t2).name());
    }

    public final DoubleProperty glyphSizeProperty() {
        if (this.glyphSize == null) {
            this.glyphSize = new SimpleStyleableDoubleProperty(StyleableProperties.GLYPH_SIZE, (Object)this, "glyphSize");
            this.glyphSize.setValue((Number)32.0);
        }
        return this.glyphSize;
    }

    public final Double getGlyphSize() {
        return this.glyphSizeProperty().getValue();
    }

    public final void setGlyphSize(Double d2) {
        Double d3 = d2 == null ? 32.0 : d2;
        this.glyphSizeProperty().setValue((Number)d3);
    }

    public StringProperty glyphStyleProperty() {
        if (this.glyphStyle == null) {
            this.glyphStyle = new SimpleStringProperty("");
        }
        return this.glyphStyle;
    }

    public String getGlyphStyle() {
        return this.glyphStyleProperty().getValue();
    }

    public void setGlyphStyle(String string) {
        this.glyphStyleProperty().setValue(string);
    }

    public GlyphStackIcon setStyleClass(String string) {
        this.getStyleClass().add((Object)string);
        return this;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return GlyphStackIcon.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<GlyphStackIcon, String> GLYPH_NAME = new CssMetaData<GlyphStackIcon, String>("-glyph-name", StyleConverter.getStringConverter(), "BLANK"){

            public boolean isSettable(GlyphStackIcon glyphStackIcon) {
                return glyphStackIcon.glyphName == null || !glyphStackIcon.glyphName.isBound();
            }

            public StyleableProperty<String> getStyleableProperty(GlyphStackIcon glyphStackIcon) {
                return (StyleableProperty)glyphStackIcon.glyphNameProperty();
            }

            public String getInitialValue(GlyphStackIcon glyphStackIcon) {
                return "BLANK";
            }
        };
        private static final CssMetaData<GlyphStackIcon, Number> GLYPH_SIZE = new CssMetaData<GlyphStackIcon, Number>("-glyph-size", StyleConverter.getSizeConverter(), (Number)32.0){

            public boolean isSettable(GlyphStackIcon glyphStackIcon) {
                return glyphStackIcon.glyphSize == null || !glyphStackIcon.glyphSize.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(GlyphStackIcon glyphStackIcon) {
                return (StyleableProperty)glyphStackIcon.glyphSizeProperty();
            }

            public Number getInitialValue(GlyphStackIcon glyphStackIcon) {
                return 32.0;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(StackPane.getClassCssMetaData());
            Collections.addAll(arrayList, GLYPH_NAME, GLYPH_SIZE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

