/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import java.util.AbstractList;
import java.util.Arrays;

public final class CollisionCheckStack<E>
extends AbstractList<E> {
    private Object[] data;
    private int[] next;
    private int size = 0;
    private boolean latestPushResult = false;
    private boolean useIdentity = true;
    private final int[] initialHash = new int[17];

    public CollisionCheckStack() {
        this.data = new Object[16];
        this.next = new int[16];
    }

    public void setUseIdentity(boolean bl2) {
        this.useIdentity = bl2;
    }

    public boolean getUseIdentity() {
        return this.useIdentity;
    }

    public boolean getLatestPushResult() {
        return this.latestPushResult;
    }

    public boolean push(E e2) {
        if (this.data.length == this.size) {
            this.expandCapacity();
        }
        this.data[this.size] = e2;
        int n2 = this.hash(e2);
        boolean bl2 = this.findDuplicate(e2, n2);
        this.next[this.size] = this.initialHash[n2];
        this.initialHash[n2] = this.size + 1;
        ++this.size;
        this.latestPushResult = bl2;
        return this.latestPushResult;
    }

    public void pushNocheck(E e2) {
        if (this.data.length == this.size) {
            this.expandCapacity();
        }
        this.data[this.size] = e2;
        this.next[this.size] = -1;
        ++this.size;
    }

    public boolean findDuplicate(E e2) {
        int n2 = this.hash(e2);
        return this.findDuplicate(e2, n2);
    }

    @Override
    public E get(int n2) {
        return (E)this.data[n2];
    }

    @Override
    public int size() {
        return this.size;
    }

    private int hash(Object object) {
        return ((this.useIdentity ? System.identityHashCode(object) : object.hashCode()) & Integer.MAX_VALUE) % this.initialHash.length;
    }

    public E pop() {
        --this.size;
        Object object = this.data[this.size];
        this.data[this.size] = null;
        int n2 = this.next[this.size];
        if (n2 >= 0) {
            int n3 = this.hash(object);
            assert (this.initialHash[n3] == this.size + 1);
            this.initialHash[n3] = n2;
        }
        return (E)object;
    }

    public E peek() {
        return (E)this.data[this.size - 1];
    }

    private boolean findDuplicate(E e2, int n2) {
        int n3 = this.initialHash[n2];
        while (n3 != 0) {
            Object object = this.data[--n3];
            if (this.useIdentity ? object == e2 : e2.equals(object)) {
                return true;
            }
            n3 = this.next[n3];
        }
        return false;
    }

    private void expandCapacity() {
        int n2 = this.data.length;
        int n3 = n2 * 2;
        Object[] objectArray = new Object[n3];
        int[] nArray = new int[n3];
        System.arraycopy(this.data, 0, objectArray, 0, n2);
        System.arraycopy(this.next, 0, nArray, 0, n2);
        this.data = objectArray;
        this.next = nArray;
    }

    public void reset() {
        if (this.size > 0) {
            this.size = 0;
            Arrays.fill(this.initialHash, 0);
        }
    }

    public String getCycleString() {
        E e2;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.size() - 1;
        E e3 = this.get(n2);
        stringBuilder.append(e3);
        do {
            stringBuilder.append(" -> ");
            e2 = this.get(--n2);
            stringBuilder.append(e2);
        } while (e3 != e2);
        return stringBuilder.toString();
    }
}

