/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.SAXParseException2;
import com.sun.xml.bind.IDResolver;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.api.ClassResolver;
import com.sun.xml.bind.unmarshaller.InfosetScanner;
import com.sun.xml.bind.v2.ClassFactory;
import com.sun.xml.bind.v2.runtime.AssociationMap;
import com.sun.xml.bind.v2.runtime.Coordinator;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.unmarshaller.Intercepter;
import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorExWrapper;
import com.sun.xml.bind.v2.runtime.unmarshaller.Messages;
import com.sun.xml.bind.v2.runtime.unmarshaller.Patcher;
import com.sun.xml.bind.v2.runtime.unmarshaller.Receiver;
import com.sun.xml.bind.v2.runtime.unmarshaller.Scope;
import com.sun.xml.bind.v2.runtime.unmarshaller.StructureLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallerImpl;
import com.sun.xml.bind.v2.runtime.unmarshaller.XmlVisitor;
import com.sun.xml.bind.v2.runtime.unmarshaller.XsiNilLoader;
import com.sun.xml.bind.v2.runtime.unmarshaller.XsiTypeLoader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public final class UnmarshallingContext
extends Coordinator
implements NamespaceContext,
ValidationEventHandler,
ErrorHandler,
XmlVisitor,
XmlVisitor.TextPredictor {
    private static final Logger logger = Logger.getLogger(UnmarshallingContext.class.getName());
    private final State root;
    private State current;
    private static final LocatorEx DUMMY_INSTANCE;
    @NotNull
    private LocatorEx locator = DUMMY_INSTANCE;
    private Object result;
    private JaxBeanInfo expectedType;
    private IDResolver idResolver;
    private boolean isUnmarshalInProgress = true;
    private boolean aborted = false;
    public final UnmarshallerImpl parent;
    private final AssociationMap assoc;
    private boolean isInplaceMode;
    private InfosetScanner scanner;
    private Object currentElement;
    private NamespaceContext environmentNamespaceContext;
    @Nullable
    public ClassResolver classResolver;
    @Nullable
    public ClassLoader classLoader;
    private static volatile int errorsCounter;
    private final Map<Class, Factory> factories = new HashMap<Class, Factory>();
    private Patcher[] patchers = null;
    private int patchersLen = 0;
    private String[] nsBind = new String[16];
    private int nsLen = 0;
    private Scope[] scopes = new Scope[16];
    private int scopeTop = 0;
    private static final Loader DEFAULT_ROOT_LOADER;
    private static final Loader EXPECTED_TYPE_ROOT_LOADER;

    public UnmarshallingContext(UnmarshallerImpl unmarshallerImpl, AssociationMap associationMap) {
        for (int i2 = 0; i2 < this.scopes.length; ++i2) {
            this.scopes[i2] = new Scope(this);
        }
        this.parent = unmarshallerImpl;
        this.assoc = associationMap;
        this.root = this.current = new State(null);
    }

    public void reset(InfosetScanner infosetScanner, boolean bl2, JaxBeanInfo jaxBeanInfo, IDResolver iDResolver) {
        this.scanner = infosetScanner;
        this.isInplaceMode = bl2;
        this.expectedType = jaxBeanInfo;
        this.idResolver = iDResolver;
    }

    public JAXBContextImpl getJAXBContext() {
        return this.parent.context;
    }

    public State getCurrentState() {
        return this.current;
    }

    public Loader selectRootLoader(State state, TagName tagName) throws SAXException {
        try {
            Class<?> clazz;
            Loader loader = this.getJAXBContext().selectRootLoader(state, tagName);
            if (loader != null) {
                return loader;
            }
            if (this.classResolver != null && (clazz = this.classResolver.resolveElementName(tagName.uri, tagName.local)) != null) {
                JAXBContextImpl jAXBContextImpl = this.getJAXBContext().createAugmented(clazz);
                JaxBeanInfo<?> jaxBeanInfo = jAXBContextImpl.getBeanInfo(clazz);
                return jaxBeanInfo.getLoader(jAXBContextImpl, true);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
        return null;
    }

    public void clearStates() {
        State state = this.current;
        while (state.next != null) {
            state = state.next;
        }
        while (state.prev != null) {
            state.loader = null;
            state.nil = false;
            state.receiver = null;
            state.intercepter = null;
            state.elementDefaultValue = null;
            state.target = null;
            state = state.prev;
            state.next.prev = null;
            state.next = null;
        }
        this.current = state;
    }

    public void setFactories(Object object) {
        this.factories.clear();
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                this.addFactory(object2);
            }
        } else {
            this.addFactory(object);
        }
    }

    private void addFactory(Object object) {
        for (Method method : object.getClass().getMethods()) {
            if (!method.getName().startsWith("create") || method.getParameterTypes().length > 0) continue;
            Class<?> clazz = method.getReturnType();
            this.factories.put(clazz, new Factory(object, method));
        }
    }

    @Override
    public void startDocument(LocatorEx locatorEx, NamespaceContext namespaceContext) throws SAXException {
        if (locatorEx != null) {
            this.locator = locatorEx;
        }
        this.environmentNamespaceContext = namespaceContext;
        this.result = null;
        this.current = this.root;
        this.patchersLen = 0;
        this.aborted = false;
        this.isUnmarshalInProgress = true;
        this.nsLen = 0;
        if (this.expectedType != null) {
            this.root.loader = UnmarshallingContext.EXPECTED_TYPE_ROOT_LOADER;
        } else {
            this.root.loader = UnmarshallingContext.DEFAULT_ROOT_LOADER;
        }
        this.idResolver.startDocument(this);
    }

    @Override
    public void startElement(TagName tagName) throws SAXException {
        this.pushCoordinator();
        try {
            this._startElement(tagName);
        }
        finally {
            this.popCoordinator();
        }
    }

    private void _startElement(TagName tagName) throws SAXException {
        if (this.assoc != null) {
            this.currentElement = this.scanner.getCurrentElement();
        }
        Loader loader = this.current.loader;
        this.current.push();
        loader.childElement(this.current, tagName);
        assert (this.current.loader != null);
        this.current.loader.startElement(this.current, tagName);
    }

    @Override
    public void text(CharSequence charSequence) throws SAXException {
        this.pushCoordinator();
        try {
            if (this.current.elementDefaultValue != null && charSequence.length() == 0) {
                charSequence = this.current.elementDefaultValue;
            }
            this.current.loader.text(this.current, charSequence);
        }
        finally {
            this.popCoordinator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void endElement(TagName tagName) throws SAXException {
        this.pushCoordinator();
        try {
            State state = this.current;
            state.loader.leaveElement(state, tagName);
            Object object = state.target;
            Receiver receiver = state.receiver;
            Intercepter intercepter = state.intercepter;
            state.pop();
            if (intercepter != null) {
                object = intercepter.intercept(this.current, object);
            }
            if (receiver != null) {
                receiver.receive(this.current, object);
            }
        }
        finally {
            this.popCoordinator();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.runPatchers();
        this.idResolver.endDocument();
        this.isUnmarshalInProgress = false;
        this.currentElement = null;
        this.locator = DUMMY_INSTANCE;
        this.environmentNamespaceContext = null;
        assert (this.root == this.current);
    }

    @Override
    @Deprecated
    public boolean expectText() {
        return ((State)this.current).loader.expectText;
    }

    @Override
    @Deprecated
    public XmlVisitor.TextPredictor getPredictor() {
        return this;
    }

    @Override
    public UnmarshallingContext getContext() {
        return this;
    }

    public Object getResult() throws UnmarshalException {
        if (this.isUnmarshalInProgress) {
            throw new IllegalStateException();
        }
        if (!this.aborted) {
            return this.result;
        }
        throw new UnmarshalException((String)null);
    }

    void clearResult() {
        if (this.isUnmarshalInProgress) {
            throw new IllegalStateException();
        }
        this.result = null;
    }

    public Object createInstance(Class<?> clazz) throws SAXException {
        Factory factory;
        if (!this.factories.isEmpty() && (factory = this.factories.get(clazz)) != null) {
            return factory.createInstance();
        }
        return ClassFactory.create(clazz);
    }

    public Object createInstance(JaxBeanInfo jaxBeanInfo) throws SAXException {
        Factory factory;
        if (!this.factories.isEmpty() && (factory = this.factories.get(jaxBeanInfo.jaxbType)) != null) {
            return factory.createInstance();
        }
        try {
            return jaxBeanInfo.createInstance(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            Loader.reportError("Unable to create an instance of " + jaxBeanInfo.jaxbType.getName(), illegalAccessException, false);
        }
        catch (InvocationTargetException invocationTargetException) {
            Loader.reportError("Unable to create an instance of " + jaxBeanInfo.jaxbType.getName(), invocationTargetException, false);
        }
        catch (InstantiationException instantiationException) {
            Loader.reportError("Unable to create an instance of " + jaxBeanInfo.jaxbType.getName(), instantiationException, false);
        }
        return null;
    }

    public void handleEvent(ValidationEvent validationEvent, boolean bl2) throws SAXException {
        ValidationEventHandler validationEventHandler = this.parent.getEventHandler();
        boolean bl3 = validationEventHandler.handleEvent(validationEvent);
        if (!bl3) {
            this.aborted = true;
        }
        if (!bl2 || !bl3) {
            throw new SAXParseException2(validationEvent.getMessage(), this.locator, new UnmarshalException(validationEvent.getMessage(), validationEvent.getLinkedException()));
        }
    }

    @Override
    public boolean handleEvent(ValidationEvent validationEvent) {
        try {
            boolean bl2 = this.parent.getEventHandler().handleEvent(validationEvent);
            if (!bl2) {
                this.aborted = true;
            }
            return bl2;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public void handleError(Exception exception) throws SAXException {
        this.handleError(exception, true);
    }

    public void handleError(Exception exception, boolean bl2) throws SAXException {
        this.handleEvent(new ValidationEventImpl(1, exception.getMessage(), this.locator.getLocation(), exception), bl2);
    }

    public void handleError(String string) {
        this.handleEvent(new ValidationEventImpl(1, string, this.locator.getLocation()));
    }

    @Override
    protected ValidationEventLocator getLocation() {
        return this.locator.getLocation();
    }

    public LocatorEx getLocator() {
        return this.locator;
    }

    public void errorUnresolvedIDREF(Object object, String string, LocatorEx locatorEx) throws SAXException {
        this.handleEvent(new ValidationEventImpl(1, Messages.UNRESOLVED_IDREF.format(string), locatorEx.getLocation()), true);
    }

    public void addPatcher(Patcher patcher) {
        if (this.patchers == null) {
            this.patchers = new Patcher[32];
        }
        if (this.patchers.length == this.patchersLen) {
            Patcher[] patcherArray = new Patcher[this.patchersLen * 2];
            System.arraycopy(this.patchers, 0, patcherArray, 0, this.patchersLen);
            this.patchers = patcherArray;
        }
        this.patchers[this.patchersLen++] = patcher;
    }

    private void runPatchers() throws SAXException {
        if (this.patchers != null) {
            for (int i2 = 0; i2 < this.patchersLen; ++i2) {
                this.patchers[i2].run();
                this.patchers[i2] = null;
            }
        }
    }

    public String addToIdTable(String string) throws SAXException {
        Object object = this.current.target;
        if (object == null) {
            object = this.current.prev.target;
        }
        this.idResolver.bind(string, object);
        return string;
    }

    public Callable getObjectFromId(String string, Class clazz) throws SAXException {
        return this.idResolver.resolve(string, clazz);
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        if (this.nsBind.length == this.nsLen) {
            String[] stringArray = new String[this.nsLen * 2];
            System.arraycopy(this.nsBind, 0, stringArray, 0, this.nsLen);
            this.nsBind = stringArray;
        }
        this.nsBind[this.nsLen++] = string;
        this.nsBind[this.nsLen++] = string2;
    }

    @Override
    public void endPrefixMapping(String string) {
        this.nsLen -= 2;
    }

    private String resolveNamespacePrefix(String string) {
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i2 = this.nsLen - 2; i2 >= 0; i2 -= 2) {
            if (!string.equals(this.nsBind[i2])) continue;
            return this.nsBind[i2 + 1];
        }
        if (this.environmentNamespaceContext != null) {
            return this.environmentNamespaceContext.getNamespaceURI(string.intern());
        }
        if (string.equals("")) {
            return "";
        }
        return null;
    }

    public String[] getNewlyDeclaredPrefixes() {
        return this.getPrefixList(this.current.prev.numNsDecl);
    }

    public String[] getAllDeclaredPrefixes() {
        return this.getPrefixList(0);
    }

    private String[] getPrefixList(int n2) {
        int n3 = (this.current.numNsDecl - n2) / 2;
        String[] stringArray = new String[n3];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.nsBind[n2 + i2 * 2];
        }
        return stringArray;
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        return Collections.unmodifiableList(this.getAllPrefixesInList(string)).iterator();
    }

    private List<String> getAllPrefixesInList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            arrayList.add("xml");
            return arrayList;
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            arrayList.add("xmlns");
            return arrayList;
        }
        for (int i2 = this.nsLen - 2; i2 >= 0; i2 -= 2) {
            if (!string.equals(this.nsBind[i2 + 1]) || !this.getNamespaceURI(this.nsBind[i2]).equals(this.nsBind[i2 + 1])) continue;
            arrayList.add(this.nsBind[i2]);
        }
        return arrayList;
    }

    @Override
    public String getPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        for (int i2 = this.nsLen - 2; i2 >= 0; i2 -= 2) {
            if (!string.equals(this.nsBind[i2 + 1]) || !this.getNamespaceURI(this.nsBind[i2]).equals(this.nsBind[i2 + 1])) continue;
            return this.nsBind[i2];
        }
        if (this.environmentNamespaceContext != null) {
            return this.environmentNamespaceContext.getPrefix(string);
        }
        return null;
    }

    @Override
    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.resolveNamespacePrefix(string);
    }

    public void startScope(int n2) {
        this.scopeTop += n2;
        if (this.scopeTop >= this.scopes.length) {
            Scope[] scopeArray = new Scope[Math.max(this.scopeTop + 1, this.scopes.length * 2)];
            System.arraycopy(this.scopes, 0, scopeArray, 0, this.scopes.length);
            for (int i2 = this.scopes.length; i2 < scopeArray.length; ++i2) {
                scopeArray[i2] = new Scope(this);
            }
            this.scopes = scopeArray;
        }
    }

    public void endScope(int n2) throws SAXException {
        try {
            while (n2 > 0) {
                this.scopes[this.scopeTop].finish();
                --n2;
                --this.scopeTop;
            }
        }
        catch (AccessorException accessorException) {
            this.handleError(accessorException);
            while (n2 > 0) {
                this.scopes[this.scopeTop--] = new Scope(this);
                --n2;
            }
        }
    }

    public Scope getScope(int n2) {
        return this.scopes[this.scopeTop - n2];
    }

    public void recordInnerPeer(Object object) {
        if (this.assoc != null) {
            this.assoc.addInner(this.currentElement, object);
        }
    }

    public Object getInnerPeer() {
        if (this.assoc != null && this.isInplaceMode) {
            return this.assoc.getInnerPeer(this.currentElement);
        }
        return null;
    }

    public void recordOuterPeer(Object object) {
        if (this.assoc != null) {
            this.assoc.addOuter(this.currentElement, object);
        }
    }

    public Object getOuterPeer() {
        if (this.assoc != null && this.isInplaceMode) {
            return this.assoc.getOuterPeer(this.currentElement);
        }
        return null;
    }

    public String getXMIMEContentType() {
        Object object = this.current.target;
        if (object == null) {
            return null;
        }
        return this.getJAXBContext().getXMIMEContentType(object);
    }

    public static UnmarshallingContext getInstance() {
        return (UnmarshallingContext)Coordinator._getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QName> getCurrentExpectedElements() {
        this.pushCoordinator();
        try {
            State state = this.getCurrentState();
            Loader loader = state.loader;
            Collection<QName> collection = loader != null ? loader.getExpectedChildElements() : null;
            return collection;
        }
        finally {
            this.popCoordinator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QName> getCurrentExpectedAttributes() {
        this.pushCoordinator();
        try {
            State state = this.getCurrentState();
            Loader loader = state.loader;
            Collection<QName> collection = loader != null ? loader.getExpectedAttributes() : null;
            return collection;
        }
        finally {
            this.popCoordinator();
        }
    }

    public StructureLoader getStructureLoader() {
        if (this.current.loader instanceof StructureLoader) {
            return (StructureLoader)this.current.loader;
        }
        return null;
    }

    public boolean shouldErrorBeReported() throws SAXException {
        if (logger.isLoggable(Level.FINEST)) {
            return true;
        }
        if (errorsCounter >= 0 && --errorsCounter == 0) {
            this.handleEvent(new ValidationEventImpl(0, Messages.ERRORS_LIMIT_EXCEEDED.format(new Object[0]), this.getLocator().getLocation(), null), true);
        }
        return errorsCounter >= 0;
    }

    static {
        LocatorImpl locatorImpl = new LocatorImpl();
        locatorImpl.setPublicId(null);
        locatorImpl.setSystemId(null);
        locatorImpl.setLineNumber(-1);
        locatorImpl.setColumnNumber(-1);
        DUMMY_INSTANCE = new LocatorExWrapper(locatorImpl);
        errorsCounter = 10;
        DEFAULT_ROOT_LOADER = new DefaultRootLoader();
        EXPECTED_TYPE_ROOT_LOADER = new ExpectedTypeRootLoader();
    }

    private static final class ExpectedTypeRootLoader
    extends Loader
    implements Receiver {
        private ExpectedTypeRootLoader() {
        }

        @Override
        public void childElement(State state, TagName tagName) {
            UnmarshallingContext unmarshallingContext = state.getContext();
            QName qName = new QName(tagName.uri, tagName.local);
            state.prev.target = new JAXBElement<Object>(qName, ((UnmarshallingContext)unmarshallingContext).expectedType.jaxbType, null, null);
            state.receiver = this;
            state.loader = new XsiNilLoader(unmarshallingContext.expectedType.getLoader(null, true));
        }

        @Override
        public void receive(State state, Object object) {
            JAXBElement jAXBElement = (JAXBElement)state.target;
            jAXBElement.setValue(object);
            state.getContext().recordOuterPeer(jAXBElement);
            state.getContext().result = jAXBElement;
        }
    }

    private static final class DefaultRootLoader
    extends Loader
    implements Receiver {
        private DefaultRootLoader() {
        }

        @Override
        public void childElement(State state, TagName tagName) throws SAXException {
            Loader loader = state.getContext().selectRootLoader(state, tagName);
            if (loader != null) {
                state.loader = loader;
                state.receiver = this;
                return;
            }
            JaxBeanInfo jaxBeanInfo = XsiTypeLoader.parseXsiType(state, tagName, null);
            if (jaxBeanInfo == null) {
                this.reportUnexpectedChildElement(tagName, false);
                return;
            }
            state.loader = jaxBeanInfo.getLoader(null, false);
            state.prev.backup = new JAXBElement<Object>(tagName.createQName(), Object.class, null);
            state.receiver = this;
        }

        @Override
        public Collection<QName> getExpectedChildElements() {
            return UnmarshallingContext.getInstance().getJAXBContext().getValidRootNames();
        }

        @Override
        public void receive(State state, Object object) {
            if (state.backup != null) {
                ((JAXBElement)state.backup).setValue(object);
                object = state.backup;
            }
            if (state.nil) {
                ((JAXBElement)object).setNil(true);
            }
            state.getContext().result = object;
        }
    }

    private static class Factory {
        private final Object factorInstance;
        private final Method method;

        public Factory(Object object, Method method) {
            this.factorInstance = object;
            this.method = method;
        }

        public Object createInstance() throws SAXException {
            try {
                return this.method.invoke(this.factorInstance, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                UnmarshallingContext.getInstance().handleError(illegalAccessException, false);
            }
            catch (InvocationTargetException invocationTargetException) {
                UnmarshallingContext.getInstance().handleError(invocationTargetException, false);
            }
            return null;
        }
    }

    public final class State {
        private Loader loader;
        private Receiver receiver;
        private Intercepter intercepter;
        private Object target;
        private Object backup;
        private int numNsDecl;
        private String elementDefaultValue;
        private State prev;
        private State next;
        private boolean nil = false;
        private boolean mixed = false;

        public UnmarshallingContext getContext() {
            return UnmarshallingContext.this;
        }

        private State(State state) {
            this.prev = state;
            if (state != null) {
                state.next = this;
                if (state.mixed) {
                    this.mixed = true;
                }
            }
        }

        private void push() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "State.push");
            }
            if (this.next == null) {
                assert (UnmarshallingContext.this.current == this);
                this.next = new State(this);
            }
            this.nil = false;
            State state = this.next;
            state.numNsDecl = UnmarshallingContext.this.nsLen;
            UnmarshallingContext.this.current = state;
        }

        private void pop() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "State.pop");
            }
            assert (this.prev != null);
            this.loader = null;
            this.nil = false;
            this.mixed = false;
            this.receiver = null;
            this.intercepter = null;
            this.elementDefaultValue = null;
            this.target = null;
            UnmarshallingContext.this.current = this.prev;
            this.next = null;
        }

        public boolean isMixed() {
            return this.mixed;
        }

        public Object getTarget() {
            return this.target;
        }

        public void setLoader(Loader loader) {
            if (loader instanceof StructureLoader) {
                this.mixed = !((StructureLoader)loader).getBeanInfo().hasElementOnlyContentModel();
            }
            this.loader = loader;
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }

        public State getPrev() {
            return this.prev;
        }

        public void setIntercepter(Intercepter intercepter) {
            this.intercepter = intercepter;
        }

        public void setBackup(Object object) {
            this.backup = object;
        }

        public void setTarget(Object object) {
            this.target = object;
        }

        public Object getBackup() {
            return this.backup;
        }

        public boolean isNil() {
            return this.nil;
        }

        public void setNil(boolean bl2) {
            this.nil = bl2;
        }

        public Loader getLoader() {
            return this.loader;
        }

        public String getElementDefaultValue() {
            return this.elementDefaultValue;
        }

        public void setElementDefaultValue(String string) {
            this.elementDefaultValue = string;
        }
    }
}

