/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import javax.xml.bind.annotation.DomHandler;
import javax.xml.transform.Result;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;

public class DomLoader<ResultT extends Result>
extends Loader {
    private final DomHandler<?, ResultT> dom;

    public DomLoader(DomHandler<?, ResultT> domHandler) {
        super(true);
        this.dom = domHandler;
    }

    @Override
    public void startElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
        UnmarshallingContext unmarshallingContext = state.getContext();
        if (state.getTarget() == null) {
            state.setTarget(new State(unmarshallingContext));
        }
        State state2 = (State)state.getTarget();
        try {
            state2.declarePrefixes(unmarshallingContext, unmarshallingContext.getNewlyDeclaredPrefixes());
            state2.handler.startElement(tagName.uri, tagName.local, tagName.getQname(), tagName.atts);
        }
        catch (SAXException sAXException) {
            unmarshallingContext.handleError(sAXException);
            throw sAXException;
        }
    }

    @Override
    public void childElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
        state.setLoader(this);
        State state2 = (State)state.getPrev().getTarget();
        ++state2.depth;
        state.setTarget(state2);
    }

    @Override
    public void text(UnmarshallingContext.State state, CharSequence charSequence) throws SAXException {
        if (charSequence.length() == 0) {
            return;
        }
        try {
            State state2 = (State)state.getTarget();
            state2.handler.characters(charSequence.toString().toCharArray(), 0, charSequence.length());
        }
        catch (SAXException sAXException) {
            state.getContext().handleError(sAXException);
            throw sAXException;
        }
    }

    @Override
    public void leaveElement(UnmarshallingContext.State state, TagName tagName) throws SAXException {
        State state2 = (State)state.getTarget();
        UnmarshallingContext unmarshallingContext = state.getContext();
        try {
            state2.handler.endElement(tagName.uri, tagName.local, tagName.getQname());
            state2.undeclarePrefixes(unmarshallingContext.getNewlyDeclaredPrefixes());
        }
        catch (SAXException sAXException) {
            unmarshallingContext.handleError(sAXException);
            throw sAXException;
        }
        if (--state2.depth == 0) {
            try {
                state2.undeclarePrefixes(unmarshallingContext.getAllDeclaredPrefixes());
                state2.handler.endDocument();
            }
            catch (SAXException sAXException) {
                unmarshallingContext.handleError(sAXException);
                throw sAXException;
            }
            state.setTarget(state2.getElement());
        }
    }

    private final class State {
        private TransformerHandler handler = null;
        private final ResultT result;
        int depth = 1;

        public State(UnmarshallingContext unmarshallingContext) throws SAXException {
            this.handler = JAXBContextImpl.createTransformerHandler(unmarshallingContext.getJAXBContext().disableSecurityProcessing);
            this.result = DomLoader.this.dom.createUnmarshaller(unmarshallingContext);
            this.handler.setResult((Result)this.result);
            try {
                this.handler.setDocumentLocator(unmarshallingContext.getLocator());
                this.handler.startDocument();
                this.declarePrefixes(unmarshallingContext, unmarshallingContext.getAllDeclaredPrefixes());
            }
            catch (SAXException sAXException) {
                unmarshallingContext.handleError(sAXException);
                throw sAXException;
            }
        }

        public Object getElement() {
            return DomLoader.this.dom.getElement(this.result);
        }

        private void declarePrefixes(UnmarshallingContext unmarshallingContext, String[] stringArray) throws SAXException {
            for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                String string = unmarshallingContext.getNamespaceURI(stringArray[i2]);
                if (string == null) {
                    throw new IllegalStateException("prefix '" + stringArray[i2] + "' isn't bound");
                }
                this.handler.startPrefixMapping(stringArray[i2], string);
            }
        }

        private void undeclarePrefixes(String[] stringArray) throws SAXException {
            for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                this.handler.endPrefixMapping(stringArray[i2]);
            }
        }
    }
}

