/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.NamespaceContext2;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.output.XmlOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public final class NamespaceContextImpl
implements NamespaceContext2 {
    private final XMLSerializer owner;
    private String[] prefixes = new String[4];
    private String[] nsUris = new String[4];
    private int size;
    private Element current;
    private final Element top;
    private NamespacePrefixMapper prefixMapper = defaultNamespacePrefixMapper;
    public boolean collectionMode;
    private static final NamespacePrefixMapper defaultNamespacePrefixMapper = new NamespacePrefixMapper(){

        @Override
        public String getPreferredPrefix(String string, String string2, boolean bl2) {
            if (string.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                return "xsi";
            }
            if (string.equals("http://www.w3.org/2001/XMLSchema")) {
                return "xs";
            }
            if (string.equals("http://www.w3.org/2005/05/xmlmime")) {
                return "xmime";
            }
            return string2;
        }
    };

    public NamespaceContextImpl(XMLSerializer xMLSerializer) {
        this.owner = xMLSerializer;
        this.current = this.top = new Element(this, null);
        this.put("http://www.w3.org/XML/1998/namespace", "xml");
    }

    public void setPrefixMapper(NamespacePrefixMapper namespacePrefixMapper) {
        if (namespacePrefixMapper == null) {
            namespacePrefixMapper = defaultNamespacePrefixMapper;
        }
        this.prefixMapper = namespacePrefixMapper;
    }

    public NamespacePrefixMapper getPrefixMapper() {
        return this.prefixMapper;
    }

    public void reset() {
        this.current = this.top;
        this.size = 1;
        this.collectionMode = false;
    }

    public int declareNsUri(String string, String string2, boolean bl2) {
        string2 = this.prefixMapper.getPreferredPrefix(string, string2, bl2);
        if (string.length() == 0) {
            for (int i2 = this.size - 1; i2 >= 0; --i2) {
                if (this.nsUris[i2].length() == 0) {
                    return i2;
                }
                if (this.prefixes[i2].length() != 0) continue;
                assert (this.current.defaultPrefixIndex == -1 && this.current.oldDefaultNamespaceUriIndex == -1);
                String string3 = this.nsUris[i2];
                String[] stringArray = this.owner.nameList.namespaceURIs;
                if (this.current.baseIndex <= i2) {
                    this.nsUris[i2] = "";
                    int n2 = this.put(string3, null);
                    for (int i3 = stringArray.length - 1; i3 >= 0; --i3) {
                        if (!stringArray[i3].equals(string3)) continue;
                        this.owner.knownUri2prefixIndexMap[i3] = n2;
                        break;
                    }
                    if (this.current.elementLocalName != null) {
                        this.current.setTagName(n2, this.current.elementLocalName, this.current.getOuterPeer());
                    }
                    return i2;
                }
                for (int i4 = stringArray.length - 1; i4 >= 0; --i4) {
                    if (!stringArray[i4].equals(string3)) continue;
                    this.current.defaultPrefixIndex = i2;
                    this.current.oldDefaultNamespaceUriIndex = i4;
                    this.owner.knownUri2prefixIndexMap[i4] = this.size;
                    break;
                }
                if (this.current.elementLocalName != null) {
                    this.current.setTagName(this.size, this.current.elementLocalName, this.current.getOuterPeer());
                }
                this.put(this.nsUris[i2], null);
                return this.put("", "");
            }
            return this.put("", "");
        }
        for (int i5 = this.size - 1; i5 >= 0; --i5) {
            String string4 = this.prefixes[i5];
            if (this.nsUris[i5].equals(string) && (!bl2 || string4.length() > 0)) {
                return i5;
            }
            if (!string4.equals(string2)) continue;
            string2 = null;
        }
        if (string2 == null && bl2) {
            string2 = this.makeUniquePrefix();
        }
        return this.put(string, string2);
    }

    @Override
    public int force(@NotNull String string, @NotNull String string2) {
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (!this.prefixes[i2].equals(string2)) continue;
            if (!this.nsUris[i2].equals(string)) break;
            return i2;
        }
        return this.put(string, string2);
    }

    public int put(@NotNull String string, @Nullable String string2) {
        if (this.size == this.nsUris.length) {
            String[] stringArray = new String[this.nsUris.length * 2];
            String[] stringArray2 = new String[this.prefixes.length * 2];
            System.arraycopy(this.nsUris, 0, stringArray, 0, this.nsUris.length);
            System.arraycopy(this.prefixes, 0, stringArray2, 0, this.prefixes.length);
            this.nsUris = stringArray;
            this.prefixes = stringArray2;
        }
        if (string2 == null) {
            string2 = this.size == 1 ? "" : this.makeUniquePrefix();
        }
        this.nsUris[this.size] = string;
        this.prefixes[this.size] = string2;
        return this.size++;
    }

    private String makeUniquePrefix() {
        String string = new StringBuilder(5).append("ns").append(this.size).toString();
        while (this.getNamespaceURI(string) != null) {
            string = string + '_';
        }
        return string;
    }

    public Element getCurrent() {
        return this.current;
    }

    public int getPrefixIndex(String string) {
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (!this.nsUris[i2].equals(string)) continue;
            return i2;
        }
        throw new IllegalStateException();
    }

    public String getPrefix(int n2) {
        return this.prefixes[n2];
    }

    public String getNamespaceURI(int n2) {
        return this.nsUris[n2];
    }

    @Override
    public String getNamespaceURI(String string) {
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (!this.prefixes[i2].equals(string)) continue;
            return this.nsUris[i2];
        }
        return null;
    }

    @Override
    public String getPrefix(String string) {
        if (this.collectionMode) {
            return this.declareNamespace(string, null, false);
        }
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (!this.nsUris[i2].equals(string)) continue;
            return this.prefixes[i2];
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        String string2 = this.getPrefix(string);
        if (string2 == null) {
            return Collections.emptySet().iterator();
        }
        return Collections.singleton(string).iterator();
    }

    @Override
    public String declareNamespace(String string, String string2, boolean bl2) {
        int n2 = this.declareNsUri(string, string2, bl2);
        return this.getPrefix(n2);
    }

    public int count() {
        return this.size;
    }

    public final class Element {
        public final NamespaceContextImpl context;
        private final Element prev;
        private Element next;
        private int oldDefaultNamespaceUriIndex;
        private int defaultPrefixIndex;
        private int baseIndex;
        private final int depth;
        private int elementNamePrefix;
        private String elementLocalName;
        private Name elementName;
        private Object outerPeer;
        private Object innerPeer;

        private Element(NamespaceContextImpl namespaceContextImpl2, Element element) {
            this.context = namespaceContextImpl2;
            this.prev = element;
            this.depth = element == null ? 0 : element.depth + 1;
        }

        public boolean isRootElement() {
            return this.depth == 1;
        }

        public Element push() {
            if (this.next == null) {
                this.next = new Element(this.context, this);
            }
            this.next.onPushed();
            return this.next;
        }

        public Element pop() {
            if (this.oldDefaultNamespaceUriIndex >= 0) {
                ((NamespaceContextImpl)this.context).owner.knownUri2prefixIndexMap[this.oldDefaultNamespaceUriIndex] = this.defaultPrefixIndex;
            }
            this.context.size = this.baseIndex;
            this.context.current = this.prev;
            this.innerPeer = null;
            this.outerPeer = null;
            return this.prev;
        }

        private void onPushed() {
            this.defaultPrefixIndex = -1;
            this.oldDefaultNamespaceUriIndex = -1;
            this.baseIndex = this.context.size;
            this.context.current = this;
        }

        public void setTagName(int n2, String string, Object object) {
            assert (string != null);
            this.elementNamePrefix = n2;
            this.elementLocalName = string;
            this.elementName = null;
            this.outerPeer = object;
        }

        public void setTagName(Name name, Object object) {
            assert (name != null);
            this.elementName = name;
            this.outerPeer = object;
        }

        public void startElement(XmlOutput xmlOutput, Object object) throws IOException, XMLStreamException {
            this.innerPeer = object;
            if (this.elementName != null) {
                xmlOutput.beginStartTag(this.elementName);
            } else {
                xmlOutput.beginStartTag(this.elementNamePrefix, this.elementLocalName);
            }
        }

        public void endElement(XmlOutput xmlOutput) throws IOException, SAXException, XMLStreamException {
            if (this.elementName != null) {
                xmlOutput.endTag(this.elementName);
                this.elementName = null;
            } else {
                xmlOutput.endTag(this.elementNamePrefix, this.elementLocalName);
            }
        }

        public final int count() {
            return this.context.size - this.baseIndex;
        }

        public final String getPrefix(int n2) {
            return this.context.prefixes[this.baseIndex + n2];
        }

        public final String getNsUri(int n2) {
            return this.context.nsUris[this.baseIndex + n2];
        }

        public int getBase() {
            return this.baseIndex;
        }

        public Object getOuterPeer() {
            return this.outerPeer;
        }

        public Object getInnerPeer() {
            return this.innerPeer;
        }

        public Element getParent() {
            return this.prev;
        }
    }
}

