/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.xml.bind.v2.runtime.output.UTF8XmlOutput;
import java.io.IOException;

public final class Encoded {
    public byte[] buf;
    public int len;
    private static final byte[][] entities = new byte[128][];
    private static final byte[][] attributeEntities = new byte[128][];

    public Encoded() {
    }

    public Encoded(String string) {
        this.set(string);
    }

    public void ensureSize(int n2) {
        if (this.buf == null || this.buf.length < n2) {
            this.buf = new byte[n2];
        }
    }

    public final void set(String string) {
        int n2 = string.length();
        this.ensureSize(n2 * 3 + 1);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u007f') {
                if (c2 > '\u07ff') {
                    if ('\ud800' <= c2 && c2 <= '\udfff') {
                        int n4 = ((c2 & 0x3FF) << 10 | string.charAt(++i2) & 0x3FF) + 65536;
                        this.buf[n3++] = (byte)(0xF0 | n4 >> 18);
                        this.buf[n3++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                        this.buf[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                        this.buf[n3++] = (byte)(128 + (n4 & 0x3F));
                        continue;
                    }
                    this.buf[n3++] = (byte)(224 + (c2 >> 12));
                    this.buf[n3++] = (byte)(128 + (c2 >> 6 & 0x3F));
                } else {
                    this.buf[n3++] = (byte)(192 + (c2 >> 6));
                }
                this.buf[n3++] = (byte)(128 + (c2 & 0x3F));
                continue;
            }
            this.buf[n3++] = (byte)c2;
        }
        this.len = n3;
    }

    public final void setEscape(String string, boolean bl2) {
        int n2 = string.length();
        this.ensureSize(n2 * 6 + 1);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            int n4 = n3;
            if (c2 > '\u007f') {
                if (c2 > '\u07ff') {
                    if ('\ud800' <= c2 && c2 <= '\udfff') {
                        int n5 = ((c2 & 0x3FF) << 10 | string.charAt(++i2) & 0x3FF) + 65536;
                        this.buf[n3++] = (byte)(0xF0 | n5 >> 18);
                        this.buf[n3++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                        this.buf[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                        this.buf[n3++] = (byte)(128 + (n5 & 0x3F));
                        continue;
                    }
                    this.buf[n4++] = (byte)(224 + (c2 >> 12));
                    this.buf[n4++] = (byte)(128 + (c2 >> 6 & 0x3F));
                } else {
                    this.buf[n4++] = (byte)(192 + (c2 >> 6));
                }
                this.buf[n4++] = (byte)(128 + (c2 & 0x3F));
            } else {
                byte[] byArray = attributeEntities[c2];
                if (byArray != null) {
                    if (bl2 || entities[c2] != null) {
                        n4 = this.writeEntity(byArray, n4);
                    } else {
                        this.buf[n4++] = (byte)c2;
                    }
                } else {
                    this.buf[n4++] = (byte)c2;
                }
            }
            n3 = n4;
        }
        this.len = n3;
    }

    private int writeEntity(byte[] byArray, int n2) {
        System.arraycopy(byArray, 0, this.buf, n2, byArray.length);
        return n2 + byArray.length;
    }

    public final void write(UTF8XmlOutput uTF8XmlOutput) throws IOException {
        uTF8XmlOutput.write(this.buf, 0, this.len);
    }

    public void append(char c2) {
        this.buf[this.len++] = (byte)c2;
    }

    public void compact() {
        byte[] byArray = new byte[this.len];
        System.arraycopy(this.buf, 0, byArray, 0, this.len);
        this.buf = byArray;
    }

    private static void add(char c2, String string, boolean bl2) {
        byte[] byArray = UTF8XmlOutput.toBytes(string);
        Encoded.attributeEntities[c2] = byArray;
        if (!bl2) {
            Encoded.entities[c2] = byArray;
        }
    }

    static {
        Encoded.add('&', "&amp;", false);
        Encoded.add('<', "&lt;", false);
        Encoded.add('>', "&gt;", false);
        Encoded.add('\"', "&quot;", true);
        Encoded.add('\t', "&#x9;", true);
        Encoded.add('\r', "&#xD;", false);
        Encoded.add('\n', "&#xA;", true);
    }
}

