/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class NameUtil {
    protected static final int UPPER_LETTER = 0;
    protected static final int LOWER_LETTER = 1;
    protected static final int OTHER_LETTER = 2;
    protected static final int DIGIT = 3;
    protected static final int OTHER = 4;
    private static final byte[] actionTable = new byte[25];
    private static final byte ACTION_CHECK_PUNCT = 0;
    private static final byte ACTION_CHECK_C2 = 1;
    private static final byte ACTION_BREAK = 2;
    private static final byte ACTION_NOBREAK = 3;

    NameUtil() {
    }

    protected boolean isPunct(char c2) {
        return c2 == '-' || c2 == '.' || c2 == ':' || c2 == '_' || c2 == '\u00b7' || c2 == '\u0387' || c2 == '\u06dd' || c2 == '\u06de';
    }

    protected static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9' || Character.isDigit(c2);
    }

    protected static boolean isUpper(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || Character.isUpperCase(c2);
    }

    protected static boolean isLower(char c2) {
        return c2 >= 'a' && c2 <= 'z' || Character.isLowerCase(c2);
    }

    protected boolean isLetter(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || Character.isLetter(c2);
    }

    private String toLowerCase(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    private String toUpperCase(char c2) {
        return String.valueOf(c2).toUpperCase(Locale.ENGLISH);
    }

    private String toUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public String capitalize(String string) {
        if (!NameUtil.isLower(string.charAt(0))) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(this.toUpperCase(string.charAt(0)));
        stringBuilder.append(this.toLowerCase(string.substring(1)));
        return stringBuilder.toString();
    }

    private int nextBreak(String string, int n2) {
        int n3 = string.length();
        char c2 = string.charAt(n2);
        int n4 = this.classify(c2);
        block5: for (int i2 = n2 + 1; i2 < n3; ++i2) {
            int n5 = n4;
            c2 = string.charAt(i2);
            n4 = this.classify(c2);
            switch (actionTable[n5 * 5 + n4]) {
                case 0: {
                    if (!this.isPunct(c2)) continue block5;
                    return i2;
                }
                case 1: {
                    char c3;
                    if (i2 >= n3 - 1 || !NameUtil.isLower(c3 = string.charAt(i2 + 1))) continue block5;
                    return i2;
                }
                case 2: {
                    return i2;
                }
            }
        }
        return -1;
    }

    private static byte decideAction(int n2, int n3) {
        if (n2 == 4 && n3 == 4) {
            return 0;
        }
        if (!NameUtil.xor(n2 == 3, n3 == 3)) {
            return 2;
        }
        if (n2 == 1 && n3 != 1) {
            return 2;
        }
        if (!NameUtil.xor(n2 <= 2, n3 <= 2)) {
            return 2;
        }
        if (!NameUtil.xor(n2 == 2, n3 == 2)) {
            return 2;
        }
        if (n2 == 0 && n3 == 0) {
            return 1;
        }
        return 3;
    }

    private static boolean xor(boolean bl2, boolean bl3) {
        return bl2 && bl3 || !bl2 && !bl3;
    }

    protected int classify(char c2) {
        switch (Character.getType(c2)) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 9: {
                return 3;
            }
        }
        return 4;
    }

    public List<String> toWordList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            while (n3 < n2 && this.isPunct(string.charAt(n3))) {
                ++n3;
            }
            if (n3 >= n2) break;
            int n4 = this.nextBreak(string, n3);
            String string2 = n4 == -1 ? string.substring(n3) : string.substring(n3, n4);
            arrayList.add(NameUtil.escape(this.capitalize(string2)));
            if (n4 == -1) break;
            n3 = n4;
        }
        return arrayList;
    }

    protected String toMixedCaseName(List<String> list, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!list.isEmpty()) {
            stringBuilder.append(bl2 ? list.get(0) : this.toLowerCase(list.get(0)));
            for (int i2 = 1; i2 < list.size(); ++i2) {
                stringBuilder.append(list.get(i2));
            }
        }
        return stringBuilder.toString();
    }

    protected String toMixedCaseVariableName(String[] stringArray, boolean bl2, boolean bl3) {
        if (bl3) {
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                stringArray[i2] = this.capitalize(stringArray[i2]);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder.append(bl2 ? stringArray[0] : this.toLowerCase(stringArray[0]));
            for (int i3 = 1; i3 < stringArray.length; ++i3) {
                stringBuilder.append(stringArray[i3]);
            }
        }
        return stringBuilder.toString();
    }

    public String toConstantName(String string) {
        return this.toConstantName(this.toWordList(string));
    }

    public String toConstantName(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!list.isEmpty()) {
            stringBuilder.append(this.toUpperCase(list.get(0)));
            for (int i2 = 1; i2 < list.size(); ++i2) {
                stringBuilder.append('_');
                stringBuilder.append(this.toUpperCase(list.get(i2)));
            }
        }
        return stringBuilder.toString();
    }

    public static void escape(StringBuilder stringBuilder, String string, int n2) {
        int n3 = string.length();
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isJavaIdentifierPart(c2)) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append('_');
            if (c2 <= '\u000f') {
                stringBuilder.append("000");
            } else if (c2 <= '\u00ff') {
                stringBuilder.append("00");
            } else if (c2 <= '\u0fff') {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toString(c2, 16));
        }
    }

    private static String escape(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isJavaIdentifierPart(string.charAt(i2))) continue;
            StringBuilder stringBuilder = new StringBuilder(string.substring(0, i2));
            NameUtil.escape(stringBuilder, string, i2);
            return stringBuilder.toString();
        }
        return string;
    }

    static {
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int i3 = 0; i3 < 5; ++i3) {
                NameUtil.actionTable[i2 * 5 + i3] = NameUtil.decideAction(i2, i3);
            }
        }
    }
}

