/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapParseException;
import com.sun.activation.registries.MailcapTokenizer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MailcapFile {
    private Map type_hash = new HashMap();
    private Map fallback_hash = new HashMap();
    private Map native_commands = new HashMap();
    private static boolean addReverse = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailcapFile(String string) throws IOException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: file " + string);
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            this.parse(new BufferedReader(fileReader));
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public MailcapFile(InputStream inputStream) throws IOException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: InputStream");
        }
        this.parse(new BufferedReader(new InputStreamReader(inputStream, "iso-8859-1")));
    }

    public MailcapFile() {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: default");
        }
    }

    public Map getMailcapList(String string) {
        String string2;
        Map map = null;
        Map map2 = null;
        map = (Map)this.type_hash.get(string);
        int n2 = string.indexOf(47);
        String string3 = string.substring(n2 + 1);
        if (!string3.equals("*") && (map2 = (Map)this.type_hash.get(string2 = string.substring(0, n2 + 1) + "*")) != null) {
            map = map != null ? this.mergeResults(map, map2) : map2;
        }
        return map;
    }

    public Map getMailcapFallbackList(String string) {
        String string2;
        Map map = null;
        Map map2 = null;
        map = (Map)this.fallback_hash.get(string);
        int n2 = string.indexOf(47);
        String string3 = string.substring(n2 + 1);
        if (!string3.equals("*") && (map2 = (Map)this.fallback_hash.get(string2 = string.substring(0, n2 + 1) + "*")) != null) {
            map = map != null ? this.mergeResults(map, map2) : map2;
        }
        return map;
    }

    public String[] getMimeTypes() {
        HashSet hashSet = new HashSet(this.type_hash.keySet());
        hashSet.addAll(this.fallback_hash.keySet());
        hashSet.addAll(this.native_commands.keySet());
        String[] stringArray = new String[hashSet.size()];
        stringArray = hashSet.toArray(stringArray);
        return stringArray;
    }

    public String[] getNativeCommands(String string) {
        String[] stringArray = null;
        List list = (List)this.native_commands.get(string.toLowerCase(Locale.ENGLISH));
        if (list != null) {
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
        }
        return stringArray;
    }

    private Map mergeResults(Map map, Map map2) {
        Iterator iterator = map2.keySet().iterator();
        HashMap hashMap = new HashMap(map);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            if (arrayList == null) {
                hashMap.put(string, map2.get(string));
                continue;
            }
            List list = (List)map2.get(string);
            arrayList = new ArrayList(arrayList);
            arrayList.addAll(list);
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    public void appendToMailcap(String string) {
        if (LogSupport.isLoggable()) {
            LogSupport.log("appendToMailcap: " + string);
        }
        try {
            this.parse(new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parse(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            string = string.trim();
            try {
                if (string.charAt(0) == '#') continue;
                if (string.charAt(string.length() - 1) == '\\') {
                    if (string2 != null) {
                        string2 = string2 + string.substring(0, string.length() - 1);
                        continue;
                    }
                    string2 = string.substring(0, string.length() - 1);
                    continue;
                }
                if (string2 != null) {
                    string2 = string2 + string;
                    try {
                        this.parseLine(string2);
                    }
                    catch (MailcapParseException mailcapParseException) {
                        // empty catch block
                    }
                    string2 = null;
                    continue;
                }
                try {
                    this.parseLine(string);
                }
                catch (MailcapParseException mailcapParseException) {
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
    }

    protected void parseLine(String string) throws MailcapParseException, IOException {
        int n2;
        MailcapTokenizer mailcapTokenizer = new MailcapTokenizer(string);
        mailcapTokenizer.setIsAutoquoting(false);
        if (LogSupport.isLoggable()) {
            LogSupport.log("parse: " + string);
        }
        if ((n2 = mailcapTokenizer.nextToken()) != 2) {
            MailcapFile.reportParseError(2, n2, mailcapTokenizer.getCurrentTokenValue());
        }
        String string2 = mailcapTokenizer.getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
        String string3 = "*";
        n2 = mailcapTokenizer.nextToken();
        if (n2 != 47 && n2 != 59) {
            MailcapFile.reportParseError(47, 59, n2, mailcapTokenizer.getCurrentTokenValue());
        }
        if (n2 == 47) {
            n2 = mailcapTokenizer.nextToken();
            if (n2 != 2) {
                MailcapFile.reportParseError(2, n2, mailcapTokenizer.getCurrentTokenValue());
            }
            string3 = mailcapTokenizer.getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
            n2 = mailcapTokenizer.nextToken();
        }
        String string4 = string2 + "/" + string3;
        if (LogSupport.isLoggable()) {
            LogSupport.log("  Type: " + string4);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (n2 != 59) {
            MailcapFile.reportParseError(59, n2, mailcapTokenizer.getCurrentTokenValue());
        }
        mailcapTokenizer.setIsAutoquoting(true);
        n2 = mailcapTokenizer.nextToken();
        mailcapTokenizer.setIsAutoquoting(false);
        if (n2 != 2 && n2 != 59) {
            MailcapFile.reportParseError(2, 59, n2, mailcapTokenizer.getCurrentTokenValue());
        }
        if (n2 == 2) {
            ArrayList<String> arrayList = (ArrayList<String>)this.native_commands.get(string4);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                arrayList.add(string);
                this.native_commands.put(string4, arrayList);
            } else {
                arrayList.add(string);
            }
        }
        if (n2 != 59) {
            n2 = mailcapTokenizer.nextToken();
        }
        if (n2 == 59) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            boolean bl2 = false;
            do {
                if ((n2 = mailcapTokenizer.nextToken()) != 2) {
                    MailcapFile.reportParseError(2, n2, mailcapTokenizer.getCurrentTokenValue());
                }
                object4 = mailcapTokenizer.getCurrentTokenValue().toLowerCase(Locale.ENGLISH);
                n2 = mailcapTokenizer.nextToken();
                if (n2 != 61 && n2 != 59 && n2 != 5) {
                    MailcapFile.reportParseError(61, 59, 5, n2, mailcapTokenizer.getCurrentTokenValue());
                }
                if (n2 != 61) continue;
                mailcapTokenizer.setIsAutoquoting(true);
                n2 = mailcapTokenizer.nextToken();
                mailcapTokenizer.setIsAutoquoting(false);
                if (n2 != 2) {
                    MailcapFile.reportParseError(2, n2, mailcapTokenizer.getCurrentTokenValue());
                }
                object3 = mailcapTokenizer.getCurrentTokenValue();
                if (((String)object4).startsWith("x-java-")) {
                    object2 = ((String)object4).substring(7);
                    if (((String)object2).equals("fallback-entry") && ((String)object3).equalsIgnoreCase("true")) {
                        bl2 = true;
                    } else {
                        if (LogSupport.isLoggable()) {
                            LogSupport.log("    Command: " + object2 + ", Class: " + (String)object3);
                        }
                        if ((object = (List)linkedHashMap.get(object2)) == null) {
                            object = new ArrayList<Object>();
                            linkedHashMap.put(object2, (ArrayList<Object>)object);
                        }
                        if (addReverse) {
                            object.add(0, object3);
                        } else {
                            object.add(object3);
                        }
                    }
                }
                n2 = mailcapTokenizer.nextToken();
            } while (n2 == 59);
            object4 = bl2 ? this.fallback_hash : this.type_hash;
            object3 = (Map)object4.get(string4);
            if (object3 == null) {
                object4.put(string4, linkedHashMap);
            } else {
                List list;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("Merging commands for type " + string4);
                }
                object2 = object3.keySet().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    list = (List)object3.get(object);
                    List list2 = (List)linkedHashMap.get(object);
                    if (list2 == null) continue;
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        String string5 = (String)iterator.next();
                        if (list.contains(string5)) continue;
                        if (addReverse) {
                            list.add(0, string5);
                            continue;
                        }
                        list.add(string5);
                    }
                }
                object2 = linkedHashMap.keySet().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (object3.containsKey(object)) continue;
                    list = (List)linkedHashMap.get(object);
                    object3.put(object, list);
                }
            }
        } else if (n2 != 5) {
            MailcapFile.reportParseError(5, 59, n2, mailcapTokenizer.getCurrentTokenValue());
        }
    }

    protected static void reportParseError(int n2, int n3, String string) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n3) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n2) + " token.");
    }

    protected static void reportParseError(int n2, int n3, int n4, String string) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n4) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n2) + " or a " + MailcapTokenizer.nameForToken(n3) + " token.");
    }

    protected static void reportParseError(int n2, int n3, int n4, int n5, String string) throws MailcapParseException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("PARSE ERROR: Encountered a " + MailcapTokenizer.nameForToken(n5) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n2) + ", a " + MailcapTokenizer.nameForToken(n3) + ", or a " + MailcapTokenizer.nameForToken(n4) + " token.");
        }
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(n5) + " token (" + string + ") while expecting a " + MailcapTokenizer.nameForToken(n2) + ", a " + MailcapTokenizer.nameForToken(n3) + ", or a " + MailcapTokenizer.nameForToken(n4) + " token.");
    }

    static {
        try {
            addReverse = Boolean.getBoolean("javax.activation.addreverse");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

