/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.utils;

import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.animation.PauseTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class JFXNodeUtils {
    public static void updateBackground(Background background, Region region) {
        JFXNodeUtils.updateBackground(background, region, (Paint)Color.BLACK);
    }

    public static void updateBackground(Background background, Region region, Paint paint) {
        if (background != null && !background.getFills().isEmpty()) {
            BackgroundFill[] backgroundFillArray = new BackgroundFill[background.getFills().size()];
            for (int i2 = 0; i2 < background.getFills().size(); ++i2) {
                BackgroundFill backgroundFill = (BackgroundFill)background.getFills().get(i2);
                backgroundFillArray[i2] = new BackgroundFill(paint, backgroundFill.getRadii(), backgroundFill.getInsets());
            }
            region.setBackground(new Background(backgroundFillArray));
        }
    }

    public static String colorToHex(Color color) {
        if (color != null) {
            return String.format((Locale)null, "#%02x%02x%02x", Math.round(color.getRed() * 255.0), Math.round(color.getGreen() * 255.0), Math.round(color.getBlue() * 255.0)).toUpperCase();
        }
        return null;
    }

    public static void addPressAndHoldHandler(Node node, Duration duration, EventHandler<MouseEvent> eventHandler) {
        Wrapper wrapper = new Wrapper();
        PauseTransition pauseTransition = new PauseTransition(duration);
        pauseTransition.setOnFinished(actionEvent -> eventHandler.handle((Event)((MouseEvent)wrapper.content)));
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            wrapper.content = mouseEvent;
            pauseTransition.playFromStart();
        });
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> pauseTransition.stop());
        node.addEventHandler(MouseEvent.DRAG_DETECTED, mouseEvent -> pauseTransition.stop());
    }

    public static void addPressAndHoldFilter(Node node, Duration duration, EventHandler<MouseEvent> eventHandler) {
        Wrapper wrapper = new Wrapper();
        PauseTransition pauseTransition = new PauseTransition(duration);
        pauseTransition.setOnFinished(actionEvent -> eventHandler.handle((Event)((MouseEvent)wrapper.content)));
        node.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            wrapper.content = mouseEvent;
            pauseTransition.playFromStart();
        });
        node.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> pauseTransition.stop());
        node.addEventFilter(MouseEvent.DRAG_DETECTED, mouseEvent -> pauseTransition.stop());
    }

    public static <T> InvalidationListener addDelayedPropertyInvalidationListener(ObservableValue<T> observableValue, Duration duration, Consumer<T> consumer) {
        Wrapper wrapper = new Wrapper();
        PauseTransition pauseTransition = new PauseTransition(duration);
        pauseTransition.setOnFinished(actionEvent -> consumer.accept(wrapper.content));
        InvalidationListener invalidationListener = observable -> {
            wrapper.content = observableValue.getValue();
            pauseTransition.playFromStart();
        };
        observableValue.addListener(invalidationListener);
        return invalidationListener;
    }

    public static <T> InvalidationListener addDelayedPropertyInvalidationListener(ObservableValue<T> observableValue, Duration duration, BiConsumer<T, InvalidationListener> biConsumer) {
        Wrapper wrapper = new Wrapper();
        PauseTransition pauseTransition = new PauseTransition(duration);
        InvalidationListener invalidationListener = observable -> {
            wrapper.content = observableValue.getValue();
            pauseTransition.playFromStart();
        };
        pauseTransition.setOnFinished(actionEvent -> biConsumer.accept(wrapper.content, invalidationListener));
        observableValue.addListener(invalidationListener);
        return invalidationListener;
    }

    public static <T> InvalidationListener addDelayedPropertyInvalidationListener(ObservableValue<T> observableValue, Duration duration, Consumer<T> consumer, Consumer<T> consumer2) {
        Wrapper wrapper = new Wrapper();
        PauseTransition pauseTransition = new PauseTransition(duration);
        pauseTransition.setOnFinished(actionEvent -> consumer2.accept(wrapper.content));
        InvalidationListener invalidationListener = observable -> {
            wrapper.content = observableValue.getValue();
            consumer.accept(wrapper.content);
            pauseTransition.playFromStart();
        };
        observableValue.addListener(invalidationListener);
        return invalidationListener;
    }

    public static <T extends Event> EventHandler<? super T> addDelayedEventHandler(Node node, Duration duration, EventType<T> eventType, EventHandler<? super T> eventHandler) {
        Wrapper wrapper = new Wrapper();
        PauseTransition pauseTransition = new PauseTransition(duration);
        pauseTransition.setOnFinished(actionEvent -> eventHandler.handle((Event)wrapper.content));
        EventHandler eventHandler2 = event -> {
            wrapper.content = event;
            pauseTransition.playFromStart();
        };
        node.addEventHandler(eventType, eventHandler2);
        return eventHandler2;
    }

    private static class Wrapper<T> {
        T content;

        private Wrapper() {
        }
    }
}

