/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions;

import com.jfoenix.transitions.CacheMemento;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javafx.animation.AnimationTimer;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.util.Duration;

public class JFXAnimationTimer
extends AnimationTimer {
    private Set<AnimationHandler> animationHandlers = new HashSet<AnimationHandler>();
    private long startTime = -1L;
    private boolean running = false;
    private List<CacheMemento> caches = new ArrayList<CacheMemento>();
    private double totalElapsedMilliseconds;
    private HashMap<JFXKeyFrame, AnimationHandler> mutableFrames = new HashMap();
    private Runnable onFinished = null;

    public JFXAnimationTimer(JFXKeyFrame ... jFXKeyFrameArray) {
        for (JFXKeyFrame jFXKeyFrame : jFXKeyFrameArray) {
            Duration duration = jFXKeyFrame.getDuration();
            Set<JFXKeyValue<?>> set = jFXKeyFrame.getValues();
            if (set.isEmpty()) continue;
            this.animationHandlers.add(new AnimationHandler(duration, jFXKeyFrame.getAnimateCondition(), jFXKeyFrame.getValues()));
        }
    }

    public void addKeyFrame(JFXKeyFrame jFXKeyFrame) throws Exception {
        if (this.isRunning()) {
            throw new Exception("Can't update animation timer while running");
        }
        Duration duration = jFXKeyFrame.getDuration();
        Set<JFXKeyValue<?>> set = jFXKeyFrame.getValues();
        if (!set.isEmpty()) {
            AnimationHandler animationHandler = new AnimationHandler(duration, jFXKeyFrame.getAnimateCondition(), jFXKeyFrame.getValues());
            this.animationHandlers.add(animationHandler);
            this.mutableFrames.put(jFXKeyFrame, animationHandler);
        }
    }

    public void removeKeyFrame(JFXKeyFrame jFXKeyFrame) throws Exception {
        if (this.isRunning()) {
            throw new Exception("Can't update animation timer while running");
        }
        AnimationHandler animationHandler = this.mutableFrames.get(jFXKeyFrame);
        this.animationHandlers.remove(animationHandler);
    }

    public void start() {
        super.start();
        this.running = true;
        this.startTime = -1L;
        for (AnimationHandler object : this.animationHandlers) {
            object.init();
        }
        for (CacheMemento cacheMemento : this.caches) {
            cacheMemento.cache();
        }
    }

    public void handle(long l2) {
        this.startTime = this.startTime == -1L ? l2 : this.startTime;
        this.totalElapsedMilliseconds = (double)(l2 - this.startTime) / 1000000.0;
        boolean bl2 = true;
        for (AnimationHandler animationHandler : this.animationHandlers) {
            animationHandler.animate(this.totalElapsedMilliseconds);
            if (animationHandler.finished) continue;
            bl2 = false;
        }
        if (bl2) {
            this.stop();
        }
    }

    public void reverseAndContinue() {
        if (this.isRunning()) {
            super.stop();
            for (AnimationHandler animationHandler : this.animationHandlers) {
                animationHandler.reverse(this.totalElapsedMilliseconds);
            }
            this.startTime = -1L;
            super.start();
        } else {
            this.start();
        }
    }

    public void stop() {
        super.stop();
        this.running = false;
        for (AnimationHandler object : this.animationHandlers) {
            object.clear();
        }
        for (CacheMemento cacheMemento : this.caches) {
            cacheMemento.restore();
        }
        if (this.onFinished != null) {
            this.onFinished.run();
        }
    }

    public void applyEndValues() {
        if (this.isRunning()) {
            super.stop();
        }
        for (AnimationHandler animationHandler : this.animationHandlers) {
            animationHandler.applyEndValues();
        }
        this.startTime = -1L;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setOnFinished(Runnable runnable) {
        this.onFinished = runnable;
    }

    public void setCacheNodes(Node ... nodeArray) {
        this.caches.clear();
        if (nodeArray != null) {
            for (Node node : nodeArray) {
                this.caches.add(new CacheMemento(node));
            }
        }
    }

    public void dispose() {
        this.caches.clear();
        for (AnimationHandler animationHandler : this.animationHandlers) {
            animationHandler.dispose();
        }
        this.animationHandlers.clear();
    }

    static class AnimationHandler {
        private double duration;
        private double currentDuration;
        private Set<JFXKeyValue<?>> keyValues;
        private Supplier<Boolean> animationCondition = null;
        private boolean finished = false;
        private HashMap<WritableValue<?>, Object> initialValuesMap = new HashMap();
        private HashMap<WritableValue<?>, Object> endValuesMap = new HashMap();

        AnimationHandler(Duration duration, Supplier<Boolean> supplier, Set<JFXKeyValue<?>> set) {
            this.currentDuration = this.duration = duration.toMillis();
            this.keyValues = set;
            this.animationCondition = supplier;
        }

        public void init() {
            this.finished = this.animationCondition == null ? false : this.animationCondition.get() == false;
            for (JFXKeyValue<?> jFXKeyValue : this.keyValues) {
                if (jFXKeyValue.getTarget() == null) continue;
                if (!this.initialValuesMap.containsKey(jFXKeyValue.getTarget())) {
                    this.initialValuesMap.put(jFXKeyValue.getTarget(), jFXKeyValue.getTarget().getValue());
                }
                if (this.endValuesMap.containsKey(jFXKeyValue.getTarget())) continue;
                this.endValuesMap.put(jFXKeyValue.getTarget(), jFXKeyValue.getEndValue());
            }
        }

        void reverse(double d2) {
            this.finished = this.animationCondition == null ? false : this.animationCondition.get() == false;
            this.currentDuration = this.duration - (this.currentDuration - d2);
            for (JFXKeyValue<?> jFXKeyValue : this.keyValues) {
                WritableValue<?> writableValue = jFXKeyValue.getTarget();
                if (writableValue == null) continue;
                this.initialValuesMap.put(writableValue, writableValue.getValue());
                this.endValuesMap.put(writableValue, jFXKeyValue.getEndValue());
            }
        }

        public void animate(double d2) {
            if (this.finished) {
                return;
            }
            if (d2 <= this.currentDuration) {
                for (JFXKeyValue<?> jFXKeyValue : this.keyValues) {
                    WritableValue<?> writableValue;
                    Object object;
                    if (!jFXKeyValue.isValid() || (object = this.endValuesMap.get(writableValue = jFXKeyValue.getTarget())) == null || writableValue == null || writableValue.getValue().equals(object)) continue;
                    writableValue.setValue(jFXKeyValue.getInterpolator().interpolate(this.initialValuesMap.get(writableValue), object, d2 / this.currentDuration));
                }
            } else if (!this.finished) {
                this.finished = true;
                for (JFXKeyValue<?> jFXKeyValue : this.keyValues) {
                    Object obj;
                    WritableValue<?> writableValue;
                    if (!jFXKeyValue.isValid() || (writableValue = jFXKeyValue.getTarget()) == null || (obj = jFXKeyValue.getEndValue()) == null) continue;
                    writableValue.setValue(obj);
                }
                this.currentDuration = this.duration;
            }
        }

        public void applyEndValues() {
            for (JFXKeyValue<?> jFXKeyValue : this.keyValues) {
                Object obj;
                WritableValue<?> writableValue;
                if (!jFXKeyValue.isValid() || (writableValue = jFXKeyValue.getTarget()) == null || (obj = jFXKeyValue.getEndValue()) == null || writableValue.getValue().equals(obj)) continue;
                writableValue.setValue(obj);
            }
        }

        public void clear() {
            this.initialValuesMap.clear();
            this.endValuesMap.clear();
        }

        void dispose() {
            this.clear();
            this.keyValues.clear();
        }
    }
}

