/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXToggleButton;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import javafx.animation.Interpolator;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.skin.ToggleButtonSkin;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.util.Duration;

public class JFXToggleButtonSkin
extends ToggleButtonSkin {
    private Runnable releaseManualRippler = null;
    private JFXAnimationTimer timer;
    private final Circle circle;
    private final Line line;

    public JFXToggleButtonSkin(JFXToggleButton jFXToggleButton) {
        super((ToggleButton)jFXToggleButton);
        double d2 = jFXToggleButton.getSize();
        this.line = new Line();
        this.line.setStroke(((ToggleButton)this.getSkinnable()).isSelected() ? jFXToggleButton.getToggleLineColor() : jFXToggleButton.getUnToggleLineColor());
        this.line.setStartX(0.0);
        this.line.setStartY(0.0);
        this.line.setEndX(d2 * 2.0 + 2.0);
        this.line.setEndY(0.0);
        this.line.setStrokeWidth(d2 * 1.5);
        this.line.setStrokeLineCap(StrokeLineCap.ROUND);
        this.line.setSmooth(true);
        this.circle = new Circle();
        this.circle.setFill(((ToggleButton)this.getSkinnable()).isSelected() ? jFXToggleButton.getToggleColor() : jFXToggleButton.getUnToggleColor());
        this.circle.setCenterX(-d2);
        this.circle.setCenterY(0.0);
        this.circle.setRadius(d2);
        this.circle.setSmooth(true);
        JFXDepthManager.setDepth((Node)this.circle, 1);
        StackPane stackPane = new StackPane();
        stackPane.getChildren().add((Object)this.circle);
        stackPane.setPadding(new Insets(d2 * 1.5));
        JFXRippler jFXRippler = new JFXRippler((Node)stackPane, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK);
        jFXRippler.setRipplerFill(((ToggleButton)this.getSkinnable()).isSelected() ? jFXToggleButton.getToggleLineColor() : jFXToggleButton.getUnToggleLineColor());
        jFXRippler.setTranslateX(this.computeTranslation(d2, this.line));
        StackPane stackPane2 = new StackPane();
        stackPane2.getChildren().setAll((Object[])new Node[]{this.line, jFXRippler});
        stackPane2.setCursor(Cursor.HAND);
        ((ToggleButton)this.getSkinnable()).armedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.releaseManualRippler = jFXRippler.createManualRipple();
            } else if (this.releaseManualRippler != null) {
                this.releaseManualRippler.run();
            }
        });
        jFXToggleButton.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (!jFXToggleButton.isDisableVisualFocus().booleanValue()) {
                if (bl3.booleanValue()) {
                    if (!((ToggleButton)this.getSkinnable()).isPressed()) {
                        jFXRippler.setOverlayVisible(true);
                    }
                } else {
                    jFXRippler.setOverlayVisible(false);
                }
            }
        });
        jFXToggleButton.pressedProperty().addListener(observable -> jFXRippler.setOverlayVisible(false));
        ((ToggleButton)this.getSkinnable()).selectedProperty().addListener(observable -> {
            jFXRippler.setRipplerFill(jFXToggleButton.isSelected() ? jFXToggleButton.getToggleLineColor() : jFXToggleButton.getUnToggleLineColor());
            if (!jFXToggleButton.isDisableAnimation().booleanValue()) {
                this.timer.reverseAndContinue();
            } else {
                jFXRippler.setTranslateX(this.computeTranslation(d2, this.line));
            }
        });
        ((ToggleButton)this.getSkinnable()).setGraphic((Node)stackPane2);
        this.timer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis((double)100.0), JFXKeyValue.builder().setTarget(jFXRippler.translateXProperty()).setEndValueSupplier(() -> this.computeTranslation(d2, this.line)).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((JFXToggleButton)this.getSkinnable()).isDisableAnimation() == false).build(), JFXKeyValue.builder().setTarget(this.line.strokeProperty()).setEndValueSupplier(() -> ((ToggleButton)this.getSkinnable()).isSelected() ? ((JFXToggleButton)this.getSkinnable()).getToggleLineColor() : ((JFXToggleButton)this.getSkinnable()).getUnToggleLineColor()).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((JFXToggleButton)this.getSkinnable()).isDisableAnimation() == false).build(), JFXKeyValue.builder().setTarget(this.circle.fillProperty()).setEndValueSupplier(() -> ((ToggleButton)this.getSkinnable()).isSelected() ? ((JFXToggleButton)this.getSkinnable()).getToggleColor() : ((JFXToggleButton)this.getSkinnable()).getUnToggleColor()).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((JFXToggleButton)this.getSkinnable()).isDisableAnimation() == false).build()));
        this.timer.setCacheNodes(new Node[]{this.circle, this.line});
        this.registerChangeListener((ObservableValue)jFXToggleButton.toggleColorProperty(), observableValue -> {
            if (((ToggleButton)this.getSkinnable()).isSelected()) {
                this.circle.setFill(((JFXToggleButton)this.getSkinnable()).getToggleColor());
            }
        });
        this.registerChangeListener((ObservableValue)jFXToggleButton.unToggleColorProperty(), observableValue -> {
            if (!((ToggleButton)this.getSkinnable()).isSelected()) {
                this.circle.setFill(((JFXToggleButton)this.getSkinnable()).getUnToggleColor());
            }
        });
        this.registerChangeListener((ObservableValue)jFXToggleButton.toggleLineColorProperty(), observableValue -> {
            if (((ToggleButton)this.getSkinnable()).isSelected()) {
                this.line.setStroke(((JFXToggleButton)this.getSkinnable()).getToggleLineColor());
            }
        });
        this.registerChangeListener((ObservableValue)jFXToggleButton.unToggleColorProperty(), observableValue -> {
            if (!((ToggleButton)this.getSkinnable()).isSelected()) {
                this.line.setStroke(((JFXToggleButton)this.getSkinnable()).getUnToggleLineColor());
            }
        });
    }

    private double computeTranslation(double d2, Line line) {
        return (double)(((ToggleButton)this.getSkinnable()).isSelected() ? 1 : -1) * (line.getLayoutBounds().getWidth() / 2.0 - d2 + 2.0);
    }

    public void dispose() {
        super.dispose();
        this.timer.dispose();
        this.timer = null;
    }
}

