/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import javafx.animation.Interpolator;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.skin.RadioButtonSkin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class JFXRadioButtonSkin
extends RadioButtonSkin {
    private final JFXRippler rippler;
    private double padding = 12.0;
    private Circle radio;
    private Circle dot;
    private final StackPane container;
    private JFXAnimationTimer timer;

    public JFXRadioButtonSkin(JFXRadioButton jFXRadioButton) {
        super((RadioButton)jFXRadioButton);
        double d2 = 8.0;
        this.radio = new Circle(8.0);
        this.radio.getStyleClass().setAll((Object[])new String[]{"radio"});
        this.radio.setStrokeWidth(2.0);
        this.radio.setFill((Paint)Color.TRANSPARENT);
        this.radio.setSmooth(true);
        this.dot = new Circle(8.0);
        this.dot.getStyleClass().setAll((Object[])new String[]{"dot"});
        this.dot.fillProperty().bind(jFXRadioButton.selectedColorProperty());
        this.dot.setScaleX(0.0);
        this.dot.setScaleY(0.0);
        this.dot.setSmooth(true);
        this.container = new StackPane(new Node[]{this.radio, this.dot});
        this.container.getStyleClass().add((Object)"radio-container");
        this.rippler = new JFXRippler((Node)this.container, JFXRippler.RipplerMask.CIRCLE){

            @Override
            protected double computeRippleRadius() {
                double d2 = this.ripplerPane.getWidth();
                double d3 = d2 * d2;
                return Math.min(Math.sqrt(d3 + d3), 300.0) * 1.1 + 5.0;
            }

            @Override
            protected void setOverLayBounds(Rectangle rectangle) {
                rectangle.setWidth(this.ripplerPane.getWidth());
                rectangle.setHeight(this.ripplerPane.getHeight());
            }

            @Override
            protected void initControlListeners() {
                this.control.layoutBoundsProperty().addListener(observable -> this.resetRippler());
                if (this.getChildren().contains((Object)this.control)) {
                    this.control.boundsInParentProperty().addListener(observable -> this.resetRippler());
                }
                this.control.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> this.createRipple(mouseEvent.getX() + JFXRadioButtonSkin.this.padding, mouseEvent.getY() + JFXRadioButtonSkin.this.padding));
                this.control.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> this.releaseRipple());
            }

            @Override
            protected Node getMask() {
                double d2 = this.ripplerPane.getWidth() / 2.0;
                return new Circle(d2, d2, d2);
            }

            @Override
            protected void positionControl(Node node) {
            }
        };
        this.updateChildren();
        jFXRadioButton.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (!jFXRadioButton.disableVisualFocusProperty().get()) {
                if (bl3.booleanValue()) {
                    if (!((RadioButton)this.getSkinnable()).isPressed()) {
                        this.rippler.setOverlayVisible(true);
                    }
                } else {
                    this.rippler.setOverlayVisible(false);
                }
            }
        });
        jFXRadioButton.pressedProperty().addListener((observableValue, bl2, bl3) -> this.rippler.setOverlayVisible(false));
        this.timer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis((double)200.0), JFXKeyValue.builder().setTarget(this.dot.scaleXProperty()).setEndValueSupplier(() -> ((RadioButton)this.getSkinnable()).isSelected() ? 0.55 : 0.0).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.dot.scaleYProperty()).setEndValueSupplier(() -> ((RadioButton)this.getSkinnable()).isSelected() ? 0.55 : 0.0).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.radio.strokeProperty()).setEndValueSupplier(() -> ((RadioButton)this.getSkinnable()).isSelected() ? ((JFXRadioButton)this.getSkinnable()).getSelectedColor() : ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor()).setInterpolator(Interpolator.EASE_BOTH).build()));
        this.registerChangeListener((ObservableValue)jFXRadioButton.selectedColorProperty(), observableValue -> this.updateColors());
        this.registerChangeListener((ObservableValue)jFXRadioButton.unSelectedColorProperty(), observableValue -> this.updateColors());
        this.registerChangeListener((ObservableValue)jFXRadioButton.selectedProperty(), observableValue -> {
            boolean bl2 = ((RadioButton)this.getSkinnable()).isSelected();
            Color color = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
            Color color2 = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
            this.rippler.setRipplerFill((Paint)(bl2 ? color2 : color));
            if (((JFXRadioButton)this.getSkinnable()).isDisableAnimation().booleanValue()) {
                this.timer.applyEndValues();
            } else {
                this.timer.reverseAndContinue();
            }
        });
        this.updateColors();
        this.timer.applyEndValues();
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.radio != null) {
            this.removeRadio();
            this.getChildren().addAll((Object[])new Node[]{this.container, this.rippler});
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        RadioButton radioButton = (RadioButton)this.getSkinnable();
        double d6 = this.snapSizeX(this.container.prefWidth(-1.0));
        double d7 = this.snapSizeY(this.container.prefHeight(-1.0));
        double d8 = Math.max(radioButton.prefWidth(-1.0), radioButton.minWidth(-1.0));
        double d9 = this.snapSizeX(d6);
        double d10 = this.snapSizeY(d7);
        double d11 = Math.min(d8 - d6, d4 - d9);
        double d12 = Math.min(radioButton.prefHeight(d11), d5);
        double d13 = Math.max(d7, d12);
        double d14 = JFXRadioButtonSkin.computeXOffset(d4, d11 + d6, radioButton.getAlignment().getHpos()) + d2;
        double d15 = JFXRadioButtonSkin.computeYOffset(d5, d13, radioButton.getAlignment().getVpos()) + d2;
        this.container.resize(d9, d10);
        this.layoutLabelInArea(d14 + d6 + this.padding / 3.0, d15, d11, d13, radioButton.getAlignment());
        this.positionInArea((Node)this.container, d14, d15, d6, d13, 0.0, radioButton.getAlignment().getHpos(), radioButton.getAlignment().getVpos());
        double d16 = d9 + 2.0 * this.padding;
        double d17 = d10 + 2.0 * this.padding;
        this.rippler.resizeRelocate(d9 / 2.0 + d14 - d16 / 2.0, d10 / 2.0 + d14 - d17 / 2.0, d16, d17);
    }

    private void removeRadio() {
        for (int i2 = 0; i2 < this.getChildren().size(); ++i2) {
            if (!((Node)this.getChildren().get(i2)).getStyleClass().contains((Object)"radio")) continue;
            this.getChildren().remove(i2);
            break;
        }
    }

    private void updateColors() {
        boolean bl2 = ((RadioButton)this.getSkinnable()).isSelected();
        Color color = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
        Color color2 = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
        this.rippler.setRipplerFill((Paint)(bl2 ? color2 : color));
        this.radio.setStroke((Paint)(bl2 ? color2 : color));
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return super.computeMinWidth(d2, d3, d4, d5, d6) + this.snapSizeX(this.radio.minWidth(-1.0)) + this.padding / 3.0;
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return super.computePrefWidth(d2, d3, d4, d5, d6) + this.snapSizeX(this.radio.prefWidth(-1.0)) + this.padding / 3.0;
    }

    private static double computeXOffset(double d2, double d3, HPos hPos) {
        switch (hPos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (d2 - d3) / 2.0;
            }
            case RIGHT: {
                return d2 - d3;
            }
        }
        return 0.0;
    }

    private static double computeYOffset(double d2, double d3, VPos vPos) {
        switch (vPos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (d2 - d3) / 2.0;
            }
            case BOTTOM: {
                return d2 - d3;
            }
        }
        return 0.0;
    }

    public void dispose() {
        super.dispose();
        this.timer.dispose();
        this.timer = null;
    }
}

