/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.utils.JFXNodeUtils;
import com.sun.javafx.scene.NodeHelper;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.skin.ProgressIndicatorSkin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class JFXProgressBarSkin
extends ProgressIndicatorSkin {
    private StackPane track;
    private StackPane secondaryBar;
    private StackPane bar;
    private double barWidth = 0.0;
    private double secondaryBarWidth = 0.0;
    private Animation indeterminateTransition;
    private Region clip;
    boolean wasIndeterminate = false;

    public JFXProgressBarSkin(JFXProgressBar jFXProgressBar) {
        super((ProgressIndicator)jFXProgressBar);
        jFXProgressBar.widthProperty().addListener(observable -> {
            this.updateProgress();
            this.updateSecondaryProgress();
        });
        this.registerChangeListener((ObservableValue)jFXProgressBar.progressProperty(), observableValue -> this.updateProgress());
        this.registerChangeListener((ObservableValue)jFXProgressBar.secondaryProgressProperty(), observableValue -> this.updateSecondaryProgress());
        this.registerChangeListener((ObservableValue)jFXProgressBar.visibleProperty(), observableValue -> this.updateAnimation());
        this.registerChangeListener((ObservableValue)jFXProgressBar.parentProperty(), observableValue -> this.updateAnimation());
        this.registerChangeListener((ObservableValue)jFXProgressBar.sceneProperty(), observableValue -> this.updateAnimation());
        this.unregisterChangeListeners((ObservableValue)NodeHelper.treeShowingProperty((Node)jFXProgressBar));
        this.unregisterChangeListeners((ObservableValue)jFXProgressBar.indeterminateProperty());
        this.registerChangeListener((ObservableValue)NodeHelper.treeShowingProperty((Node)jFXProgressBar), observableValue -> this.updateAnimation());
        this.registerChangeListener((ObservableValue)jFXProgressBar.indeterminateProperty(), observableValue -> this.initialize());
        this.initialize();
        ((ProgressIndicator)this.getSkinnable()).requestLayout();
    }

    protected void initialize() {
        this.track = new StackPane();
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.bar = new StackPane();
        this.bar.getStyleClass().setAll((Object[])new String[]{"bar"});
        this.secondaryBar = new StackPane();
        this.secondaryBar.getStyleClass().setAll((Object[])new String[]{"secondary-bar"});
        this.clip = new Region();
        this.clip.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.bar.backgroundProperty().addListener(observable -> JFXNodeUtils.updateBackground(this.bar.getBackground(), this.clip));
        this.getChildren().setAll((Object[])new Node[]{this.track, this.secondaryBar, this.bar});
    }

    public double computeBaselineOffset(double d2, double d3, double d4, double d5) {
        return Double.NEGATIVE_INFINITY;
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return Math.max(100.0, d6 + this.bar.prefWidth(((ProgressIndicator)this.getSkinnable()).getWidth()) + d4);
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return d3 + this.bar.prefHeight(d2) + d5;
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((ProgressIndicator)this.getSkinnable()).prefWidth(d2);
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((ProgressIndicator)this.getSkinnable()).prefHeight(d2);
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        this.track.resizeRelocate(d2, d3, d4, d5);
        this.secondaryBar.resizeRelocate(d2, d3, this.secondaryBarWidth, d5);
        this.bar.resizeRelocate(d2, d3, ((ProgressIndicator)this.getSkinnable()).isIndeterminate() ? d4 : this.barWidth, d5);
        this.clip.resizeRelocate(0.0, 0.0, d4, d5);
        if (((ProgressIndicator)this.getSkinnable()).isIndeterminate()) {
            this.createIndeterminateTimeline();
            if (NodeHelper.isTreeShowing((Node)this.getSkinnable())) {
                this.indeterminateTransition.play();
            }
            this.bar.setClip((Node)this.clip);
        } else if (this.indeterminateTransition != null) {
            this.clearAnimation();
            this.bar.setClip(null);
        }
    }

    protected void updateSecondaryProgress() {
        JFXProgressBar jFXProgressBar = (JFXProgressBar)this.getSkinnable();
        this.secondaryBarWidth = (double)((int)(jFXProgressBar.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, jFXProgressBar.getSecondaryProgress())) / 2.0;
        jFXProgressBar.requestLayout();
    }

    protected void pauseTimeline(boolean bl2) {
        if (((ProgressIndicator)this.getSkinnable()).isIndeterminate()) {
            if (this.indeterminateTransition == null) {
                this.createIndeterminateTimeline();
            }
            if (bl2) {
                this.indeterminateTransition.pause();
            } else {
                this.indeterminateTransition.play();
            }
        }
    }

    private void updateAnimation() {
        boolean bl2;
        ProgressIndicator progressIndicator = (ProgressIndicator)this.getSkinnable();
        boolean bl3 = bl2 = progressIndicator.isVisible() && progressIndicator.getParent() != null && progressIndicator.getScene() != null;
        if (this.indeterminateTransition != null) {
            this.pauseTimeline(!bl2);
        } else if (bl2) {
            this.createIndeterminateTimeline();
        }
    }

    private void updateProgress() {
        ProgressIndicator progressIndicator = (ProgressIndicator)this.getSkinnable();
        boolean bl2 = progressIndicator.isIndeterminate();
        if (!bl2 || !this.wasIndeterminate) {
            this.barWidth = (double)((int)(progressIndicator.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, progressIndicator.getProgress())) / 2.0;
            progressIndicator.requestLayout();
        }
        this.wasIndeterminate = bl2;
    }

    private void createIndeterminateTimeline() {
        if (this.indeterminateTransition != null) {
            this.clearAnimation();
        }
        double d2 = 1.0;
        ProgressIndicator progressIndicator = (ProgressIndicator)this.getSkinnable();
        double d3 = progressIndicator.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        this.indeterminateTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.clip.scaleXProperty(), (Object)0.0, Interpolator.EASE_IN), new KeyValue((WritableValue)this.clip.translateXProperty(), (Object)(-d3 / 2.0), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(0.5 * d2)), new KeyValue[]{new KeyValue((WritableValue)this.clip.scaleXProperty(), (Object)0.4, Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(0.9 * d2)), new KeyValue[]{new KeyValue((WritableValue)this.clip.translateXProperty(), (Object)(d3 / 2.0), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(1.0 * d2)), new KeyValue[]{new KeyValue((WritableValue)this.clip.scaleXProperty(), (Object)0.0, Interpolator.EASE_OUT)})});
        this.indeterminateTransition.setCycleCount(-1);
    }

    private void clearAnimation() {
        this.indeterminateTransition.stop();
        ((Timeline)this.indeterminateTransition).getKeyFrames().clear();
        this.indeterminateTransition = null;
    }

    public void dispose() {
        super.dispose();
        if (this.indeterminateTransition != null) {
            this.clearAnimation();
        }
    }
}

