/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXListView;
import com.jfoenix.effects.JFXDepthManager;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.skin.ListViewSkin;
import javafx.scene.control.skin.VirtualFlow;

public class JFXListViewSkin<T>
extends ListViewSkin<T> {
    private VirtualFlow<ListCell<T>> flow = (VirtualFlow)this.getChildren().get(0);

    public JFXListViewSkin(JFXListView<T> jFXListView) {
        super(jFXListView);
        JFXDepthManager.setDepth(this.flow, (Integer)jFXListView.depthProperty().get());
        jFXListView.depthProperty().addListener((observableValue, n2, n3) -> JFXDepthManager.setDepth(this.flow, n3));
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return 200.0;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        int n2 = ((ListView)this.getSkinnable()).getItems().size();
        if (((ListView)this.getSkinnable()).maxHeightProperty().isBound() || n2 <= 0) {
            return super.computePrefHeight(d2, d3, d4, d5, d6);
        }
        double d7 = ((ListView)this.getSkinnable()).getFixedCellSize();
        double d8 = d7 != -1.0 ? d7 * (double)n2 + this.snapVerticalInsets() : this.estimateHeight();
        double d9 = super.computePrefHeight(d2, d3, d4, d5, d6);
        if (d9 > d8) {
            d9 = d8;
        }
        if (((ListView)this.getSkinnable()).getMaxHeight() > 0.0 && d8 > ((ListView)this.getSkinnable()).getMaxHeight()) {
            return ((ListView)this.getSkinnable()).getMaxHeight();
        }
        return d9;
    }

    private double estimateHeight() {
        double d2 = this.snapVerticalInsets();
        JFXListView jFXListView = (JFXListView)this.getSkinnable();
        double d3 = jFXListView.isExpanded() != false ? ((JFXListView)this.getSkinnable()).getVerticalGap() * (double)((ListView)this.getSkinnable()).getItems().size() : 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < this.flow.getCellCount(); ++i2) {
            ListCell listCell = (ListCell)this.flow.getCell(i2);
            d4 += listCell.getHeight();
        }
        return d4 + d3 + d2;
    }

    private double snapVerticalInsets() {
        return ((ListView)this.getSkinnable()).snappedBottomInset() + ((ListView)this.getSkinnable()).snappedTopInset();
    }
}

