/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.skins.JFXDatePickerContent;
import com.jfoenix.skins.JFXGenericPickerSkin;
import java.time.LocalDate;
import java.time.YearMonth;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class JFXDatePickerSkin
extends JFXGenericPickerSkin<LocalDate> {
    private JFXDatePicker jfxDatePicker;
    private TextField displayNode;
    private JFXDatePickerContent content;
    private JFXDialog dialog;

    public JFXDatePickerSkin(JFXDatePicker jFXDatePicker) {
        super(jFXDatePicker);
        this.jfxDatePicker = jFXDatePicker;
        jFXDatePicker.focusedProperty().addListener(observable -> {
            if (this.getEditor() != null && !jFXDatePicker.isFocused()) {
                this.reflectSetTextFromTextFieldIntoComboBoxValue();
            }
        });
        this.updateArrow(jFXDatePicker);
        ((JFXTextField)this.getEditor()).setFocusColor(this.jfxDatePicker.getDefaultColor());
        this.registerChangeListener((ObservableValue)jFXDatePicker.defaultColorProperty(), observableValue -> this.updateArrow(jFXDatePicker));
        this.registerChangeListener((ObservableValue)jFXDatePicker.converterProperty(), observableValue -> this.reflectUpdateDisplayNode());
        this.registerChangeListener((ObservableValue)jFXDatePicker.editableProperty(), observableValue -> this.reflectGetEditableInputNode());
        this.registerChangeListener((ObservableValue)jFXDatePicker.dayCellFactoryProperty(), observableValue -> {
            this.reflectUpdateDisplayNode();
            this.content = null;
            this.popup = null;
        });
        this.registerChangeListener((ObservableValue)jFXDatePicker.valueProperty(), observableValue -> {
            this.reflectUpdateDisplayNode();
            if (this.content != null) {
                LocalDate localDate = (LocalDate)this.jfxDatePicker.getValue();
                this.content.displayedYearMonthProperty().set((Object)(localDate != null ? YearMonth.from(localDate) : YearMonth.now()));
                this.content.updateValues();
            }
            this.jfxDatePicker.fireEvent((Event)new ActionEvent());
        });
        this.registerChangeListener((ObservableValue)jFXDatePicker.showWeekNumbersProperty(), observableValue -> {
            if (this.content != null) {
                this.content.updateContentGrid();
                this.content.updateWeekNumberDateCells();
            }
        });
        this.registerChangeListener((ObservableValue)jFXDatePicker.showingProperty(), observableValue -> {
            if (this.jfxDatePicker.isShowing()) {
                if (this.content != null) {
                    LocalDate localDate = (LocalDate)this.jfxDatePicker.getValue();
                    this.content.displayedYearMonthProperty().set((Object)(localDate != null ? YearMonth.from(localDate) : YearMonth.now()));
                    this.content.updateValues();
                }
                this.show();
            } else {
                this.hide();
            }
        });
    }

    private void updateArrow(JFXDatePicker jFXDatePicker) {
        ((Region)this.arrowButton.getChildren().get(0)).setBackground(new Background(new BackgroundFill[]{new BackgroundFill(jFXDatePicker.getDefaultColor(), null, null)}));
        ((JFXTextField)this.getEditor()).setFocusColor(this.jfxDatePicker.getDefaultColor());
    }

    protected Node getPopupContent() {
        if (this.content == null) {
            this.content = new JFXDatePickerContent((JFXDatePicker)this.getSkinnable());
        }
        return this.content;
    }

    protected TextField getEditor() {
        return ((DatePicker)this.getSkinnable()).getEditor();
    }

    protected StringConverter<LocalDate> getConverter() {
        return ((DatePicker)this.getSkinnable()).getConverter();
    }

    public Node getDisplayNode() {
        if (this.displayNode == null) {
            this.displayNode = this.reflectGetEditableInputNode();
            this.displayNode.getStyleClass().add((Object)"date-picker-display-node");
            this.reflectUpdateDisplayNode();
        }
        this.displayNode.setEditable(this.jfxDatePicker.isEditable());
        return this.displayNode;
    }

    public void show() {
        if (!this.jfxDatePicker.isOverLay()) {
            super.show();
        }
        if (this.content != null) {
            this.content.init();
            this.content.clearFocus();
        }
        if (this.dialog == null && this.jfxDatePicker.isOverLay()) {
            StackPane stackPane = this.jfxDatePicker.getDialogParent();
            if (stackPane == null) {
                stackPane = (StackPane)this.jfxDatePicker.getScene().getRoot();
            }
            this.dialog = new JFXDialog(stackPane, (Region)this.getPopupContent(), JFXDialog.DialogTransition.CENTER, true);
            this.arrowButton.setOnMouseClicked(mouseEvent -> {
                if (this.jfxDatePicker.isOverLay()) {
                    StackPane stackPane = this.jfxDatePicker.getDialogParent();
                    if (stackPane == null) {
                        stackPane = (StackPane)this.jfxDatePicker.getScene().getRoot();
                    }
                    this.dialog.show(stackPane);
                }
            });
        }
    }
}

