/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDecorator;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.skins.JFXCustomColorPicker;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.transitions.JFXFillTransition;
import com.sun.javafx.util.Utils;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;

public class JFXCustomColorPickerDialog
extends StackPane {
    public static final String rgbFieldStyle = "-fx-background-color:TRANSPARENT;-fx-font-weight: BOLD;-fx-prompt-text-fill: #808080; -fx-alignment: top-left ; -fx-max-width: 300;";
    private final Stage dialog = new Stage();
    private final AtomicInteger concurrencyController = new AtomicInteger(-1);
    private ObjectProperty<Color> currentColorProperty = new SimpleObjectProperty((Object)Color.WHITE);
    private ObjectProperty<Color> customColorProperty = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    private Runnable onSave;
    private Scene customScene;
    private JFXCustomColorPicker curvedColorPicker;
    private ParallelTransition paraTransition;
    private JFXDecorator pickerDecorator;
    private boolean systemChange = false;
    private boolean userChange = false;
    private boolean initOnce = true;
    private Runnable initRun;
    private InvalidationListener positionAdjuster = new InvalidationListener(){

        public void invalidated(Observable observable) {
            if (Double.isNaN(JFXCustomColorPickerDialog.this.dialog.getWidth()) || Double.isNaN(JFXCustomColorPickerDialog.this.dialog.getHeight())) {
                return;
            }
            JFXCustomColorPickerDialog.this.dialog.widthProperty().removeListener(JFXCustomColorPickerDialog.this.positionAdjuster);
            JFXCustomColorPickerDialog.this.dialog.heightProperty().removeListener(JFXCustomColorPickerDialog.this.positionAdjuster);
            JFXCustomColorPickerDialog.this.fixPosition();
        }
    };

    public JFXCustomColorPickerDialog(Window window) {
        Scene scene;
        this.getStyleClass().add((Object)"custom-color-dialog");
        if (window != null) {
            this.dialog.initOwner(window);
        }
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initStyle(StageStyle.TRANSPARENT);
        this.dialog.setResizable(false);
        this.pickerDecorator = new JFXDecorator(this.dialog, (Node)this, false, false, false);
        this.pickerDecorator.setOnCloseButtonAction(() -> this.updateColor());
        this.pickerDecorator.setPickOnBounds(false);
        this.customScene = new Scene((Parent)this.pickerDecorator, (Paint)Color.TRANSPARENT);
        if (window != null && (scene = window.getScene()) != null) {
            if (scene.getUserAgentStylesheet() != null) {
                this.customScene.setUserAgentStylesheet(scene.getUserAgentStylesheet());
            }
            this.customScene.getStylesheets().addAll((Collection)scene.getStylesheets());
        }
        this.curvedColorPicker = new JFXCustomColorPicker();
        scene = new StackPane(new Node[]{this.curvedColorPicker});
        scene.setPadding(new Insets(18.0));
        VBox vBox = new VBox();
        vBox.getChildren().add((Object)scene);
        JFXTabPane jFXTabPane = new JFXTabPane();
        JFXTextField jFXTextField = new JFXTextField();
        JFXTextField jFXTextField2 = new JFXTextField();
        JFXTextField jFXTextField3 = new JFXTextField();
        jFXTextField.setStyle(rgbFieldStyle);
        jFXTextField.setPromptText("RGB Color");
        jFXTextField.textProperty().addListener((observableValue, string, string2) -> this.updateColorFromUserInput((String)string2));
        jFXTextField2.setStyle(rgbFieldStyle);
        jFXTextField2.setPromptText("HSB Color");
        jFXTextField2.textProperty().addListener((observableValue, string, string2) -> this.updateColorFromUserInput((String)string2));
        jFXTextField3.setStyle(rgbFieldStyle);
        jFXTextField3.setPromptText("#HEX Color");
        jFXTextField3.textProperty().addListener((observableValue, string, string2) -> this.updateColorFromUserInput((String)string2));
        StackPane stackPane = new StackPane();
        stackPane.getChildren().add((Object)jFXTextField);
        stackPane.setMinHeight(100.0);
        Tab tab = new Tab("RGB");
        tab.setContent((Node)stackPane);
        Tab tab2 = new Tab("HSB");
        tab2.setContent((Node)jFXTextField2);
        Tab tab3 = new Tab("HEX");
        tab3.setContent((Node)jFXTextField3);
        jFXTabPane.getTabs().add((Object)tab);
        jFXTabPane.getTabs().add((Object)tab2);
        jFXTabPane.getTabs().add((Object)tab3);
        this.curvedColorPicker.selectedPath.addListener((arg_0, arg_1, arg_2) -> this.lambda$new$7(jFXTabPane, (StackPane)scene, arg_0, arg_1, arg_2));
        this.initRun = () -> this.lambda$new$18((StackPane)scene, jFXTabPane, jFXTextField, jFXTextField2, jFXTextField3);
        vBox.getChildren().add((Object)jFXTabPane);
        this.getChildren().add((Object)vBox);
        this.setPadding(new Insets(0.0));
        this.dialog.setScene(this.customScene);
        EventHandler eventHandler = keyEvent -> {
            switch (keyEvent.getCode()) {
                case ESCAPE: {
                    this.close();
                    break;
                }
                case ENTER: {
                    this.updateColor();
                    break;
                }
            }
        };
        this.dialog.addEventHandler(KeyEvent.ANY, eventHandler);
    }

    private void updateColor() {
        this.close();
        this.customColorProperty.set((Object)this.curvedColorPicker.getColor(this.curvedColorPicker.getSelectedIndex()));
        this.onSave.run();
    }

    private void updateColorFromUserInput(String string) {
        if (!this.systemChange) {
            this.userChange = true;
            try {
                this.curvedColorPicker.setColor(Color.valueOf((String)string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.userChange = false;
        }
    }

    private void close() {
        this.dialog.setScene(null);
        this.dialog.close();
    }

    public void setCurrentColor(Color color) {
        this.currentColorProperty.set((Object)color);
    }

    Color getCurrentColor() {
        return (Color)this.currentColorProperty.get();
    }

    ObjectProperty<Color> customColorProperty() {
        return this.customColorProperty;
    }

    void setCustomColor(Color color) {
        this.customColorProperty.set((Object)color);
    }

    Color getCustomColor() {
        return (Color)this.customColorProperty.get();
    }

    public Runnable getOnSave() {
        return this.onSave;
    }

    public void setOnSave(Runnable runnable) {
        this.onSave = runnable;
    }

    public void setOnHidden(EventHandler<WindowEvent> eventHandler) {
        this.dialog.setOnHidden(eventHandler);
    }

    public void show() {
        this.dialog.setOpacity(0.0);
        if (this.dialog.getOwner() != null) {
            this.dialog.widthProperty().addListener(this.positionAdjuster);
            this.dialog.heightProperty().addListener(this.positionAdjuster);
            this.positionAdjuster.invalidated(null);
        }
        if (this.dialog.getScene() == null) {
            this.dialog.setScene(this.customScene);
        }
        this.curvedColorPicker.preAnimate();
        this.dialog.show();
        if (this.initOnce) {
            this.initRun.run();
            this.initOnce = false;
        }
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)120.0), new KeyValue[]{new KeyValue((WritableValue)this.dialog.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})});
        timeline.setOnFinished(actionEvent -> this.curvedColorPicker.animate());
        timeline.play();
    }

    private void fixPosition() {
        Window window = this.dialog.getOwner();
        Screen screen = Utils.getScreen((Object)window);
        Rectangle2D rectangle2D = screen.getBounds();
        double d2 = window.getX() + window.getWidth();
        double d3 = window.getX() - this.dialog.getWidth();
        double d4 = rectangle2D.getMaxX() >= d2 + this.dialog.getWidth() ? d2 : (rectangle2D.getMinX() <= d3 ? d3 : Math.max(rectangle2D.getMinX(), rectangle2D.getMaxX() - this.dialog.getWidth()));
        double d5 = Math.max(rectangle2D.getMinY(), Math.min(rectangle2D.getMaxY() - this.dialog.getHeight(), window.getY()));
        this.dialog.setX(d4);
        this.dialog.setY(d5);
    }

    public void layoutChildren() {
        super.layoutChildren();
        if (this.dialog.getMinWidth() > 0.0 && this.dialog.getMinHeight() > 0.0) {
            return;
        }
        double d2 = Math.max(0.0, this.computeMinWidth(this.getHeight()) + (this.dialog.getWidth() - this.customScene.getWidth()));
        double d3 = Math.max(0.0, this.computeMinHeight(this.getWidth()) + (this.dialog.getHeight() - this.customScene.getHeight()));
        this.dialog.setMinWidth(d2);
        this.dialog.setMinHeight(d3);
    }

    private /* synthetic */ void lambda$new$18(StackPane stackPane, JFXTabPane jFXTabPane, JFXTextField jFXTextField, JFXTextField jFXTextField2, JFXTextField jFXTextField3) {
        stackPane.backgroundProperty().addListener((observableValue, background, background2) -> {
            if (this.concurrencyController.getAndSet(1) == -1) {
                Object object3;
                Object object22;
                Color color = ((Color)((BackgroundFill)background2.getFills().get(0)).getFill()).grayscale().getRed() > 0.5 ? Color.valueOf((String)"rgba(40, 40, 40, 0.87)") : Color.valueOf((String)"rgba(255, 255, 255, 0.87)");
                for (Object object22 : jFXTabPane.lookupAll(".tab")) {
                    for (Object object3 : object22.lookupAll(".tab-label")) {
                        ((Label)object3).setTextFill((Paint)color);
                    }
                    for (Object object3 : object22.lookupAll(".jfx-rippler")) {
                        ((JFXRippler)((Object)((Object)object3))).setRipplerFill((Paint)color);
                    }
                }
                ((Pane)jFXTabPane.lookup(".tab-selected-line")).setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)}));
                this.pickerDecorator.lookupAll(".jfx-decorator-button").forEach(node -> {
                    ((JFXButton)((Object)((Object)node))).setRipplerFill((Paint)color);
                    ((SVGGlyph)((JFXButton)((Object)((Object)node))).getGraphic()).setFill((Paint)color);
                });
                Color color2 = (Color)((BackgroundFill)background2.getFills().get(0)).getFill();
                object22 = String.format("#%02X%02X%02X", (int)(color2.getRed() * 255.0), (int)(color2.getGreen() * 255.0), (int)(color2.getBlue() * 255.0));
                String string = String.format("rgba(%d, %d, %d, 1)", (int)(color2.getRed() * 255.0), (int)(color2.getGreen() * 255.0), (int)(color2.getBlue() * 255.0));
                object3 = String.format("hsl(%d, %d%%, %d%%)", (int)color2.getHue(), (int)(color2.getSaturation() * 100.0), (int)(color2.getBrightness() * 100.0));
                if (!this.userChange) {
                    this.systemChange = true;
                    jFXTextField.setText(string);
                    jFXTextField2.setText((String)object3);
                    jFXTextField3.setText((String)object22);
                    this.systemChange = false;
                }
                this.concurrencyController.getAndSet(-1);
            }
        });
        Platform.runLater(() -> {
            stackPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.curvedColorPicker.getColor(this.curvedColorPicker.getSelectedIndex()), CornerRadii.EMPTY, Insets.EMPTY)}));
            ((Region)jFXTabPane.lookup(".tab-header-background")).setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.curvedColorPicker.getColor(this.curvedColorPicker.getSelectedIndex()), CornerRadii.EMPTY, Insets.EMPTY)}));
            Region region = (Region)jFXTabPane.lookup(".tab-header-background");
            stackPane.backgroundProperty().unbind();
            region.backgroundProperty().unbind();
            region.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill(((JFXCustomColorPicker.RecentColorPath)((Object)((Object)((Object)this.curvedColorPicker.selectedPath.get())))).getFill(), CornerRadii.EMPTY, Insets.EMPTY)}), (Observable[])new Observable[]{((JFXCustomColorPicker.RecentColorPath)((Object)((Object)this.curvedColorPicker.selectedPath.get()))).fillProperty()}));
            stackPane.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill(((JFXCustomColorPicker.RecentColorPath)((Object)((Object)((Object)this.curvedColorPicker.selectedPath.get())))).getFill(), CornerRadii.EMPTY, Insets.EMPTY)}), (Observable[])new Observable[]{((JFXCustomColorPicker.RecentColorPath)((Object)((Object)this.curvedColorPicker.selectedPath.get()))).fillProperty()}));
            jFXTextField.focusColorProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((BackgroundFill)stackPane.getBackground().getFills().get(0)).getFill(), (Observable[])new Observable[]{stackPane.backgroundProperty()}));
            jFXTextField2.focusColorProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((BackgroundFill)stackPane.getBackground().getFills().get(0)).getFill(), (Observable[])new Observable[]{stackPane.backgroundProperty()}));
            jFXTextField3.focusColorProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((BackgroundFill)stackPane.getBackground().getFills().get(0)).getFill(), (Observable[])new Observable[]{stackPane.backgroundProperty()}));
            ((Pane)this.pickerDecorator.lookup(".jfx-decorator-buttons-container")).backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill(((BackgroundFill)stackPane.getBackground().getFills().get(0)).getFill(), CornerRadii.EMPTY, Insets.EMPTY)}), (Observable[])new Observable[]{stackPane.backgroundProperty()}));
            ((Pane)this.pickerDecorator.lookup(".jfx-decorator-content-container")).borderProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Border(new BorderStroke[]{new BorderStroke(((BackgroundFill)stackPane.getBackground().getFills().get(0)).getFill(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(0.0, 4.0, 4.0, 4.0))}), (Observable[])new Observable[]{stackPane.backgroundProperty()}));
        });
    }

    private /* synthetic */ void lambda$new$7(JFXTabPane jFXTabPane, StackPane stackPane, ObservableValue observableValue, JFXCustomColorPicker.RecentColorPath recentColorPath, JFXCustomColorPicker.RecentColorPath recentColorPath2) {
        if (this.paraTransition != null) {
            this.paraTransition.stop();
        }
        Region region = (Region)jFXTabPane.lookup(".tab-header-background");
        stackPane.backgroundProperty().unbind();
        region.backgroundProperty().unbind();
        JFXFillTransition jFXFillTransition = new JFXFillTransition(Duration.millis((double)240.0), (Region)stackPane, (Color)recentColorPath.getFill(), (Color)recentColorPath2.getFill());
        JFXFillTransition jFXFillTransition2 = new JFXFillTransition(Duration.millis((double)240.0), region, (Color)recentColorPath.getFill(), (Color)recentColorPath2.getFill());
        this.paraTransition = new ParallelTransition(new Animation[]{jFXFillTransition, jFXFillTransition2});
        this.paraTransition.setOnFinished(actionEvent -> {
            region.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill(recentColorPath2.getFill(), CornerRadii.EMPTY, Insets.EMPTY)}), (Observable[])new Observable[]{recentColorPath2.fillProperty()}));
            stackPane.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill(recentColorPath2.getFill(), CornerRadii.EMPTY, Insets.EMPTY)}), (Observable[])new Observable[]{recentColorPath2.fillProperty()}));
        });
        this.paraTransition.play();
    }
}

