/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXClippedPane;
import com.jfoenix.controls.JFXColorPicker;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.skins.JFXColorPalette;
import com.jfoenix.skins.JFXGenericPickerSkin;
import com.jfoenix.utils.JFXNodeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ComboBoxPopupControl;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class JFXColorPickerSkin
extends JFXGenericPickerSkin<Color> {
    private Label displayNode;
    private JFXClippedPane colorBox;
    private JFXColorPalette popupContent;
    StyleableBooleanProperty colorLabelVisible = new SimpleStyleableBooleanProperty(StyleableProperties.access$000(), (Object)this, "colorLabelVisible", true);

    public JFXColorPickerSkin(ColorPicker colorPicker) {
        super(colorPicker);
        this.displayNode = new Label("");
        this.displayNode.getStyleClass().add((Object)"color-label");
        this.displayNode.setMouseTransparent(true);
        this.colorBox = new JFXClippedPane(new Node[]{this.displayNode});
        this.colorBox.getStyleClass().add((Object)"color-box");
        this.colorBox.setManaged(false);
        this.initColor();
        JFXRippler jFXRippler = new JFXRippler((Node)this.colorBox, JFXRippler.RipplerMask.FIT);
        jFXRippler.ripplerFillProperty().bind((ObservableValue)this.displayNode.textFillProperty());
        this.getChildren().setAll((Object[])new Node[]{jFXRippler});
        JFXDepthManager.setDepth((Node)this.getSkinnable(), 1);
        ((ComboBoxBase)this.getSkinnable()).setPickOnBounds(false);
        colorPicker.focusedProperty().addListener(observable -> {
            if (colorPicker.isFocused()) {
                if (!((ComboBoxBase)this.getSkinnable()).isPressed()) {
                    jFXRippler.setOverlayVisible(true);
                }
            } else {
                jFXRippler.setOverlayVisible(false);
            }
        });
        this.registerChangeListener((ObservableValue)colorPicker.valueProperty(), observableValue -> this.updateColor());
        this.colorLabelVisible.addListener(observable -> {
            if (this.displayNode != null) {
                if (this.colorLabelVisible.get()) {
                    this.displayNode.setText(JFXNodeUtils.colorToHex((Color)((ComboBoxBase)this.getSkinnable()).getValue()));
                } else {
                    this.displayNode.setText("");
                }
            }
        });
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 100.0;
        String string = this.displayNode.getText();
        this.displayNode.setText("#DDDDDD");
        d7 = Math.max(d7, super.computePrefWidth(d2, d3, d4, d5, d6));
        this.displayNode.setText(string);
        return d7 + d4 + d6;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.colorBox == null) {
            this.reflectUpdateDisplayArea();
        }
        return d3 + this.colorBox.prefHeight(d2) + d5;
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        super.layoutChildren(d2, d3, d4, d5);
        double d6 = this.snappedLeftInset() + this.snappedRightInset();
        double d7 = this.snappedTopInset() + this.snappedBottomInset();
        double d8 = d4 + d6;
        double d9 = d5 + d7;
        this.colorBox.resizeRelocate(0.0, 0.0, d8, d9);
    }

    protected Node getPopupContent() {
        if (this.popupContent == null) {
            this.popupContent = new JFXColorPalette((JFXColorPicker)this.getSkinnable());
        }
        return this.popupContent;
    }

    public void show() {
        super.show();
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        this.popupContent.updateSelection((Color)colorPicker.getValue());
    }

    public Node getDisplayNode() {
        return this.displayNode;
    }

    private void updateColor() {
        Color color;
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        Color color2 = (Color)colorPicker.getValue();
        Color color3 = color = color2 == null ? Color.WHITE : color2;
        if (((JFXColorPicker)this.getSkinnable()).isDisableAnimation().booleanValue()) {
            JFXNodeUtils.updateBackground(this.colorBox.getBackground(), (Region)this.colorBox, (Paint)color);
        } else {
            Circle circle = new Circle();
            circle.setFill((Paint)color);
            circle.setManaged(false);
            circle.setLayoutX(this.colorBox.getWidth() / 4.0);
            circle.setLayoutY(this.colorBox.getHeight() / 2.0);
            this.colorBox.getChildren().add((Object)circle);
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)circle.radiusProperty(), (Object)200, Interpolator.EASE_BOTH)})});
            timeline.setOnFinished(actionEvent -> {
                JFXNodeUtils.updateBackground(this.colorBox.getBackground(), (Region)this.colorBox, circle.getFill());
                this.colorBox.getChildren().remove((Object)circle);
            });
            timeline.play();
        }
        this.displayNode.setTextFill((Paint)(color.grayscale().getRed() < 0.5 ? Color.valueOf((String)"rgba(255, 255, 255, 0.87)") : Color.valueOf((String)"rgba(0, 0, 0, 0.87)")));
        if (this.colorLabelVisible.get()) {
            this.displayNode.setText(JFXNodeUtils.colorToHex(color));
        } else {
            this.displayNode.setText("");
        }
    }

    private void initColor() {
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        Color color = (Color)colorPicker.getValue();
        Color color2 = color == null ? Color.WHITE : color;
        this.colorBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color2, new CornerRadii(3.0), Insets.EMPTY)}));
        this.displayNode.setTextFill((Paint)(color2.grayscale().getRed() < 0.5 ? Color.valueOf((String)"rgba(255, 255, 255, 0.87)") : Color.valueOf((String)"rgba(0, 0, 0, 0.87)")));
        if (this.colorLabelVisible.get()) {
            this.displayNode.setText(JFXNodeUtils.colorToHex(color2));
        } else {
            this.displayNode.setText("");
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXColorPickerSkin.getClassCssMetaData();
    }

    protected TextField getEditor() {
        return null;
    }

    protected StringConverter<Color> getConverter() {
        return null;
    }

    private static class StyleableProperties {
        private static final CssMetaData<ColorPicker, Boolean> COLOR_LABEL_VISIBLE = new CssMetaData<ColorPicker, Boolean>("-fx-color-label-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public boolean isSettable(ColorPicker colorPicker) {
                JFXColorPickerSkin jFXColorPickerSkin = (JFXColorPickerSkin)colorPicker.getSkin();
                return jFXColorPickerSkin.colorLabelVisible == null || !jFXColorPickerSkin.colorLabelVisible.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(ColorPicker colorPicker) {
                JFXColorPickerSkin jFXColorPickerSkin = (JFXColorPickerSkin)colorPicker.getSkin();
                return jFXColorPickerSkin.colorLabelVisible;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return COLOR_LABEL_VISIBLE;
        }

        static {
            ArrayList<CssMetaData<ColorPicker, Boolean>> arrayList = new ArrayList<CssMetaData<ColorPicker, Boolean>>(ComboBoxPopupControl.getClassCssMetaData());
            arrayList.add(COLOR_LABEL_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

