/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.transitions.CachedTransition;
import com.jfoenix.transitions.JFXFillTransition;
import com.jfoenix.utils.JFXNodeUtils;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.skin.CheckBoxSkin;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class JFXCheckBoxSkin
extends CheckBoxSkin {
    private final StackPane box = new StackPane();
    private final StackPane mark = new StackPane();
    private final StackPane indeterminateMark = new StackPane();
    private final JFXRippler rippler;
    private Transition transition;
    private Transition indeterminateTransition;
    private boolean invalid = true;
    private JFXFillTransition select;
    private final StackPane boxContainer;

    public JFXCheckBoxSkin(JFXCheckBox jFXCheckBox) {
        super((CheckBox)jFXCheckBox);
        this.indeterminateMark.getStyleClass().setAll((Object[])new String[]{"indeterminate-mark"});
        this.indeterminateMark.setOpacity(0.0);
        this.indeterminateMark.setScaleX(0.0);
        this.indeterminateMark.setScaleY(0.0);
        this.mark.getStyleClass().setAll((Object[])new String[]{"mark"});
        this.mark.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.mark.setOpacity(0.0);
        this.mark.setScaleX(0.0);
        this.mark.setScaleY(0.0);
        this.box.getStyleClass().setAll((Object[])new String[]{"box"});
        this.box.setBorder(new Border(new BorderStroke[]{new BorderStroke(jFXCheckBox.getUnCheckedColor(), BorderStrokeStyle.SOLID, new CornerRadii(2.0), new BorderWidths(2.0))}));
        this.box.getChildren().setAll((Object[])new Node[]{this.indeterminateMark, this.mark});
        this.boxContainer = new StackPane();
        this.boxContainer.getChildren().add((Object)this.box);
        this.boxContainer.getStyleClass().add((Object)"box-container");
        this.rippler = new JFXRippler((Node)this.boxContainer, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK);
        this.updateRippleColor();
        jFXCheckBox.selectedProperty().addListener(observable -> {
            this.updateRippleColor();
            this.playSelectAnimation(jFXCheckBox.isSelected(), true);
        });
        jFXCheckBox.indeterminateProperty().addListener(observable -> {
            this.updateRippleColor();
            this.playIndeterminateAnimation(jFXCheckBox.isIndeterminate(), true);
        });
        jFXCheckBox.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (!jFXCheckBox.isDisableVisualFocus().booleanValue()) {
                if (bl3.booleanValue()) {
                    if (!((CheckBox)this.getSkinnable()).isPressed()) {
                        this.rippler.setOverlayVisible(true);
                    }
                } else {
                    this.rippler.setOverlayVisible(false);
                }
            }
        });
        jFXCheckBox.pressedProperty().addListener((observableValue, bl2, bl3) -> this.rippler.setOverlayVisible(false));
        this.updateChildren();
        this.transition = new CheckBoxTransition((Node)this.mark);
        this.indeterminateTransition = new CheckBoxTransition((Node)this.indeterminateMark);
        this.createFillTransition();
        this.registerChangeListener((ObservableValue)jFXCheckBox.checkedColorProperty(), observableValue -> {
            this.select.stop();
            this.createFillTransition();
            this.updateColors();
        });
        this.registerChangeListener((ObservableValue)jFXCheckBox.unCheckedColorProperty(), observableValue -> this.updateColors());
    }

    private void updateRippleColor() {
        this.rippler.setRipplerFill(((CheckBox)this.getSkinnable()).isSelected() ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : ((JFXCheckBox)this.getSkinnable()).getUnCheckedColor());
    }

    private void updateColors() {
        Paint paint = ((CheckBox)this.getSkinnable()).isSelected() ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : ((JFXCheckBox)this.getSkinnable()).getUnCheckedColor();
        JFXNodeUtils.updateBackground(this.indeterminateMark.getBackground(), (Region)this.indeterminateMark, ((JFXCheckBox)this.getSkinnable()).getCheckedColor());
        JFXNodeUtils.updateBackground(this.box.getBackground(), (Region)this.box, (Paint)(((CheckBox)this.getSkinnable()).isSelected() ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : Color.TRANSPARENT));
        this.rippler.setRipplerFill(paint);
        BorderStroke borderStroke = (BorderStroke)this.box.getBorder().getStrokes().get(0);
        this.box.setBorder(new Border(new BorderStroke[]{new BorderStroke(paint, borderStroke.getTopStyle(), borderStroke.getRadii(), borderStroke.getWidths())}));
    }

    protected void updateChildren() {
        super.updateChildren();
        this.getChildren().removeIf(node -> node.getStyleClass().contains((Object)"box"));
        if (this.rippler != null) {
            this.getChildren().add((Object)this.rippler);
        }
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return super.computePrefWidth(d2, d3, d4, d5, d6) + this.snapSize(this.box.minWidth(-1.0)) + this.getLabelOffset();
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return super.computePrefWidth(d2, d3, d4, d5, d6) + this.snapSize(this.box.prefWidth(-1.0)) + this.getLabelOffset();
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return Math.max(super.computeMinHeight(d2 - this.box.minWidth(-1.0), d3, d4, d5, d6), d3 + this.box.minHeight(-1.0) + d5);
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return Math.max(super.computePrefHeight(d2 - this.box.prefWidth(-1.0), d3, d4, d5, d6), d3 + this.box.prefHeight(-1.0) + d5);
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = this.getLabelOffset();
        CheckBox checkBox = (CheckBox)this.getSkinnable();
        double d7 = this.snapSize(this.box.prefWidth(-1.0));
        double d8 = this.snapSize(this.box.prefHeight(-1.0));
        double d9 = Math.max(checkBox.prefWidth(-1.0), checkBox.minWidth(-1.0));
        double d10 = Math.min(d9 - d7, d4 - this.snapSize(d7)) + d6;
        double d11 = Math.min(checkBox.prefHeight(d10), d5);
        double d12 = Math.max(d8, d11);
        double d13 = JFXCheckBoxSkin.computeXOffset(d4, d10 + d7, checkBox.getAlignment().getHpos()) + d2;
        double d14 = JFXCheckBoxSkin.computeYOffset(d5, d12, checkBox.getAlignment().getVpos()) + d2;
        if (this.invalid) {
            if (checkBox.isIndeterminate()) {
                this.playIndeterminateAnimation(true, false);
            } else if (checkBox.isSelected()) {
                this.playSelectAnimation(true, false);
            }
            this.invalid = false;
        }
        this.layoutLabelInArea(d13 + d7 + d6, d14, d10, d12, checkBox.getAlignment());
        this.rippler.resize(d7, d8);
        this.positionInArea((Node)this.rippler, d13, d14, d7, d12, 0.0, checkBox.getAlignment().getHpos(), checkBox.getAlignment().getVpos());
    }

    private double getLabelOffset() {
        return 0.2 * this.boxContainer.snappedRightInset();
    }

    static double computeXOffset(double d2, double d3, HPos hPos) {
        switch (hPos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (d2 - d3) / 2.0;
            }
            case RIGHT: {
                return d2 - d3;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double d2, double d3, VPos vPos) {
        switch (vPos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (d2 - d3) / 2.0;
            }
            case BOTTOM: {
                return d2 - d3;
            }
        }
        return 0.0;
    }

    private void playSelectAnimation(Boolean bl2, boolean bl3) {
        if (bl2 == null) {
            bl2 = false;
        }
        this.transition.setRate(bl2 != false ? 1.0 : -1.0);
        this.select.setRate(bl2 != false ? 1.0 : -1.0);
        if (bl3) {
            this.transition.play();
            this.select.play();
        } else {
            Insets insets;
            CornerRadii cornerRadii = this.box.getBackground() == null ? null : ((BackgroundFill)this.box.getBackground().getFills().get(0)).getRadii();
            Insets insets2 = insets = this.box.getBackground() == null ? null : ((BackgroundFill)this.box.getBackground().getFills().get(0)).getInsets();
            if (bl2.booleanValue()) {
                this.mark.setScaleY(1.0);
                this.mark.setScaleX(1.0);
                this.mark.setOpacity(1.0);
                this.box.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((JFXCheckBox)this.getSkinnable()).getCheckedColor(), cornerRadii, insets)}));
                this.select.playFrom(this.select.getCycleDuration());
                this.transition.playFrom(this.transition.getCycleDuration());
            } else {
                this.mark.setScaleY(0.0);
                this.mark.setScaleX(0.0);
                this.mark.setOpacity(0.0);
                this.box.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, cornerRadii, insets)}));
                this.select.playFrom(Duration.ZERO);
                this.transition.playFrom(Duration.ZERO);
            }
        }
        this.box.setBorder(new Border(new BorderStroke[]{new BorderStroke(bl2 != false ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : ((JFXCheckBox)this.getSkinnable()).getUnCheckedColor(), BorderStrokeStyle.SOLID, new CornerRadii(2.0), new BorderWidths(2.0))}));
    }

    private void playIndeterminateAnimation(Boolean bl2, boolean bl3) {
        if (bl2 == null) {
            bl2 = false;
        }
        this.indeterminateTransition.setRate(bl2 != false ? 1.0 : -1.0);
        if (bl3) {
            this.indeterminateTransition.play();
        } else if (bl2.booleanValue()) {
            CornerRadii cornerRadii = this.indeterminateMark.getBackground() == null ? null : ((BackgroundFill)this.indeterminateMark.getBackground().getFills().get(0)).getRadii();
            Insets insets = this.indeterminateMark.getBackground() == null ? null : ((BackgroundFill)this.indeterminateMark.getBackground().getFills().get(0)).getInsets();
            this.indeterminateMark.setOpacity(1.0);
            this.indeterminateMark.setScaleY(1.0);
            this.indeterminateMark.setScaleX(1.0);
            this.indeterminateMark.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((JFXCheckBox)this.getSkinnable()).getCheckedColor(), cornerRadii, insets)}));
            this.indeterminateTransition.playFrom(this.indeterminateTransition.getCycleDuration());
        } else {
            this.indeterminateMark.setOpacity(0.0);
            this.indeterminateMark.setScaleY(0.0);
            this.indeterminateMark.setScaleX(0.0);
            this.indeterminateTransition.playFrom(Duration.ZERO);
        }
        if (((CheckBox)this.getSkinnable()).isSelected()) {
            this.playSelectAnimation(bl2 == false, bl3);
        }
    }

    private void createFillTransition() {
        this.select = new JFXFillTransition(Duration.millis((double)120.0), (Region)this.box, Color.TRANSPARENT, (Color)((JFXCheckBox)this.getSkinnable()).getCheckedColor());
        this.select.setInterpolator(Interpolator.EASE_OUT);
    }

    private static final class CheckBoxTransition
    extends CachedTransition {
        protected Node mark;

        CheckBoxTransition(Node node) {
            super(null, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)0, Interpolator.EASE_OUT), new KeyValue((WritableValue)node.scaleXProperty(), (Object)0.5, Interpolator.EASE_OUT), new KeyValue((WritableValue)node.scaleYProperty(), (Object)0.5, Interpolator.EASE_OUT)}), new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{new KeyValue((WritableValue)node.opacityProperty(), (Object)1, Interpolator.EASE_OUT), new KeyValue((WritableValue)node.scaleXProperty(), (Object)0.5, Interpolator.EASE_OUT), new KeyValue((WritableValue)node.scaleYProperty(), (Object)0.5, Interpolator.EASE_OUT)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)1, Interpolator.EASE_OUT), new KeyValue((WritableValue)node.scaleYProperty(), (Object)1, Interpolator.EASE_OUT)})}));
            this.setCycleDuration(Duration.seconds((double)0.12));
            this.setDelay(Duration.seconds((double)0.05));
            this.mark = node;
        }

        @Override
        protected void starting() {
            super.starting();
        }

        @Override
        protected void stopping() {
            super.stopping();
            this.mark.setOpacity(this.getRate() == 1.0 ? 1.0 : 0.0);
        }
    }
}

