/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXAutoCompletePopup;
import com.jfoenix.controls.events.JFXAutoCompleteEvent;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class JFXAutoCompletePopupSkin<T>
implements Skin<JFXAutoCompletePopup<T>> {
    private JFXAutoCompletePopup<T> control;
    private ListView<T> suggestionList;
    private final StackPane pane = new StackPane();
    private Scale scale;
    private Timeline showTransition;
    private boolean itemChanged = true;

    public JFXAutoCompletePopupSkin(JFXAutoCompletePopup<T> jFXAutoCompletePopup) {
        this.control = jFXAutoCompletePopup;
        this.suggestionList = new ListView<T>(jFXAutoCompletePopup.getFilteredSuggestions()){

            protected void layoutChildren() {
                super.layoutChildren();
                if (JFXAutoCompletePopupSkin.this.itemChanged) {
                    if (JFXAutoCompletePopupSkin.this.suggestionList.getItems().size() > 0) {
                        JFXAutoCompletePopupSkin.this.suggestionList.getSelectionModel().select(0);
                        JFXAutoCompletePopupSkin.this.suggestionList.scrollTo(0);
                    }
                    JFXAutoCompletePopupSkin.this.itemChanged = false;
                }
            }
        };
        this.suggestionList.setFixedCellSize(jFXAutoCompletePopup.getFixedCellSize());
        jFXAutoCompletePopup.fixedCellSizeProperty().addListener(observable -> this.suggestionList.setFixedCellSize(jFXAutoCompletePopup.getFixedCellSize()));
        this.suggestionList.getItems().addListener(observable -> {
            this.itemChanged = true;
            this.updateListHeight();
        });
        this.suggestionList.getStyleClass().add((Object)"autocomplete-list");
        jFXAutoCompletePopup.suggestionsCellFactoryProperty().addListener((observableValue, callback, callback2) -> {
            if (callback2 != null) {
                this.suggestionList.setCellFactory(callback2);
            }
        });
        if (jFXAutoCompletePopup.getSuggestionsCellFactory() != null) {
            this.suggestionList.setCellFactory(jFXAutoCompletePopup.getSuggestionsCellFactory());
        }
        this.pane.getChildren().add((Object)new Group(new Node[]{this.suggestionList}));
        this.pane.getStyleClass().add((Object)"autocomplete-container");
        this.suggestionList.prefWidthProperty().bind((ObservableValue)jFXAutoCompletePopup.prefWidthProperty());
        this.suggestionList.maxWidthProperty().bind((ObservableValue)jFXAutoCompletePopup.maxWidthProperty());
        this.suggestionList.minWidthProperty().bind((ObservableValue)jFXAutoCompletePopup.minWidthProperty());
        this.registerEventListener();
    }

    private void registerEventListener() {
        this.suggestionList.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                this.selectItem();
                this.getSkinnable().hide();
            }
        });
        this.control.showingProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.animate();
            }
        });
        this.suggestionList.setOnKeyPressed(keyEvent -> {
            switch (keyEvent.getCode()) {
                case ENTER: {
                    this.selectItem();
                    this.getSkinnable().hide();
                    break;
                }
                case ESCAPE: {
                    this.getSkinnable().hide();
                    break;
                }
            }
        });
    }

    public void animate() {
        this.updateListHeight();
        if (this.showTransition == null || this.showTransition.getStatus().equals((Object)Animation.Status.STOPPED)) {
            if (this.scale == null) {
                this.scale = new Scale(1.0, 0.0);
                this.pane.getTransforms().add((Object)this.scale);
            }
            this.scale.setY(0.0);
            this.suggestionList.setOpacity(0.0);
            this.scale.setPivotX(this.pane.getLayoutBounds().getWidth() / 2.0);
            this.showTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)120.0), new KeyValue[]{new KeyValue((WritableValue)this.scale.yProperty(), (Object)1, Interpolator.EASE_BOTH)})});
            this.showTransition.setOnFinished(actionEvent2 -> {
                Group group = (Group)this.suggestionList.lookup(".sheet");
                ParallelTransition parallelTransition = new ParallelTransition();
                for (int i2 = 0; i2 < group.getChildren().size(); ++i2) {
                    ListCell listCell = (ListCell)group.getChildren().get(i2);
                    int n2 = listCell.getIndex();
                    if (n2 <= -1) continue;
                    listCell.setOpacity(0.0);
                    listCell.setTranslateY(-this.suggestionList.getFixedCellSize() / 8.0);
                    Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)120.0), actionEvent -> {
                        listCell.setOpacity(1.0);
                        listCell.setTranslateY(0.0);
                    }, new KeyValue[]{new KeyValue((WritableValue)listCell.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)listCell.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                    timeline.setDelay(Duration.millis((double)(n2 * 20)));
                    parallelTransition.getChildren().add((Object)timeline);
                }
                this.suggestionList.setOpacity(1.0);
                parallelTransition.play();
            });
            this.showTransition.play();
        }
    }

    private void updateListHeight() {
        double d2 = (double)Math.min(this.suggestionList.getItems().size(), this.getSkinnable().getCellLimit()) * this.suggestionList.getFixedCellSize();
        this.suggestionList.setPrefHeight(d2 + this.suggestionList.getFixedCellSize() / 2.0);
    }

    private void selectItem() {
        Object object = this.suggestionList.getSelectionModel().getSelectedItem();
        if (object == null) {
            try {
                this.suggestionList.getSelectionModel().select(0);
                object = this.suggestionList.getSelectionModel().getSelectedItem();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object != null) {
            this.control.getSelectionHandler().handle(new JFXAutoCompleteEvent<Object>(JFXAutoCompleteEvent.SELECTION, object));
        }
    }

    public Node getNode() {
        return this.pane;
    }

    public JFXAutoCompletePopup<T> getSkinnable() {
        return this.control;
    }

    public void dispose() {
        this.control = null;
        if (this.showTransition != null) {
            this.showTransition.stop();
            this.showTransition.getKeyFrames().clear();
            this.showTransition = null;
        }
    }
}

