/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.converters;

import com.jfoenix.controls.JFXButton;
import java.util.logging.Logger;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.scene.text.Font;

public class ButtonTypeConverter
extends StyleConverter<String, JFXButton.ButtonType> {
    private ButtonTypeConverter() {
    }

    public static StyleConverter<String, JFXButton.ButtonType> getInstance() {
        return Holder.INSTANCE;
    }

    public JFXButton.ButtonType convert(ParsedValue<String, JFXButton.ButtonType> parsedValue, Font font) {
        String string = (String)parsedValue.getValue();
        try {
            return JFXButton.ButtonType.valueOf(string);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            Logger.getLogger(ButtonTypeConverter.class.getName()).info(String.format("Invalid button type value '%s'", string));
            return JFXButton.ButtonType.FLAT;
        }
    }

    public String toString() {
        return "ButtonTypeConverter";
    }

    private static class Holder {
        static final ButtonTypeConverter INSTANCE = new ButtonTypeConverter();

        private Holder() {
            throw new IllegalAccessError("Holder class");
        }
    }
}

