/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.pannable.gestures;

import com.jfoenix.controls.pannable.base.IPannablePane;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class PanningGestures<T extends Node> {
    private T canvas;
    private final DragContext sceneDragContext = new DragContext();
    private final DoubleProperty minScaleProperty = new SimpleDoubleProperty(0.1);
    private final DoubleProperty maxScaleProperty = new SimpleDoubleProperty(10.0);
    private final DoubleProperty zoomSpeedProperty = new SimpleDoubleProperty(1.2);
    private SimpleBooleanProperty useViewportGestures = null;
    private boolean bound = false;
    private final EventHandler<MouseEvent> onMousePressedEventHandler = mouseEvent -> {
        if (!mouseEvent.isSecondaryButtonDown()) {
            return;
        }
        this.sceneDragContext.mouseAnchorX = mouseEvent.getSceneX();
        this.sceneDragContext.mouseAnchorY = mouseEvent.getSceneY();
        this.sceneDragContext.translateAnchorX = this.canvas.getTranslateX();
        this.sceneDragContext.translateAnchorY = this.canvas.getTranslateY();
    };
    private final EventHandler<MouseEvent> onMouseDraggedEventHandler = mouseEvent -> {
        if (!mouseEvent.isSecondaryButtonDown()) {
            return;
        }
        Bounds bounds = this.canvas.getParent().getLayoutBounds();
        Bounds bounds2 = this.canvas.getBoundsInParent();
        double d2 = this.sceneDragContext.translateAnchorX + mouseEvent.getSceneX() - this.sceneDragContext.mouseAnchorX;
        this.canvas.setTranslateX(this.bound(d2, bounds.getWidth(), bounds2.getWidth()));
        double d3 = this.sceneDragContext.translateAnchorY + mouseEvent.getSceneY() - this.sceneDragContext.mouseAnchorY;
        this.canvas.setTranslateY(this.bound(d3, bounds.getHeight(), bounds2.getHeight()));
        mouseEvent.consume();
    };
    private final EventHandler<ScrollEvent> onScrollEventHandler = scrollEvent -> {
        double d2 = ((IPannablePane)this.canvas).getScale();
        d2 = scrollEvent.getDeltaY() < 0.0 ? (d2 /= this.getZoomSpeed()) : (d2 *= this.getZoomSpeed());
        d2 = PanningGestures.clamp(d2, this.minScaleProperty.get(), this.maxScaleProperty.get());
        Point2D point2D = this.canvas.parentToLocal(scrollEvent.getX(), scrollEvent.getY());
        ((IPannablePane)this.canvas).setScale(d2);
        Point2D point2D2 = this.canvas.localToParent(point2D);
        Bounds bounds = this.canvas.getParent().getLayoutBounds();
        Bounds bounds2 = this.canvas.getBoundsInParent();
        double d3 = bounds.getWidth() - bounds2.getWidth() - 20.0;
        this.canvas.setTranslateX(this.bound(this.canvas.getTranslateX() - (point2D2.getX() - scrollEvent.getX()), bounds.getWidth(), bounds2.getWidth()));
        this.canvas.setTranslateY(this.bound(this.canvas.getTranslateY() - (point2D2.getY() - scrollEvent.getY()), bounds.getHeight(), bounds2.getHeight()));
        scrollEvent.consume();
    };

    public PanningGestures(T t2) {
        this.canvas = t2;
    }

    public double getMinScale() {
        return this.minScaleProperty.get();
    }

    public void setMinScale(double d2) {
        this.minScaleProperty.set(d2);
    }

    public DoubleProperty minScaleProperty() {
        return this.minScaleProperty;
    }

    public double getMaxScale() {
        return this.maxScaleProperty.get();
    }

    public DoubleProperty maxScaleProperty() {
        return this.maxScaleProperty;
    }

    public void setMaxScale(double d2) {
        this.maxScaleProperty.set(d2);
    }

    public double getZoomSpeed() {
        return this.zoomSpeedProperty.get();
    }

    public DoubleProperty zoomSpeedProperty() {
        return this.zoomSpeedProperty;
    }

    public void setZoomSpeed(double d2) {
        this.zoomSpeedProperty.set(d2);
    }

    public final BooleanProperty useViewPortGesturesProperty() {
        return this.useViewportGestures;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bl2) {
        this.bound = bl2;
    }

    private double bound(double d2, double d3, double d4) {
        if (!this.bound) {
            return d2;
        }
        double d5 = d3 - d4 - 20.0 * ((IPannablePane)this.canvas).getScale();
        d2 = d3 > d4 ? 1.0 : this.inBound(d5, 1.0, d2);
        return d2;
    }

    private double inBound(double d2, double d3, double d4) {
        if (d4 < d2) {
            d4 = d2;
        } else if (d4 > d3) {
            d4 = d3;
        }
        return d4;
    }

    public static double clamp(double d2, double d3, double d4) {
        if (Double.compare(d2, d3) < 0) {
            return d3;
        }
        if (Double.compare(d2, d4) > 0) {
            return d4;
        }
        return d2;
    }

    public static <T extends Node> PanningGestures<T> attachViewPortGestures(T t2) {
        return PanningGestures.attachViewPortGestures(t2, false);
    }

    public static <T extends Node> PanningGestures<T> attachViewPortGestures(T t2, boolean bl4) {
        PanningGestures<T> panningGestures = new PanningGestures<T>(t2);
        if (bl4) {
            panningGestures.useViewportGestures = new SimpleBooleanProperty(true);
            panningGestures.useViewportGestures.addListener((observableValue, bl2, bl3) -> {
                Parent parent = (Parent)t2.parentProperty().get();
                if (parent == null) {
                    return;
                }
                if (bl3.booleanValue()) {
                    parent.addEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
                    parent.addEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
                    parent.addEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
                } else {
                    parent.removeEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
                    parent.removeEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
                    parent.removeEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
                }
            });
        }
        t2.parentProperty().addListener((observableValue, parent, parent2) -> {
            if (parent != null) {
                parent.removeEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
                parent.removeEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
                parent.removeEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
            }
            if (parent2 != null) {
                parent2.addEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
                parent2.addEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
                parent2.addEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
            }
        });
        return panningGestures;
    }

    private static class DragContext {
        double mouseAnchorX;
        double mouseAnchorY;
        double translateAnchorX;
        double translateAnchorY;

        private DragContext() {
        }
    }
}

