/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import com.jfoenix.utils.JFXUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;

public class RecursiveTreeItem<T extends RecursiveTreeObject<T>>
extends TreeItem<T> {
    private Callback<RecursiveTreeObject<T>, ObservableList<T>> childrenFactory;
    private ObjectProperty<Predicate<TreeItem<T>>> predicate = new SimpleObjectProperty(treeItem -> true);
    private HashMap<T, TreeItem<T>> itemsMap;
    ObservableList<TreeItem<T>> originalItems;
    FilteredList<TreeItem<T>> filteredItems;

    public RecursiveTreeItem(Callback<RecursiveTreeObject<T>, ObservableList<T>> callback) {
        this(null, null, callback);
    }

    public RecursiveTreeItem(T t2, Callback<RecursiveTreeObject<T>, ObservableList<T>> callback) {
        this(t2, null, callback);
    }

    public RecursiveTreeItem(T t2, Node node, Callback<RecursiveTreeObject<T>, ObservableList<T>> callback) {
        super(t2, node);
        this.childrenFactory = callback;
        this.init((RecursiveTreeObject<T>)t2);
    }

    public RecursiveTreeItem(ObservableList<T> observableList, Callback<RecursiveTreeObject<T>, ObservableList<T>> callback) {
        RecursiveTreeObject<T> recursiveTreeObject = new RecursiveTreeObject<T>();
        recursiveTreeObject.setChildren(observableList);
        this.childrenFactory = callback;
        this.init(recursiveTreeObject);
    }

    private void init(RecursiveTreeObject<T> recursiveTreeObject) {
        this.addChildrenListener(recursiveTreeObject);
        this.valueProperty().addListener(observable -> {
            if (this.getValue() != null) {
                this.addChildrenListener((RecursiveTreeObject)this.getValue());
            }
        });
        this.predicate.addListener(observable -> this.filteredItems.setPredicate(treeItem -> {
            if (treeItem instanceof RecursiveTreeItem && !((RecursiveTreeItem)treeItem).originalItems.isEmpty()) {
                RecursiveTreeItem recursiveTreeItem = (RecursiveTreeItem)((Object)((Object)treeItem));
                recursiveTreeItem.setPredicate((Predicate)this.predicate.get());
            }
            if (this.predicate.get() == null) {
                return true;
            }
            if (treeItem.getChildren().size() > 0) {
                return true;
            }
            if (treeItem.getValue() instanceof RecursiveTreeObject && ((RecursiveTreeObject)treeItem.getValue()).getClass() == RecursiveTreeObject.class) {
                return treeItem.getChildren().size() != 0;
            }
            return ((Predicate)this.predicate.get()).test(treeItem);
        }));
        this.filteredItems.predicateProperty().addListener(observable -> JFXUtilities.runInFXAndWait(() -> {
            this.getChildren().clear();
            this.getChildren().setAll(this.filteredItems);
        }));
    }

    private void addChildrenListener(RecursiveTreeObject<T> recursiveTreeObject) {
        ObservableList observableList = (ObservableList)this.childrenFactory.call(recursiveTreeObject);
        this.originalItems = FXCollections.observableArrayList();
        this.itemsMap = new HashMap();
        for (RecursiveTreeObject recursiveTreeObject2 : observableList) {
            RecursiveTreeItem<RecursiveTreeObject> recursiveTreeItem = new RecursiveTreeItem<RecursiveTreeObject>(recursiveTreeObject2, this.getGraphic(), this.childrenFactory);
            this.originalItems.add(recursiveTreeItem);
            this.itemsMap.put(recursiveTreeObject2, recursiveTreeItem);
        }
        this.filteredItems = new FilteredList(this.originalItems, treeItem -> true);
        this.getChildren().addAll(this.originalItems);
        observableList.addListener(change -> {
            while (change.next()) {
                TreeItem<T> treeItem;
                ArrayList<TreeItem<T>> arrayList;
                if (change.wasRemoved()) {
                    arrayList = new ArrayList<TreeItem<T>>();
                    for (RecursiveTreeObject recursiveTreeObject : change.getRemoved()) {
                        treeItem = this.itemsMap.remove(recursiveTreeObject);
                        if (treeItem == null) continue;
                        arrayList.add(treeItem);
                    }
                    if (this.originalItems.size() == arrayList.size()) {
                        this.originalItems.clear();
                        this.getChildren().clear();
                    } else {
                        this.getChildren().removeAll(arrayList);
                        this.originalItems.removeAll(arrayList);
                    }
                }
                if (!change.wasAdded()) continue;
                arrayList = new ArrayList();
                for (RecursiveTreeObject recursiveTreeObject : change.getAddedSubList()) {
                    treeItem = new RecursiveTreeItem<RecursiveTreeObject>(recursiveTreeObject, this.getGraphic(), this.childrenFactory);
                    arrayList.add(treeItem);
                    this.itemsMap.put(recursiveTreeObject, treeItem);
                }
                this.getChildren().addAll(arrayList);
                this.originalItems.addAll(arrayList);
            }
        });
    }

    public final ObjectProperty<Predicate<TreeItem<T>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<T>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<T>> predicate) {
        this.predicateProperty().set(predicate);
    }

    public TreeItem<T> getTreeItem(T t2) {
        return this.itemsMap.get(t2);
    }
}

