/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.JFXTreeTableRow;
import com.jfoenix.controls.RecursiveTreeItem;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import com.jfoenix.skins.JFXTreeTableViewSkin;
import com.jfoenix.utils.JFXUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;

public class JFXTreeTableView<S extends RecursiveTreeObject<S>>
extends TreeTableView<S> {
    private TreeItem<S> originalRoot;
    private boolean internalSetRoot = false;
    private static final String DEFAULT_STYLE_CLASS = "jfx-tree-table-view";
    private static final String USER_AGENT_STYLESHEET = JFoenixResources.load("css/controls/jfx-tree-table-view.css").toExternalForm();
    private boolean itemWasSelected = false;
    private ObservableList<TreeTableColumn<S, ?>> groupOrder = FXCollections.observableArrayList();
    private final Lock lock = new ReentrantLock(true);
    BiConsumer<Object, RecursiveTreeObject> groupedRootConsumer = null;
    private ScheduledExecutorService threadPool = this.createThreadPool();
    private Runnable filterRunnable = () -> {
        if (this.originalRoot == null) {
            this.originalRoot = this.getRoot();
        }
        ((RecursiveTreeItem)this.originalRoot).setPredicate(this.getPredicate());
        this.reGroup();
        Platform.runLater(() -> {
            this.getSelectionModel().select(0);
            this.setCurrentItemsCount(this.count(this.getRoot()));
        });
    };
    private ScheduledFuture<?> task;
    private ObjectProperty<Predicate<TreeItem<S>>> predicate = new SimpleObjectProperty(treeItem -> true);
    private IntegerProperty currentItemsCount = new SimpleIntegerProperty(0);
    private Map<Object, Map<Object, ?>> groups;

    public JFXTreeTableView() {
        this.init();
    }

    public JFXTreeTableView(TreeItem<S> treeItem2) {
        super(treeItem2);
        this.originalRoot = treeItem2;
        this.init();
    }

    public void propagateMouseEventsToParent() {
        this.addEventHandler(MouseEvent.ANY, mouseEvent -> {
            mouseEvent.consume();
            this.getParent().fireEvent(mouseEvent);
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXTreeTableViewSkin(this);
    }

    protected void init() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setRowFactory(treeTableView -> new JFXTreeTableRow());
        this.getSelectionModel().selectedItemProperty().addListener((observableValue, treeItem, treeItem2) -> {
            if (treeItem2 != null && treeItem2.getValue() != null) {
                this.itemWasSelected = true;
            }
        });
        this.predicate.addListener(observable -> this.filter(this.getPredicate()));
        this.sceneProperty().addListener(observable -> {
            if (this.getScene() == null) {
                this.threadPool.shutdownNow();
            } else if (this.threadPool.isTerminated()) {
                this.threadPool = this.createThreadPool();
            }
        });
        this.rootProperty().addListener(observable -> {
            if (this.getRoot() != null) {
                this.setCurrentItemsCount(this.count(this.getRoot()));
            }
            if (!this.internalSetRoot) {
                this.originalRoot = this.getRoot();
                this.reGroup();
            }
        });
        this.setCurrentItemsCount(this.count(this.getRoot()));
    }

    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    public int getTreeItemLevel(TreeItem<?> treeItem) {
        TreeItem treeItem2 = this.getRoot();
        if (treeItem == null) {
            return -1;
        }
        if (treeItem == treeItem2) {
            return 0;
        }
        int n2 = 0;
        for (TreeItem treeItem3 = treeItem.getParent(); treeItem3 != null; treeItem3 = treeItem3.getParent()) {
            ++n2;
            if (treeItem3 == treeItem2) break;
            if (treeItem3.getValue() == null || !(treeItem3.getValue() instanceof RecursiveTreeObject) || ((RecursiveTreeObject)treeItem3.getValue()).getGroupedColumn() == null) continue;
            --n2;
        }
        return n2;
    }

    public void sort() {
        this.getSelectionModel().clearSelection();
        super.sort();
        if (this.itemWasSelected) {
            this.getSelectionModel().select(0);
        }
    }

    final ObservableList<TreeTableColumn<S, ?>> getGroupOrder() {
        return this.groupOrder;
    }

    public BiConsumer<Object, RecursiveTreeObject> getGroupedRootConsumer() {
        return this.groupedRootConsumer;
    }

    public void setGroupedRootConsumer(BiConsumer<Object, RecursiveTreeObject> biConsumer) {
        this.groupedRootConsumer = biConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void group(TreeTableColumn<S, ?> ... treeTableColumnArray) {
        try {
            this.lock.lock();
            if (this.groupOrder.size() == 0) {
                this.groups = new HashMap();
            }
            try {
                if (this.originalRoot == null) {
                    this.originalRoot = this.getRoot();
                }
                ArrayList arrayList = new ArrayList();
                for (TreeTableColumn<S, ?> treeTableColumn : treeTableColumnArray) {
                    if (this.groupOrder.contains(treeTableColumn)) continue;
                    arrayList.add(treeTableColumn);
                    this.groups = this.group(treeTableColumn, this.groups, null, (RecursiveTreeItem)this.originalRoot);
                }
                this.groupOrder.addAll(arrayList);
                this.buildGroupedRoot(this.groups, null, 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void refreshGroups(List<TreeTableColumn<S, ?>> list) {
        this.groups = new HashMap();
        for (TreeTableColumn<S, ?> treeTableColumn : list) {
            this.groups = this.group(treeTableColumn, this.groups, null, (RecursiveTreeItem)this.originalRoot);
        }
        this.groupOrder.setAll(list);
        this.buildGroupedRoot(this.groups, null, 0);
    }

    public void unGroup(TreeTableColumn<S, ?> ... treeTableColumnArray) {
        try {
            this.lock.lock();
            if (this.groupOrder.size() > 0) {
                this.groupOrder.removeAll((Object[])treeTableColumnArray);
                ArrayList arrayList = new ArrayList(this.groupOrder);
                JFXUtilities.runInFXAndWait(() -> {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(this.getSortOrder());
                    List<Object> list2 = Arrays.asList(this.originalRoot.getChildren().toArray());
                    this.originalRoot.getChildren().clear();
                    this.originalRoot.getChildren().setAll(list2);
                    this.internalSetRoot = true;
                    this.setRoot(this.originalRoot);
                    this.internalSetRoot = false;
                    this.getSelectionModel().select(0);
                    this.getSortOrder().addAll(arrayList);
                    if (arrayList.size() != 0) {
                        this.refreshGroups(arrayList);
                    }
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private Map group(TreeTableColumn<S, ?> treeTableColumn, Map map, Object object, RecursiveTreeItem<S> recursiveTreeItem) {
        if (map.isEmpty()) {
            map = this.groupByFunction((List<TreeItem<S>>)recursiveTreeItem.filteredItems, treeTableColumn);
            return map;
        }
        Object object2 = map.get(object);
        if (object2 instanceof List) {
            Map map2 = this.groupByFunction((List)object2, treeTableColumn);
            map.put(object, map2);
            return map;
        }
        if (object2 instanceof Map) {
            for (Object k2 : ((Map)object2).keySet()) {
                object2 = this.group(treeTableColumn, (Map)object2, k2, recursiveTreeItem);
            }
            map.put(object, object2);
            return map;
        }
        if (object == null) {
            for (Object k3 : map.keySet()) {
                map = this.group(treeTableColumn, map, k3, recursiveTreeItem);
            }
            return map;
        }
        return map;
    }

    protected Map groupByFunction(List<TreeItem<S>> list, TreeTableColumn<S, ?> treeTableColumn) {
        HashMap<Object, List> hashMap = new HashMap<Object, List>();
        for (TreeItem<S> treeItem : list) {
            Object object2 = treeTableColumn.getCellData(treeItem);
            hashMap.computeIfAbsent(object2, object -> new ArrayList());
            ((List)hashMap.get(object2)).add(treeItem);
        }
        return hashMap;
    }

    private void buildGroupedRoot(Map<?, ?> map, RecursiveTreeItem recursiveTreeItem, int n2) {
        boolean bl4 = false;
        if (recursiveTreeItem == null) {
            recursiveTreeItem = new RecursiveTreeItem(new RecursiveTreeObject(), RecursiveTreeObject::getChildren);
            bl4 = true;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getKey();
            RecursiveTreeObject recursiveTreeObject = new RecursiveTreeObject();
            recursiveTreeObject.setGroupedValue(obj);
            recursiveTreeObject.setGroupedColumn((TreeTableColumn)this.groupOrder.get(n2));
            RecursiveTreeItem recursiveTreeItem2 = new RecursiveTreeItem(recursiveTreeObject, RecursiveTreeObject::getChildren);
            recursiveTreeItem2.expandedProperty().addListener((observableValue, bl2, bl3) -> this.getSelectionModel().clearSelection());
            recursiveTreeItem.originalItems.add(recursiveTreeItem2);
            recursiveTreeItem.getChildren().add(recursiveTreeItem2);
            Object obj2 = entry.getValue();
            if (obj2 instanceof List) {
                recursiveTreeItem2.originalItems.addAll((Collection)((List)obj2));
                recursiveTreeItem2.getChildren().addAll((Collection)((List)obj2));
            } else if (obj2 instanceof Map) {
                this.buildGroupedRoot((Map)obj2, recursiveTreeItem2, n2 + 1);
            }
            recursiveTreeObject.setChildren(recursiveTreeItem2.getChildren());
            if (this.groupedRootConsumer == null) continue;
            this.groupedRootConsumer.accept(obj, recursiveTreeObject);
        }
        if (bl4) {
            Object object = recursiveTreeItem;
            JFXUtilities.runInFX(() -> {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(this.getSortOrder());
                this.internalSetRoot = true;
                this.setRoot((TreeItem)object);
                this.internalSetRoot = false;
                this.getSortOrder().addAll(arrayList);
                this.getSelectionModel().select(0);
            });
        }
    }

    private ScheduledExecutorService createThreadPool() {
        return Executors.newScheduledThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("JFXTreeTableView Filter Thread");
            thread.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(thread);
            return thread;
        });
    }

    private void filter(Predicate<TreeItem<S>> predicate) {
        if (this.task != null) {
            this.task.cancel(false);
        }
        this.task = this.threadPool.schedule(this.filterRunnable, 200L, TimeUnit.MILLISECONDS);
    }

    public void reGroup() {
        if (!this.groupOrder.isEmpty()) {
            ArrayList arrayList = new ArrayList(this.groupOrder);
            this.groupOrder.clear();
            this.group(arrayList.toArray(new TreeTableColumn[0]));
        }
    }

    public final ObjectProperty<Predicate<TreeItem<S>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<S>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<S>> predicate) {
        this.predicateProperty().set(predicate);
    }

    public final IntegerProperty currentItemsCountProperty() {
        return this.currentItemsCount;
    }

    public final int getCurrentItemsCount() {
        return this.currentItemsCountProperty().get();
    }

    public final void setCurrentItemsCount(int n2) {
        this.currentItemsCountProperty().set(n2);
    }

    private int count(TreeItem<?> treeItem) {
        if (treeItem == null) {
            return 0;
        }
        int n2 = 1;
        if (treeItem.getValue() == null || treeItem.getValue() != null && treeItem.getValue().getClass().equals(RecursiveTreeObject.class)) {
            n2 = 0;
        }
        for (TreeItem treeItem2 : treeItem.getChildren()) {
            n2 += this.count(treeItem2);
        }
        return n2;
    }
}

