/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.scene.NodeHelper;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.control.skin.TooltipSkin;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;

public class JFXTooltip
extends Tooltip {
    private static TooltipBehavior BEHAVIOR = new TooltipBehavior(Duration.millis((double)650.0), Duration.millis((double)1500.0), Duration.millis((double)200.0));
    private Node root = null;
    private boolean hiding = false;
    private JFXAnimationTimer animation = new JFXAnimationTimer(JFXKeyFrame.builder().setDuration(Duration.millis((double)150.0)).setAnimateCondition(() -> !this.hiding).setKeyValues(JFXKeyValue.builder().setTargetSupplier(() -> this.root.opacityProperty()).setEndValue(1).build(), JFXKeyValue.builder().setTargetSupplier(() -> this.root.scaleXProperty()).setEndValue(1).build(), JFXKeyValue.builder().setTargetSupplier(() -> this.root.scaleYProperty()).setEndValue(1).build()).build(), JFXKeyFrame.builder().setDuration(Duration.millis((double)75.0)).setAnimateCondition(() -> this.hiding).setKeyValues(JFXKeyValue.builder().setTargetSupplier(() -> this.root.opacityProperty()).setEndValue(0).build()).build());
    private Pos pos = Pos.BOTTOM_CENTER;
    private double margin = 8.0;
    private static final String DEFAULT_STYLE_CLASS = "jfx-tooltip";
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);

    public static void setHoverDelay(Duration duration) {
        JFXTooltip.BEHAVIOR.setHoverDelay(duration == null ? Duration.millis((double)650.0) : duration);
    }

    public static void setVisibleDuration(Duration duration) {
        JFXTooltip.BEHAVIOR.setVisibleDuration(duration == null ? Duration.millis((double)1500.0) : duration);
    }

    public static void setLeftDelay(Duration duration) {
        JFXTooltip.BEHAVIOR.setLeftDelay(duration == null ? Duration.millis((double)200.0) : duration);
    }

    public static void install(Node node, JFXTooltip jFXTooltip) {
        JFXTooltip.BEHAVIOR.install(node, jFXTooltip);
    }

    public static void install(Node node, JFXTooltip jFXTooltip, Pos pos) {
        jFXTooltip.setPos(pos);
        JFXTooltip.BEHAVIOR.install(node, jFXTooltip);
    }

    public static void uninstall(Node node) {
        JFXTooltip.BEHAVIOR.uninstall(node);
    }

    public JFXTooltip() {
        this(null);
    }

    public JFXTooltip(String string, Pos pos) {
        this(string);
        this.setPos(pos);
    }

    public JFXTooltip(String string) {
        super(string);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.eventHandlerManager.addEventHandler(WindowEvent.WINDOW_SHOWING, windowEvent -> {
            this.root = this.getScene().getRoot();
            this.root.setOpacity(0.0);
            this.root.setScaleY(0.8);
            this.root.setScaleX(0.8);
            this.animation.setOnFinished(null);
        });
        this.eventHandlerManager.addEventHandler(WindowEvent.WINDOW_SHOWN, windowEvent -> {
            this.setAnchorX(this.getUpdatedAnchorX(this.getAnchorX()));
            this.setAnchorY(this.getUpdatedAnchorY(this.getAnchorY()));
            this.animation.reverseAndContinue();
        });
    }

    public Pos getPos() {
        return this.pos;
    }

    public void setPos(Pos pos) {
        this.pos = pos == null ? Pos.BOTTOM_CENTER : pos;
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double d2) {
        this.margin = d2;
    }

    private double getUpdatedAnchorY(double d2) {
        switch (this.pos.getVpos()) {
            case CENTER: {
                return d2 - this.getHeight() / 2.0;
            }
            case TOP: 
            case BASELINE: {
                return d2 - this.getHeight();
            }
        }
        return d2;
    }

    private double getUpdatedAnchorX(double d2) {
        switch (this.pos.getHpos()) {
            case CENTER: {
                return d2 - this.getWidth() / 2.0;
            }
            case LEFT: {
                return d2 - this.getWidth();
            }
        }
        return d2;
    }

    public void hide() {
        this.hiding = true;
        this.animation.setOnFinished(() -> super.hide());
        this.animation.reverseAndContinue();
    }

    public void show(Node node, double d2, double d3) {
        this.hiding = false;
        Bounds bounds = node.localToScene(node.getBoundsInLocal());
        if (this.isShowing()) {
            this.animation.setOnFinished(null);
            this.animation.reverseAndContinue();
            d2 = this.ownerX(node, bounds) + this.getHPosForNode(bounds);
            d3 = this.ownerY(node, bounds) + this.getVPosForNode(bounds);
            this.setAnchorY(this.getUpdatedAnchorY(d3));
            this.setAnchorX(this.getUpdatedAnchorX(d2));
        } else {
            d2 = this.ownerX(node, bounds) + this.getHPosForNode(bounds);
            d3 = this.ownerY(node, bounds) + this.getVPosForNode(bounds);
            super.show(node, d2, d3);
        }
    }

    private double ownerX(Node node, Bounds bounds) {
        Window window = node.getScene().getWindow();
        return window.getX() + bounds.getMinX() + node.getScene().getX();
    }

    private double ownerY(Node node, Bounds bounds) {
        Window window = node.getScene().getWindow();
        return window.getY() + bounds.getMinY() + node.getScene().getY();
    }

    public void showOnAnchors(Node node, double d2, double d3) {
        this.hiding = false;
        Bounds bounds = node.localToScene(node.getBoundsInLocal());
        if (this.isShowing()) {
            this.animation.setOnFinished(null);
            this.animation.reverseAndContinue();
            this.setAnchorX(this.getUpdatedAnchorX(d2 += this.ownerX(node, bounds)));
            this.setAnchorY(this.getUpdatedAnchorY(d3 += this.ownerY(node, bounds)));
        } else {
            super.show(node, d2 += this.ownerX(node, bounds), d3 += this.ownerY(node, bounds));
        }
    }

    private double getHPosForNode(Bounds bounds) {
        double d2 = -this.margin;
        switch (this.pos.getHpos()) {
            case CENTER: {
                d2 = bounds.getWidth() / 2.0;
                break;
            }
            case RIGHT: {
                d2 = bounds.getWidth() + this.margin;
            }
        }
        return d2;
    }

    private double getVPosForNode(Bounds bounds) {
        double d2 = -this.margin;
        switch (this.pos.getVpos()) {
            case CENTER: {
                d2 = bounds.getHeight() / 2.0;
                break;
            }
            case BOTTOM: {
                d2 = bounds.getHeight() + this.margin;
            }
        }
        return d2;
    }

    protected Skin<?> createDefaultSkin() {
        return new TooltipSkin(this){
            {
                Node node = this.getNode();
                node.setEffect(null);
            }
        };
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return super.buildEventDispatchChain(eventDispatchChain).prepend((EventDispatcher)this.eventHandlerManager);
    }

    private static class TooltipBehavior {
        private static String TOOLTIP_PROP = "jfoenix-tooltip";
        private Timeline hoverTimer = new Timeline();
        private Timeline visibleTimer = new Timeline();
        private Timeline leftTimer = new Timeline();
        private Node hoveredNode;
        private JFXTooltip nextTooltip;
        private JFXTooltip currentTooltip;
        private EventHandler<MouseEvent> moveHandler = mouseEvent -> {
            if (this.visibleTimer.getStatus() == Animation.Status.RUNNING) {
                return;
            }
            this.hoveredNode = (Node)mouseEvent.getSource();
            Object object = this.hoveredNode.getProperties().get((Object)TOOLTIP_PROP);
            if (object instanceof JFXTooltip) {
                JFXTooltip jFXTooltip = (JFXTooltip)((Object)((Object)object));
                this.ensureHoveredNodeIsVisible(() -> {
                    if (this.leftTimer.getStatus() == Animation.Status.RUNNING) {
                        if (this.currentTooltip != null) {
                            this.currentTooltip.hide();
                        }
                        this.currentTooltip = jFXTooltip;
                        this.showTooltip(jFXTooltip);
                        this.leftTimer.stop();
                        this.visibleTimer.playFromStart();
                    } else {
                        this.nextTooltip = jFXTooltip;
                        this.hoverTimer.stop();
                        this.hoverTimer.playFromStart();
                    }
                });
            } else {
                this.uninstall(this.hoveredNode);
            }
        };
        private WeakEventHandler<MouseEvent> weakMoveHandler = new WeakEventHandler(this.moveHandler);
        private EventHandler<MouseEvent> exitHandler = mouseEvent -> {
            if (this.hoverTimer.getStatus() == Animation.Status.RUNNING) {
                this.hoverTimer.stop();
            } else if (this.visibleTimer.getStatus() == Animation.Status.RUNNING) {
                this.visibleTimer.stop();
                this.leftTimer.playFromStart();
            }
            this.hoveredNode = null;
            this.nextTooltip = null;
        };
        private WeakEventHandler<MouseEvent> weakExitHandler = new WeakEventHandler(this.exitHandler);
        private EventHandler<MouseEvent> pressedHandler = mouseEvent -> {
            this.hoverTimer.stop();
            this.visibleTimer.stop();
            this.leftTimer.stop();
            if (this.currentTooltip != null) {
                this.currentTooltip.hide();
            }
            this.hoveredNode = null;
            this.currentTooltip = null;
            this.nextTooltip = null;
        };
        private WeakEventHandler<MouseEvent> weakPressedHandler = new WeakEventHandler(this.pressedHandler);

        private TooltipBehavior(Duration duration, Duration duration2, Duration duration3) {
            this.setHoverDelay(duration);
            this.hoverTimer.setOnFinished(actionEvent -> {
                this.ensureHoveredNodeIsVisible(() -> {
                    NodeOrientation nodeOrientation = this.hoveredNode.getEffectiveNodeOrientation();
                    this.nextTooltip.getScene().setNodeOrientation(nodeOrientation);
                    this.showTooltip(this.nextTooltip);
                    this.currentTooltip = this.nextTooltip;
                    this.hoveredNode = null;
                    this.visibleTimer.playFromStart();
                });
                this.nextTooltip = null;
            });
            this.setVisibleDuration(duration2);
            this.visibleTimer.setOnFinished(actionEvent -> this.hideCurrentTooltip());
            this.setLeftDelay(duration3);
            this.leftTimer.setOnFinished(actionEvent -> this.hideCurrentTooltip());
        }

        private void setHoverDelay(Duration duration) {
            this.hoverTimer.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(duration, new KeyValue[0])});
        }

        private void setVisibleDuration(Duration duration) {
            this.visibleTimer.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(duration, new KeyValue[0])});
        }

        private void setLeftDelay(Duration duration) {
            this.leftTimer.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(duration, new KeyValue[0])});
        }

        private void hideCurrentTooltip() {
            this.currentTooltip.hide();
            this.currentTooltip = null;
            this.hoveredNode = null;
        }

        private void showTooltip(JFXTooltip jFXTooltip) {
            jFXTooltip.show(this.hoveredNode, -1.0, -1.0);
        }

        private void install(Node node, JFXTooltip jFXTooltip) {
            if (node == null) {
                return;
            }
            if (jFXTooltip == null) {
                this.uninstall(node);
                return;
            }
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.weakMoveHandler);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.weakExitHandler);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.weakPressedHandler);
            node.addEventHandler(MouseEvent.MOUSE_MOVED, this.weakMoveHandler);
            node.addEventHandler(MouseEvent.MOUSE_EXITED, this.weakExitHandler);
            node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.weakPressedHandler);
            node.getProperties().put((Object)TOOLTIP_PROP, (Object)jFXTooltip);
        }

        private void uninstall(Node node) {
            if (node == null) {
                return;
            }
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.weakMoveHandler);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.weakExitHandler);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.weakPressedHandler);
            Object object = node.getProperties().get((Object)TOOLTIP_PROP);
            if (object != null) {
                node.getProperties().remove((Object)TOOLTIP_PROP);
                if (object.equals((Object)this.currentTooltip) || object.equals((Object)this.nextTooltip)) {
                    this.weakPressedHandler.handle(null);
                }
            }
        }

        private void ensureHoveredNodeIsVisible(Runnable runnable) {
            boolean bl2;
            Window window = this.getWindow(this.hoveredNode);
            if (window != null && window.isShowing() && (bl2 = NodeHelper.isTreeVisible((Node)this.hoveredNode))) {
                runnable.run();
            }
        }

        private Window getWindow(Node node) {
            Scene scene = node == null ? null : node.getScene();
            return scene == null ? null : scene.getWindow();
        }
    }
}

