/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.converters.RipplerMaskTypeConverter;
import com.jfoenix.utils.JFXNodeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.Bounds;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

@DefaultProperty(value="control")
public class JFXRippler
extends StackPane {
    protected RippleGenerator rippler;
    protected Pane ripplerPane;
    protected Node control;
    protected static final double RIPPLE_MAX_RADIUS = 300.0;
    private boolean enabled = true;
    private boolean forceOverlay = false;
    private Interpolator rippleInterpolator = Interpolator.SPLINE((double)0.0825, (double)0.3025, (double)0.0875, (double)0.9975);
    private static final String DEFAULT_STYLE_CLASS = "jfx-rippler";
    private StyleableObjectProperty<Boolean> ripplerRecenter = new SimpleStyleableObjectProperty(StyleableProperties.access$900(), (Object)this, "ripplerRecenter", (Object)false);
    private StyleableObjectProperty<Number> ripplerRadius = new SimpleStyleableObjectProperty(StyleableProperties.access$1000(), (Object)this, "ripplerRadius", (Object)-1.0);
    private StyleableObjectProperty<Paint> ripplerFill = new SimpleStyleableObjectProperty(StyleableProperties.access$1100(), (Object)this, "ripplerFill", (Object)Color.rgb((int)0, (int)200, (int)255));
    private StyleableObjectProperty<RipplerMask> maskType = new SimpleStyleableObjectProperty(StyleableProperties.access$1200(), (Object)this, "maskType", (Object)RipplerMask.RECT);
    private StyleableBooleanProperty ripplerDisabled = new SimpleStyleableBooleanProperty(StyleableProperties.access$1300(), (Object)this, "ripplerDisabled", false);
    protected ObjectProperty<RipplerPos> position = new SimpleObjectProperty();

    public JFXRippler() {
        this(null, RipplerMask.RECT, RipplerPos.FRONT);
    }

    public JFXRippler(Node node) {
        this(node, RipplerMask.RECT, RipplerPos.FRONT);
    }

    public JFXRippler(Node node, RipplerPos ripplerPos) {
        this(node, RipplerMask.RECT, ripplerPos);
    }

    public JFXRippler(Node node, RipplerMask ripplerMask) {
        this(node, ripplerMask, RipplerPos.FRONT);
    }

    public JFXRippler(Node node, RipplerMask ripplerMask, RipplerPos ripplerPos) {
        this.initialize();
        this.setMaskType(ripplerMask);
        this.setPosition(ripplerPos);
        this.createRippleUI();
        this.setControl(node);
        this.position.addListener(observable -> this.updateControlPosition());
        this.setPickOnBounds(false);
        this.setCache(true);
        this.setCacheHint(CacheHint.SPEED);
        this.setCacheShape(true);
    }

    protected final void createRippleUI() {
        this.rippler = new RippleGenerator();
        this.ripplerPane = new StackPane();
        this.ripplerPane.setMouseTransparent(true);
        this.ripplerPane.getChildren().add((Object)this.rippler);
        this.getChildren().add((Object)this.ripplerPane);
    }

    public void setControl(Node node) {
        if (node != null) {
            this.control = node;
            this.positionControl(node);
            this.initControlListeners();
        }
    }

    protected void positionControl(Node node) {
        if (this.position.get() == RipplerPos.BACK) {
            this.getChildren().add((Object)node);
        } else {
            this.getChildren().add(0, (Object)node);
        }
    }

    protected void updateControlPosition() {
        if (this.position.get() == RipplerPos.BACK) {
            this.ripplerPane.toBack();
        } else {
            this.ripplerPane.toFront();
        }
    }

    public Node getControl() {
        return this.control;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    protected Node getMask() {
        Region region;
        double d2 = this.ripplerPane.getBorder() != null ? this.ripplerPane.getBorder().getInsets().getTop() : 0.0;
        Bounds bounds = this.control.getBoundsInParent();
        double d3 = this.control.getLayoutBounds().getWidth();
        double d4 = this.control.getLayoutBounds().getHeight();
        double d5 = Math.abs(this.control.getBoundsInLocal().getMinX() - this.control.getLayoutBounds().getMinX());
        double d6 = Math.abs(this.control.getBoundsInLocal().getMinY() - this.control.getLayoutBounds().getMinY());
        double d7 = Math.abs(this.control.getBoundsInLocal().getMaxX() - this.control.getLayoutBounds().getMaxX());
        double d8 = Math.abs(this.control.getBoundsInLocal().getMaxY() - this.control.getLayoutBounds().getMaxY());
        switch (this.getMaskType()) {
            case RECT: {
                region = new Rectangle(bounds.getMinX() + d5 - this.snappedLeftInset(), bounds.getMinY() + d6 - this.snappedTopInset(), d3 - 2.0 * d2, d4 - 2.0 * d2);
                break;
            }
            case CIRCLE: {
                double d9 = Math.min(d3 / 2.0 - 2.0 * d2, d4 / 2.0 - 2.0 * d2);
                region = new Circle((bounds.getMinX() + d5 + bounds.getMaxX() - d7) / 2.0 - this.snappedLeftInset(), (bounds.getMinY() + d6 + bounds.getMaxY() - d8) / 2.0 - this.snappedTopInset(), d9, (Paint)Color.BLUE);
                break;
            }
            case FIT: {
                region = new Region();
                if (this.control instanceof Shape) {
                    region.setShape((Shape)this.control);
                } else if (this.control instanceof Region) {
                    region.setShape(((Region)this.control).getShape());
                    JFXNodeUtils.updateBackground(((Region)this.control).getBackground(), region);
                }
                region.resize(d3, d4);
                region.relocate(bounds.getMinX() + d5, bounds.getMinY() + d6);
                break;
            }
            default: {
                region = new Rectangle(bounds.getMinX() + d5 - this.snappedLeftInset(), bounds.getMinY() + d6 - this.snappedTopInset(), d3 - 2.0 * d2, d4 - 2.0 * d2);
            }
        }
        return region;
    }

    protected double computeRippleRadius() {
        double d2 = this.control.getLayoutBounds().getWidth() * this.control.getLayoutBounds().getWidth();
        double d3 = this.control.getLayoutBounds().getHeight() * this.control.getLayoutBounds().getHeight();
        return Math.min(Math.sqrt(d2 + d3), 300.0) * 1.1 + 5.0;
    }

    protected void setOverLayBounds(Rectangle rectangle) {
        rectangle.setWidth(this.control.getLayoutBounds().getWidth());
        rectangle.setHeight(this.control.getLayoutBounds().getHeight());
    }

    protected void initControlListeners() {
        this.control.layoutBoundsProperty().addListener(observable -> this.resetRippler());
        if (this.getChildren().contains((Object)this.control)) {
            this.control.boundsInParentProperty().addListener(observable -> this.resetRippler());
        }
        this.control.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> this.createRipple(mouseEvent.getX(), mouseEvent.getY()));
        this.control.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> this.releaseRipple());
    }

    protected void createRipple(double d2, double d3) {
        if (!this.isRipplerDisabled().booleanValue()) {
            this.rippler.setGeneratorCenterX(d2);
            this.rippler.setGeneratorCenterY(d3);
            this.rippler.createRipple();
        }
    }

    protected void releaseRipple() {
        this.rippler.releaseRipple();
    }

    public Runnable createManualRipple() {
        if (!this.isRipplerDisabled().booleanValue()) {
            this.rippler.setGeneratorCenterX(this.control.getLayoutBounds().getWidth() / 2.0);
            this.rippler.setGeneratorCenterY(this.control.getLayoutBounds().getHeight() / 2.0);
            this.rippler.createRipple();
            return () -> this.releaseRipple();
        }
        return () -> {};
    }

    public void setOverlayVisible(boolean bl2, boolean bl3) {
        this.forceOverlay = bl3;
        this.setOverlayVisible(bl2);
    }

    public void setOverlayVisible(boolean bl2) {
        if (bl2) {
            this.showOverlay();
        } else {
            this.forceOverlay = !bl2 ? false : this.forceOverlay;
            this.hideOverlay();
        }
    }

    @Deprecated
    public void showOverlay() {
        if (this.rippler.overlayRect != null) {
            ((RippleGenerator)this.rippler).overlayRect.outAnimation.stop();
        }
        this.rippler.createOverlay();
        ((RippleGenerator)this.rippler).overlayRect.inAnimation.play();
    }

    @Deprecated
    public void hideOverlay() {
        if (!this.forceOverlay) {
            if (this.rippler.overlayRect != null) {
                ((RippleGenerator)this.rippler).overlayRect.inAnimation.stop();
            }
            if (this.rippler.overlayRect != null) {
                ((RippleGenerator)this.rippler).overlayRect.outAnimation.play();
            }
        } else {
            System.err.println("Ripple Overlay is forced!");
        }
    }

    private void resetOverLay() {
        if (this.rippler.overlayRect != null) {
            ((RippleGenerator)this.rippler).overlayRect.inAnimation.stop();
            RippleGenerator.OverLayRipple overLayRipple = this.rippler.overlayRect;
            ((RippleGenerator)this.rippler).overlayRect.outAnimation.setOnFinished(actionEvent -> this.rippler.getChildren().remove((Object)overLayRipple));
            ((RippleGenerator)this.rippler).overlayRect.outAnimation.play();
            this.rippler.overlayRect = null;
        }
    }

    private void resetClip() {
        this.rippler.resetClip = true;
    }

    protected void resetRippler() {
        this.resetOverLay();
        this.resetClip();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public Boolean isRipplerRecenter() {
        return this.ripplerRecenter == null ? false : (Boolean)this.ripplerRecenter.get();
    }

    public StyleableObjectProperty<Boolean> ripplerRecenterProperty() {
        return this.ripplerRecenter;
    }

    public void setRipplerRecenter(Boolean bl2) {
        this.ripplerRecenter.set((Object)bl2);
    }

    public Number getRipplerRadius() {
        return this.ripplerRadius == null ? (Number)-1.0 : (Number)((Number)this.ripplerRadius.get());
    }

    public StyleableObjectProperty<Number> ripplerRadiusProperty() {
        return this.ripplerRadius;
    }

    public void setRipplerRadius(Number number) {
        this.ripplerRadius.set((Object)number);
    }

    public Paint getRipplerFill() {
        return this.ripplerFill == null ? Color.rgb((int)0, (int)200, (int)255) : (Paint)this.ripplerFill.get();
    }

    public StyleableObjectProperty<Paint> ripplerFillProperty() {
        return this.ripplerFill;
    }

    public void setRipplerFill(Paint paint) {
        this.ripplerFill.set((Object)paint);
    }

    public RipplerMask getMaskType() {
        return this.maskType == null ? RipplerMask.RECT : (RipplerMask)((Object)this.maskType.get());
    }

    public StyleableObjectProperty<RipplerMask> maskTypeProperty() {
        return this.maskType;
    }

    public void setMaskType(RipplerMask ripplerMask) {
        this.maskType.set((Object)ripplerMask);
    }

    public Boolean isRipplerDisabled() {
        return this.ripplerDisabled == null ? false : this.ripplerDisabled.get();
    }

    public StyleableBooleanProperty ripplerDisabledProperty() {
        return this.ripplerDisabled;
    }

    public void setRipplerDisabled(Boolean bl2) {
        this.ripplerDisabled.set(bl2.booleanValue());
    }

    public void setPosition(RipplerPos ripplerPos) {
        this.position.set((Object)ripplerPos);
    }

    public RipplerPos getPosition() {
        return this.position == null ? RipplerPos.FRONT : (RipplerPos)((Object)this.position.get());
    }

    public ObjectProperty<RipplerPos> positionProperty() {
        return this.position;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXRippler.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static final class StyleableProperties {
        private static final CssMetaData<JFXRippler, Boolean> RIPPLER_RECENTER = new CssMetaData<JFXRippler, Boolean>("-jfx-rippler-recenter", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXRippler jFXRippler) {
                return jFXRippler.ripplerRecenter == null || !jFXRippler.ripplerRecenter.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(JFXRippler jFXRippler) {
                return jFXRippler.ripplerRecenterProperty();
            }
        };
        private static final CssMetaData<JFXRippler, Boolean> RIPPLER_DISABLED = new CssMetaData<JFXRippler, Boolean>("-jfx-rippler-disabled", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXRippler jFXRippler) {
                return jFXRippler.ripplerDisabled == null || !jFXRippler.ripplerDisabled.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(JFXRippler jFXRippler) {
                return jFXRippler.ripplerDisabledProperty();
            }
        };
        private static final CssMetaData<JFXRippler, Paint> RIPPLER_FILL = new CssMetaData<JFXRippler, Paint>("-jfx-rippler-fill", PaintConverter.getInstance(), (Paint)Color.rgb((int)0, (int)200, (int)255)){

            public boolean isSettable(JFXRippler jFXRippler) {
                return jFXRippler.ripplerFill == null || !jFXRippler.ripplerFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXRippler jFXRippler) {
                return jFXRippler.ripplerFillProperty();
            }
        };
        private static final CssMetaData<JFXRippler, Number> RIPPLER_RADIUS = new CssMetaData<JFXRippler, Number>("-jfx-rippler-radius", SizeConverter.getInstance(), (Number)-1.0){

            public boolean isSettable(JFXRippler jFXRippler) {
                return jFXRippler.ripplerRadius == null || !jFXRippler.ripplerRadius.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(JFXRippler jFXRippler) {
                return jFXRippler.ripplerRadiusProperty();
            }
        };
        private static final CssMetaData<JFXRippler, RipplerMask> MASK_TYPE = new CssMetaData<JFXRippler, RipplerMask>("-jfx-mask-type", RipplerMaskTypeConverter.getInstance(), RipplerMask.RECT){

            public boolean isSettable(JFXRippler jFXRippler) {
                return jFXRippler.maskType == null || !jFXRippler.maskType.isBound();
            }

            public StyleableProperty<RipplerMask> getStyleableProperty(JFXRippler jFXRippler) {
                return jFXRippler.maskTypeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$900() {
            return RIPPLER_RECENTER;
        }

        static /* synthetic */ CssMetaData access$1000() {
            return RIPPLER_RADIUS;
        }

        static /* synthetic */ CssMetaData access$1100() {
            return RIPPLER_FILL;
        }

        static /* synthetic */ CssMetaData access$1200() {
            return MASK_TYPE;
        }

        static /* synthetic */ CssMetaData access$1300() {
            return RIPPLER_DISABLED;
        }

        static {
            ArrayList arrayList = new ArrayList(StackPane.getClassCssMetaData());
            Collections.addAll(arrayList, RIPPLER_RECENTER, RIPPLER_RADIUS, RIPPLER_FILL, MASK_TYPE, RIPPLER_DISABLED);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    final class RippleGenerator
    extends Group {
        private double generatorCenterX = 0.0;
        private double generatorCenterY = 0.0;
        private OverLayRipple overlayRect;
        private AtomicBoolean generating = new AtomicBoolean(false);
        private boolean cacheRipplerClip = false;
        private boolean resetClip = false;
        private Queue<Ripple> ripplesQueue = new LinkedList<Ripple>();

        RippleGenerator() {
            this.setManaged(false);
            this.setCache(true);
            this.setCacheHint(CacheHint.SPEED);
        }

        void createRipple() {
            if (JFXRippler.this.enabled && !this.generating.getAndSet(true)) {
                this.createOverlay();
                if (this.getClip() == null || this.getChildren().size() == 1 && !this.cacheRipplerClip || this.resetClip) {
                    this.setClip(JFXRippler.this.getMask());
                }
                this.resetClip = false;
                Ripple ripple = new Ripple(this.generatorCenterX, this.generatorCenterY);
                this.getChildren().add((Object)ripple);
                this.ripplesQueue.add(ripple);
                this.overlayRect.outAnimation.stop();
                this.overlayRect.inAnimation.play();
                ripple.inAnimation.play();
            }
        }

        private void releaseRipple() {
            Ripple ripple = this.ripplesQueue.poll();
            if (ripple != null) {
                ripple.inAnimation.stop();
                ripple.outAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)Math.min(800.0, 450.0 / ripple.getScaleX())), ripple.outKeyValues)});
                ripple.outAnimation.setOnFinished(actionEvent -> this.getChildren().remove((Object)ripple));
                ripple.outAnimation.play();
                if (this.generating.getAndSet(false) && this.overlayRect != null) {
                    this.overlayRect.inAnimation.stop();
                    if (!JFXRippler.this.forceOverlay) {
                        this.overlayRect.outAnimation.play();
                    }
                }
            }
        }

        void cacheRippleClip(boolean bl2) {
            this.cacheRipplerClip = bl2;
        }

        void createOverlay() {
            if (this.overlayRect == null) {
                this.overlayRect = new OverLayRipple();
                this.overlayRect.setClip(JFXRippler.this.getMask());
                this.getChildren().add(0, (Object)this.overlayRect);
                this.overlayRect.fillProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
                    if (JFXRippler.this.ripplerFill.get() instanceof Color) {
                        return new Color(((Color)JFXRippler.this.ripplerFill.get()).getRed(), ((Color)JFXRippler.this.ripplerFill.get()).getGreen(), ((Color)JFXRippler.this.ripplerFill.get()).getBlue(), 0.2);
                    }
                    return Color.TRANSPARENT;
                }, (Observable[])new Observable[]{JFXRippler.this.ripplerFill}));
            }
        }

        void setGeneratorCenterX(double d2) {
            this.generatorCenterX = d2;
        }

        void setGeneratorCenterY(double d2) {
            this.generatorCenterY = d2;
        }

        public void clear() {
            this.getChildren().clear();
            JFXRippler.this.rippler.overlayRect = null;
            this.generating.set(false);
        }

        private final class Ripple
        extends Circle {
            KeyValue[] outKeyValues;
            Animation outAnimation;
            Animation inAnimation;

            private Ripple(double d2, double d3) {
                super(d2, d3, ((Number)JFXRippler.this.ripplerRadius.get()).doubleValue() == -1.0 ? JFXRippler.this.computeRippleRadius() : ((Number)JFXRippler.this.ripplerRadius.get()).doubleValue(), null);
                this.outAnimation = null;
                this.inAnimation = null;
                this.setCache(true);
                this.setCacheHint(CacheHint.SPEED);
                JFXRippler.this.setCacheShape(true);
                this.setManaged(false);
                this.setSmooth(true);
                KeyValue[] keyValueArray = new KeyValue[JFXRippler.this.isRipplerRecenter() != false ? 4 : 2];
                this.outKeyValues = new KeyValue[JFXRippler.this.isRipplerRecenter() != false ? 5 : 3];
                keyValueArray[0] = new KeyValue((WritableValue)this.scaleXProperty(), (Object)0.9, JFXRippler.this.rippleInterpolator);
                keyValueArray[1] = new KeyValue((WritableValue)this.scaleYProperty(), (Object)0.9, JFXRippler.this.rippleInterpolator);
                this.outKeyValues[0] = new KeyValue((WritableValue)this.scaleXProperty(), (Object)1, JFXRippler.this.rippleInterpolator);
                this.outKeyValues[1] = new KeyValue((WritableValue)this.scaleYProperty(), (Object)1, JFXRippler.this.rippleInterpolator);
                this.outKeyValues[2] = new KeyValue((WritableValue)this.opacityProperty(), (Object)0, JFXRippler.this.rippleInterpolator);
                if (JFXRippler.this.isRipplerRecenter().booleanValue()) {
                    double d4 = (JFXRippler.this.control.getLayoutBounds().getWidth() / 2.0 - d2) / 1.55;
                    double d5 = (JFXRippler.this.control.getLayoutBounds().getHeight() / 2.0 - d3) / 1.55;
                    keyValueArray[2] = this.outKeyValues[3] = new KeyValue((WritableValue)this.translateXProperty(), (Object)(Math.signum(d4) * Math.min(Math.abs(d4), this.getRadius() / 2.0)), JFXRippler.this.rippleInterpolator);
                    keyValueArray[3] = this.outKeyValues[4] = new KeyValue((WritableValue)this.translateYProperty(), (Object)(Math.signum(d5) * Math.min(Math.abs(d5), this.getRadius() / 2.0)), JFXRippler.this.rippleInterpolator);
                }
                this.inAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.scaleXProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.scaleYProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.translateXProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.translateYProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.opacityProperty(), (Object)1, JFXRippler.this.rippleInterpolator)}), new KeyFrame(Duration.millis((double)900.0), keyValueArray)});
                this.setScaleX(0.0);
                this.setScaleY(0.0);
                if (JFXRippler.this.ripplerFill.get() instanceof Color) {
                    Color color = new Color(((Color)JFXRippler.this.ripplerFill.get()).getRed(), ((Color)JFXRippler.this.ripplerFill.get()).getGreen(), ((Color)JFXRippler.this.ripplerFill.get()).getBlue(), 0.3);
                    this.setStroke((Paint)color);
                    this.setFill((Paint)color);
                } else {
                    this.setStroke((Paint)JFXRippler.this.ripplerFill.get());
                    this.setFill((Paint)JFXRippler.this.ripplerFill.get());
                }
            }
        }

        private final class OverLayRipple
        extends Rectangle {
            Animation inAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, Interpolator.EASE_IN)})});
            Animation outAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)0, Interpolator.EASE_OUT)})});

            OverLayRipple() {
                JFXRippler.this.setOverLayBounds(this);
                this.getStyleClass().add((Object)"jfx-rippler-overlay");
                if (JFXRippler.this.getChildrenUnmodifiable().contains((Object)JFXRippler.this.control)) {
                    double d2 = Math.abs(JFXRippler.this.control.getBoundsInLocal().getMinX() - JFXRippler.this.control.getLayoutBounds().getMinX());
                    double d3 = Math.abs(JFXRippler.this.control.getBoundsInLocal().getMinY() - JFXRippler.this.control.getLayoutBounds().getMinY());
                    Bounds bounds = JFXRippler.this.control.getBoundsInParent();
                    this.setX(bounds.getMinX() + d2 - JFXRippler.this.snappedLeftInset());
                    this.setY(bounds.getMinY() + d3 - JFXRippler.this.snappedTopInset());
                }
                this.setOpacity(0.0);
                this.setCache(true);
                this.setCacheHint(CacheHint.SPEED);
                JFXRippler.this.setCacheShape(true);
                this.setManaged(false);
            }
        }
    }

    public static enum RipplerMask {
        CIRCLE,
        RECT,
        FIT;

    }

    public static enum RipplerPos {
        FRONT,
        BACK;

    }
}

