/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.skins.JFXPopupSkin;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Window;

@DefaultProperty(value="popupContent")
public class JFXPopup
extends PopupControl {
    private ObjectProperty<Region> popupContent = new SimpleObjectProperty((Object)new Pane());
    private static final String DEFAULT_STYLE_CLASS = "jfx-popup";

    public JFXPopup() {
        this(null);
    }

    public JFXPopup(Region region) {
        this.setPopupContent(region);
        this.initialize();
    }

    private void initialize() {
        this.setAutoFix(false);
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        this.setConsumeAutoHidingEvents(false);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.getScene().getRoot().setStyle("-fx-background-color: TRANSPARENT");
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXPopupSkin(this);
    }

    public final ObjectProperty<Region> popupContentProperty() {
        return this.popupContent;
    }

    public final Region getPopupContent() {
        return (Region)this.popupContentProperty().get();
    }

    public final void setPopupContent(Region region) {
        this.popupContentProperty().set((Object)region);
    }

    public void show(Node node) {
        this.show(node, PopupVPosition.TOP, PopupHPosition.LEFT, 0.0, 0.0);
    }

    public void show(Node node, PopupVPosition popupVPosition, PopupHPosition popupHPosition) {
        this.show(node, popupVPosition, popupHPosition, 0.0, 0.0);
    }

    public void show(Node node, PopupVPosition popupVPosition, PopupHPosition popupHPosition, double d2, double d3) {
        if (!this.isShowing()) {
            if (node.getScene() == null || node.getScene().getWindow() == null) {
                throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
            }
            Window window = node.getScene().getWindow();
            Point2D point2D = node.localToScene(0.0, 0.0);
            double d4 = window.getX() + point2D.getX() + node.getScene().getX() + (popupHPosition == PopupHPosition.RIGHT ? ((Region)node).getWidth() : 0.0);
            double d5 = window.getY() + point2D.getY() + node.getScene().getY() + (popupVPosition == PopupVPosition.BOTTOM ? ((Region)node).getHeight() : 0.0);
            this.show(window, d4, d5);
            ((JFXPopupSkin)this.getSkin()).reset(popupVPosition, popupHPosition, d2, d3);
            Platform.runLater(() -> ((JFXPopupSkin)this.getSkin()).animate());
        }
    }

    public void show(Window window, double d2, double d3, PopupVPosition popupVPosition, PopupHPosition popupHPosition, double d4, double d5) {
        if (!this.isShowing()) {
            if (window == null) {
                throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
            }
            Window window2 = window;
            double d6 = window2.getX() + d2 + d4;
            double d7 = window2.getY() + d3 + d5;
            this.show(window2, d6, d7);
            ((JFXPopupSkin)this.getSkin()).reset(popupVPosition, popupHPosition, d4, d5);
            Platform.runLater(() -> ((JFXPopupSkin)this.getSkin()).animate());
        }
    }

    public void hide() {
        super.hide();
        ((JFXPopupSkin)this.getSkin()).init();
    }

    public static enum PopupVPosition {
        TOP,
        BOTTOM;

    }

    public static enum PopupHPosition {
        RIGHT,
        LEFT;

    }
}

