/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.cache.CachePolicy;
import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.utils.JFXNodeUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import javafx.util.Duration;

@DefaultProperty(value="content")
public class JFXDrawersStack
extends Region {
    private List<JFXDrawer> drawers = new ArrayList<JFXDrawer>();
    private Node content;
    private boolean performingLayout;

    public JFXDrawersStack() {
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)this.widthProperty());
        rectangle.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)rectangle);
    }

    public void requestLayout() {
        if (this.performingLayout) {
            return;
        }
        super.requestLayout();
    }

    protected void layoutChildren() {
        this.performingLayout = true;
        List list = this.getManagedChildren();
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = this.getInsets().getTop();
        double d5 = this.getInsets().getRight();
        double d6 = this.getInsets().getLeft();
        double d7 = this.getInsets().getBottom();
        double d8 = d2 - d6 - d5;
        double d9 = d3 - d4 - d7;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = (Node)list.get(i2);
            this.layoutInArea(node, d6, d4, d8, d9, 0.0, Insets.EMPTY, HPos.CENTER, VPos.CENTER);
        }
        this.performingLayout = false;
    }

    public Node getContent() {
        return this.content;
    }

    public void setContent(Node node) {
        this.content = node;
        if (this.drawers.size() > 0) {
            this.drawers.get(0).setContent(node);
        } else {
            this.getChildren().add((Object)this.content);
        }
    }

    public void addDrawer(JFXDrawer jFXDrawer) {
        if (jFXDrawer == null) {
            return;
        }
        if (jFXDrawer.getCachePolicy().equals(CachePolicy.IMAGE)) {
            throw new RuntimeException("Drawer is using unsupported cache strategy inside JFXDrawerStack");
        }
        if (this.drawers.isEmpty()) {
            if (this.content != null) {
                jFXDrawer.setContent(this.content);
            }
        } else {
            jFXDrawer.setContent((Node)this.drawers.get(this.drawers.size() - 1));
        }
        this.drawers.add(jFXDrawer);
        this.getChildren().setAll((Object[])new Node[]{jFXDrawer});
        jFXDrawer.setPickOnBounds(false);
        JFXNodeUtils.addPressAndHoldHandler((Node)jFXDrawer.sidePane, Duration.millis((double)300.0), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            if (this.drawers.indexOf((Object)jFXDrawer) < this.drawers.size() - 1) {
                jFXDrawer.bringToFront((Callback<Void, Void>)((Callback)void_ -> {
                    this.updateDrawerPosition(jFXDrawer);
                    return void_;
                }));
            }
        }));
    }

    private void updateDrawerPosition(JFXDrawer jFXDrawer) {
        int n2 = this.drawers.indexOf((Object)jFXDrawer);
        if (n2 + 1 < this.drawers.size()) {
            if (n2 - 1 >= 0) {
                this.drawers.get(n2 + 1).setContent((Node)this.drawers.get(n2 - 1));
            } else if (n2 == 0) {
                this.drawers.get(n2 + 1).setContent(this.content);
            }
            jFXDrawer.setContent((Node)this.drawers.get(this.drawers.size() - 1));
            this.drawers.remove((Object)jFXDrawer);
            this.drawers.add(jFXDrawer);
            this.getChildren().setAll((Object[])new Node[]{jFXDrawer});
        }
    }

    public void toggle(JFXDrawer jFXDrawer) {
        if (!this.drawers.contains((Object)jFXDrawer)) {
            this.addDrawer(jFXDrawer);
        }
        if (jFXDrawer.isOpened() || jFXDrawer.isOpening()) {
            jFXDrawer.close();
        } else {
            this.updateDrawerPosition(jFXDrawer);
            jFXDrawer.open();
        }
    }

    public void toggle(JFXDrawer jFXDrawer, boolean bl2) {
        if (!this.drawers.contains((Object)jFXDrawer)) {
            this.addDrawer(jFXDrawer);
        }
        if (!bl2) {
            if (jFXDrawer.isOpened() || jFXDrawer.isOpening()) {
                jFXDrawer.close();
            }
        } else if (!jFXDrawer.isOpened() && !jFXDrawer.isOpening()) {
            this.updateDrawerPosition(jFXDrawer);
            jFXDrawer.open();
        }
    }

    public List<Side> getOpenedDrawersOrder() {
        ArrayList<Side> arrayList = new ArrayList<Side>();
        int n2 = this.drawers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JFXDrawer jFXDrawer = this.drawers.get(i2);
            if (!jFXDrawer.isOpened()) continue;
            arrayList.add(Side.valueOf((String)jFXDrawer.getDirection().toString()));
        }
        return arrayList;
    }
}

