/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthParametersMissingException;
import com.github.scribejava.core.extractors.HeaderExtractor;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.util.Map;

public class HeaderExtractorImpl
implements HeaderExtractor {
    private static final String PARAM_SEPARATOR = ", ";
    private static final String PREAMBLE = "OAuth ";

    @Override
    public String extract(OAuthRequest oAuthRequest) {
        this.checkPreconditions(oAuthRequest);
        Map<String, String> map = oAuthRequest.getOauthParameters();
        StringBuilder stringBuilder = new StringBuilder(PREAMBLE);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() > PREAMBLE.length()) {
                stringBuilder.append(PARAM_SEPARATOR);
            }
            stringBuilder.append(entry.getKey()).append("=\"").append(OAuthEncoder.encode(entry.getValue())).append('\"');
        }
        if (oAuthRequest.getRealm() != null && !oAuthRequest.getRealm().isEmpty()) {
            stringBuilder.append(PARAM_SEPARATOR).append("realm").append("=\"").append(oAuthRequest.getRealm()).append('\"');
        }
        return stringBuilder.toString();
    }

    private void checkPreconditions(OAuthRequest oAuthRequest) {
        Preconditions.checkNotNull(oAuthRequest, "Cannot extract a header from a null object");
        if (oAuthRequest.getOauthParameters() == null || oAuthRequest.getOauthParameters().size() <= 0) {
            throw new OAuthParametersMissingException(oAuthRequest);
        }
    }
}

