/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthParametersMissingException;
import com.github.scribejava.core.extractors.BaseStringExtractor;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;

public class BaseStringExtractorImpl
implements BaseStringExtractor {
    protected static final String AMPERSAND_SEPARATED_STRING = "%s&%s&%s";

    @Override
    public String extract(OAuthRequest oAuthRequest) {
        this.checkPreconditions(oAuthRequest);
        String string = OAuthEncoder.encode(this.getVerb(oAuthRequest));
        String string2 = OAuthEncoder.encode(this.getUrl(oAuthRequest));
        String string3 = this.getSortedAndEncodedParams(oAuthRequest);
        return String.format(AMPERSAND_SEPARATED_STRING, string, string2, string3);
    }

    protected String getVerb(OAuthRequest oAuthRequest) {
        return oAuthRequest.getVerb().name();
    }

    protected String getUrl(OAuthRequest oAuthRequest) {
        return oAuthRequest.getSanitizedUrl();
    }

    protected String getSortedAndEncodedParams(OAuthRequest oAuthRequest) {
        ParameterList parameterList = new ParameterList();
        parameterList.addAll(oAuthRequest.getQueryStringParams());
        parameterList.addAll(oAuthRequest.getBodyParams());
        parameterList.addAll(new ParameterList(oAuthRequest.getOauthParameters()));
        return parameterList.sort().asOauthBaseString();
    }

    protected void checkPreconditions(OAuthRequest oAuthRequest) {
        Preconditions.checkNotNull(oAuthRequest, "Cannot extract base string from a null object");
        if (oAuthRequest.getOauthParameters() == null || oAuthRequest.getOauthParameters().size() <= 0) {
            throw new OAuthParametersMissingException(oAuthRequest);
        }
    }
}

