/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder.api;

import com.github.scribejava.core.java8.Base64;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import java.nio.charset.Charset;

public enum ClientAuthenticationType {
    HTTP_BASIC_AUTHENTICATION_SCHEME{
        private final Base64.Encoder base64Encoder = Base64.getEncoder();

        @Override
        public void addClientAuthentication(OAuthRequest oAuthRequest, OAuthConfig oAuthConfig) {
            String string = oAuthConfig.getApiKey();
            String string2 = oAuthConfig.getApiSecret();
            if (string != null && string2 != null) {
                oAuthRequest.addHeader("Authorization", "Basic " + this.base64Encoder.encodeToString(String.format("%s:%s", string, string2).getBytes(Charset.forName("UTF-8"))));
            }
        }
    }
    ,
    REQUEST_BODY{

        @Override
        public void addClientAuthentication(OAuthRequest oAuthRequest, OAuthConfig oAuthConfig) {
            oAuthRequest.addParameter("client_id", oAuthConfig.getApiKey());
            String string = oAuthConfig.getApiSecret();
            if (string != null) {
                oAuthRequest.addParameter("client_secret", string);
            }
        }
    };


    public abstract void addClientAuthentication(OAuthRequest var1, OAuthConfig var2);
}

