/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.service;

import com.github.scribejava.apis.ImgurApi;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.OAuth20Service;

public class ImgurOAuthService
extends OAuth20Service {
    public ImgurOAuthService(DefaultApi20 defaultApi20, OAuthConfig oAuthConfig) {
        super(defaultApi20, oAuthConfig);
    }

    @Override
    protected OAuthRequest createAccessTokenRequest(String string) {
        DefaultApi20 defaultApi20 = this.getApi();
        OAuthRequest oAuthRequest = new OAuthRequest(defaultApi20.getAccessTokenVerb(), defaultApi20.getAccessTokenEndpoint());
        OAuthConfig oAuthConfig = this.getConfig();
        oAuthRequest.addBodyParameter("client_id", oAuthConfig.getApiKey());
        oAuthRequest.addBodyParameter("client_secret", oAuthConfig.getApiSecret());
        if (ImgurApi.isOob(oAuthConfig)) {
            oAuthRequest.addBodyParameter("grant_type", "pin");
            oAuthRequest.addBodyParameter("pin", string);
        } else {
            oAuthRequest.addBodyParameter("grant_type", "authorization_code");
            oAuthRequest.addBodyParameter("code", string);
        }
        return oAuthRequest;
    }

    @Override
    public void signRequest(String string, OAuthRequest oAuthRequest) {
        oAuthRequest.addHeader("Authorization", string == null ? "Client-ID " + this.getConfig().getApiKey() : "Bearer " + string);
    }
}

