/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;

public class LinkedInApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "https://api.linkedin.com/uas/oauth/authenticate";
    private static final String REQUEST_TOKEN_URL = "https://api.linkedin.com/uas/oauth/requestToken";
    private final String scopesAsString;

    protected LinkedInApi() {
        this.scopesAsString = null;
    }

    protected LinkedInApi(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append('+').append(string);
        }
        this.scopesAsString = "?scope=" + stringBuilder.substring(1);
    }

    public static LinkedInApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static LinkedInApi instance(String ... stringArray) {
        return stringArray == null || stringArray.length == 0 ? LinkedInApi.instance() : new LinkedInApi(stringArray);
    }

    @Override
    public String getAccessTokenEndpoint() {
        return "https://api.linkedin.com/uas/oauth/accessToken";
    }

    @Override
    public String getRequestTokenEndpoint() {
        return this.scopesAsString == null ? REQUEST_TOKEN_URL : REQUEST_TOKEN_URL + this.scopesAsString;
    }

    @Override
    public String getAuthorizationBaseUrl() {
        return AUTHORIZE_URL;
    }

    private static class InstanceHolder {
        private static final LinkedInApi INSTANCE = new LinkedInApi();

        private InstanceHolder() {
        }
    }
}

