/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;

public class EtsyApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "https://www.etsy.com/oauth/signin";
    private static final String ACCESS_TOKEN_URL = "https://openapi.etsy.com/v2/oauth/access_token";
    private static final String REQUEST_TOKEN_URL = "https://openapi.etsy.com/v2/oauth/request_token";
    private final String scopeAsString;

    private EtsyApi() {
        this.scopeAsString = null;
    }

    private EtsyApi(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append("%20").append(string);
        }
        this.scopeAsString = "?scope=" + stringBuilder.substring(3);
    }

    public static EtsyApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static EtsyApi instance(String ... stringArray) {
        return stringArray == null || stringArray.length == 0 ? EtsyApi.instance() : new EtsyApi(stringArray);
    }

    @Override
    public String getAccessTokenEndpoint() {
        return ACCESS_TOKEN_URL;
    }

    @Override
    public String getRequestTokenEndpoint() {
        return this.scopeAsString == null ? REQUEST_TOKEN_URL : REQUEST_TOKEN_URL + this.scopeAsString;
    }

    @Override
    public String getAuthorizationBaseUrl() {
        return AUTHORIZE_URL;
    }

    private static class InstanceHolder {
        private static final EtsyApi INSTANCE = new EtsyApi();

        private InstanceHolder() {
        }
    }
}

