/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.dataformat.yaml.JacksonYAMLParseException;
import com.fasterxml.jackson.dataformat.yaml.PackageVersion;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.MarkedYAMLException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CollectionStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.resolver.Resolver;

public class YAMLParser
extends ParserBase {
    protected ObjectCodec _objectCodec;
    protected int _formatFeatures;
    protected boolean _cfgEmptyStringsToNull;
    protected final Reader _reader;
    protected final ParserImpl _yamlParser;
    protected final Resolver _yamlResolver = new Resolver();
    protected Event _lastEvent;
    protected Event _lastTagEvent;
    protected String _textValue;
    protected String _cleanedTextValue;
    protected String _currentFieldName;
    protected boolean _currentIsAlias;
    protected String _currentAnchor;

    @Deprecated
    public YAMLParser(IOContext iOContext, BufferRecycler bufferRecycler, int n2, int n3, ObjectCodec objectCodec, Reader reader) {
        this(iOContext, n2, n3, null, objectCodec, reader);
    }

    public YAMLParser(IOContext iOContext, int n2, int n3, LoaderOptions loaderOptions, ObjectCodec objectCodec, Reader reader) {
        super(iOContext, n2);
        this._objectCodec = objectCodec;
        this._formatFeatures = n3;
        this._reader = reader;
        if (loaderOptions == null) {
            loaderOptions = new LoaderOptions();
        }
        this._yamlParser = new ParserImpl(new StreamReader(reader), loaderOptions);
        this._cfgEmptyStringsToNull = Feature.EMPTY_STRING_AS_NULL.enabledIn(n3);
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public boolean isCurrentAlias() {
        return this._currentIsAlias;
    }

    @Deprecated
    public String getCurrentAnchor() {
        return this._currentAnchor;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean requiresCustomCodec() {
        return false;
    }

    @Override
    public boolean canReadObjectId() {
        return true;
    }

    @Override
    public boolean canReadTypeId() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
            this._reader.close();
        }
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonParser overrideFormatFeatures(int n2, int n3) {
        this._formatFeatures = this._formatFeatures & ~n3 | n2 & n3;
        this._cfgEmptyStringsToNull = Feature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
        return this;
    }

    public JsonParser enable(Feature feature) {
        this._formatFeatures |= feature.getMask();
        this._cfgEmptyStringsToNull = Feature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
        return this;
    }

    public JsonParser disable(Feature feature) {
        this._formatFeatures &= ~feature.getMask();
        this._cfgEmptyStringsToNull = Feature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
        return this;
    }

    public JsonParser configure(Feature feature, boolean bl2) {
        if (bl2) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public boolean isEnabled(Feature feature) {
        return (this._formatFeatures & feature.getMask()) != 0;
    }

    @Override
    public JsonLocation getTokenLocation() {
        if (this._lastEvent == null) {
            return JsonLocation.NA;
        }
        return this._locationFor(this._lastEvent.getStartMark());
    }

    @Override
    public JsonLocation getCurrentLocation() {
        if (this._lastEvent == null) {
            return JsonLocation.NA;
        }
        return this._locationFor(this._lastEvent.getEndMark());
    }

    protected JsonLocation _locationFor(Mark mark) {
        if (mark == null) {
            return new JsonLocation(this._ioContext.contentReference(), -1L, -1, -1);
        }
        return new JsonLocation(this._ioContext.contentReference(), (long)mark.getIndex(), mark.getLine() + 1, mark.getColumn() + 1);
    }

    @Override
    public JsonToken nextToken() throws IOException {
        this._currentIsAlias = false;
        this._binaryValue = null;
        if (this._closed) {
            return null;
        }
        while (true) {
            Event event;
            try {
                event = this._yamlParser.getEvent();
            }
            catch (YAMLException yAMLException) {
                if (yAMLException instanceof org.yaml.snakeyaml.error.MarkedYAMLException) {
                    throw MarkedYAMLException.from((JsonParser)this, (org.yaml.snakeyaml.error.MarkedYAMLException)yAMLException);
                }
                throw new JacksonYAMLParseException((JsonParser)this, yAMLException.getMessage(), yAMLException);
            }
            if (event == null) {
                this._currentAnchor = null;
                this._lastTagEvent = null;
                this._currToken = null;
                return null;
            }
            this._lastEvent = event;
            if (this._parsingContext.inObject()) {
                if (this._currToken != JsonToken.FIELD_NAME) {
                    String string;
                    boolean bl2;
                    if (!event.is(Event.ID.Scalar)) {
                        this._currentAnchor = null;
                        this._lastTagEvent = null;
                        if (event.is(Event.ID.MappingEnd)) {
                            if (!this._parsingContext.inObject()) {
                                this._reportMismatchedEndMarker(125, ']');
                            }
                            this._parsingContext = this._parsingContext.getParent();
                            this._currToken = JsonToken.END_OBJECT;
                            return this._currToken;
                        }
                        this._reportError("Expected a field name (Scalar value in YAML), got this instead: " + event);
                    }
                    ScalarEvent scalarEvent = (ScalarEvent)event;
                    String string2 = scalarEvent.getAnchor();
                    boolean bl3 = bl2 = this._currToken == JsonToken.START_OBJECT;
                    if (string2 != null || !bl2) {
                        this._currentAnchor = scalarEvent.getAnchor();
                    }
                    if (!bl2) {
                        this._lastTagEvent = event;
                    }
                    this._currentFieldName = string = scalarEvent.getValue();
                    this._parsingContext.setCurrentName(string);
                    this._currToken = JsonToken.FIELD_NAME;
                    return this._currToken;
                }
            } else if (this._parsingContext.inArray()) {
                this._parsingContext.expectComma();
            }
            this._currentAnchor = null;
            this._lastTagEvent = event;
            if (event.is(Event.ID.Scalar)) {
                JsonToken jsonToken;
                this._currToken = jsonToken = this._decodeScalar((ScalarEvent)event);
                return jsonToken;
            }
            if (event.is(Event.ID.MappingStart)) {
                Mark mark = event.getStartMark();
                MappingStartEvent mappingStartEvent = (MappingStartEvent)event;
                this._currentAnchor = mappingStartEvent.getAnchor();
                this._parsingContext = this._parsingContext.createChildObjectContext(mark.getLine(), mark.getColumn());
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            if (event.is(Event.ID.MappingEnd)) {
                this._reportError("Not expecting END_OBJECT but a value");
            }
            if (event.is(Event.ID.SequenceStart)) {
                Mark mark = event.getStartMark();
                this._currentAnchor = ((NodeEvent)event).getAnchor();
                this._parsingContext = this._parsingContext.createChildArrayContext(mark.getLine(), mark.getColumn());
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            if (event.is(Event.ID.SequenceEnd)) {
                if (!this._parsingContext.inArray()) {
                    this._reportMismatchedEndMarker(93, '}');
                }
                this._parsingContext = this._parsingContext.getParent();
                this._currToken = JsonToken.END_ARRAY;
                return this._currToken;
            }
            if (event.is(Event.ID.DocumentEnd) || event.is(Event.ID.DocumentStart)) continue;
            if (event.is(Event.ID.Alias)) {
                AliasEvent aliasEvent = (AliasEvent)event;
                this._currentIsAlias = true;
                this._textValue = aliasEvent.getAnchor();
                this._cleanedTextValue = null;
                this._currToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            if (event.is(Event.ID.StreamEnd)) {
                this.close();
                this._currToken = null;
                return null;
            }
            if (!event.is(Event.ID.StreamStart)) continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JsonToken _decodeScalar(ScalarEvent scalarEvent) throws IOException {
        Object object;
        String string;
        this._textValue = string = scalarEvent.getValue();
        this._cleanedTextValue = null;
        if (!this._cfgEmptyStringsToNull && string.isEmpty()) {
            return JsonToken.VALUE_STRING;
        }
        String string2 = scalarEvent.getTag();
        int n2 = string.length();
        if (string2 == null || string2.equals("!")) {
            Tag tag = this._yamlResolver.resolve(NodeId.scalar, string, scalarEvent.getImplicit().canOmitTagInPlainScalar());
            if (tag == Tag.STR) {
                return JsonToken.VALUE_STRING;
            }
            if (tag == Tag.INT) {
                return this._decodeNumberScalar(string, n2);
            }
            if (tag == Tag.FLOAT) {
                this._numTypesValid = 0;
                return this._cleanYamlFloat(string);
            }
            if (tag == Tag.BOOL) {
                Boolean bl2 = this._matchYAMLBoolean(string, n2);
                if (bl2 == null) return JsonToken.VALUE_STRING;
                return bl2 != false ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }
            if (tag != Tag.NULL) return JsonToken.VALUE_STRING;
            return JsonToken.VALUE_NULL;
        }
        if (string2.startsWith("tag:yaml.org,2002:") && (string2 = string2.substring("tag:yaml.org,2002:".length())).contains(",")) {
            object = string2.split(",");
            String string3 = string2 = ((String[])object).length == 0 ? "" : object[0];
        }
        if ("binary".equals(string2)) {
            string = string.trim();
            try {
                this._binaryValue = Base64Variants.MIME.decode(string);
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._reportError(illegalArgumentException.getMessage());
            }
            return JsonToken.VALUE_EMBEDDED_OBJECT;
        }
        if ("bool".equals(string2)) {
            object = this._matchYAMLBoolean(string, n2);
            if (object == null) return JsonToken.VALUE_STRING;
            return ((Boolean)object).booleanValue() ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
        }
        if (n2 <= 0) return JsonToken.VALUE_STRING;
        if ("int".equals(string2)) {
            return this._decodeNumberScalar(string, n2);
        }
        if ("float".equals(string2)) {
            this._numTypesValid = 0;
            return this._cleanYamlFloat(string);
        }
        if (!"null".equals(string2)) return JsonToken.VALUE_STRING;
        return JsonToken.VALUE_NULL;
    }

    protected Boolean _matchYAMLBoolean(String string, int n2) {
        switch (n2) {
            case 1: {
                switch (string.charAt(0)) {
                    case 'Y': 
                    case 'y': {
                        return Boolean.TRUE;
                    }
                    case 'N': 
                    case 'n': {
                        return Boolean.FALSE;
                    }
                }
                break;
            }
            case 2: {
                if ("no".equalsIgnoreCase(string)) {
                    return Boolean.FALSE;
                }
                if (!"on".equalsIgnoreCase(string)) break;
                return Boolean.TRUE;
            }
            case 3: {
                if ("yes".equalsIgnoreCase(string)) {
                    return Boolean.TRUE;
                }
                if (!"off".equalsIgnoreCase(string)) break;
                return Boolean.FALSE;
            }
            case 4: {
                if (!"true".equalsIgnoreCase(string)) break;
                return Boolean.TRUE;
            }
            case 5: {
                if (!"false".equalsIgnoreCase(string)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected JsonToken _decodeNumberScalar(String string, int n2) throws IOException {
        block15: {
            int n3;
            char c2 = string.charAt(0);
            if (c2 == '-') {
                this._numberNegative = true;
                n3 = 1;
            } else if (c2 == '+') {
                this._numberNegative = false;
                if (n2 == 1) {
                    return null;
                }
                n3 = 1;
            } else {
                this._numberNegative = false;
                n3 = 0;
            }
            if (n2 == n3) {
                return null;
            }
            if (string.charAt(n3) == '0') {
                if (++n3 == n2) {
                    this._numberInt = 0;
                    this._numTypesValid = 1;
                    return JsonToken.VALUE_NUMBER_INT;
                }
                c2 = string.charAt(n3);
                switch (c2) {
                    case 'B': 
                    case 'b': {
                        return this._decodeNumberIntBinary(string, n3 + 1, n2, this._numberNegative);
                    }
                    case 'X': 
                    case 'x': {
                        return this._decodeNumberIntHex(string, n3 + 1, n2, this._numberNegative);
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case '_': {
                        return this._decodeNumberIntOctal(string, n3, n2, this._numberNegative);
                    }
                }
                return JsonToken.VALUE_STRING;
            }
            boolean bl2 = false;
            do {
                char c3;
                if ((c3 = string.charAt(n3)) <= '9' && c3 >= '0') continue;
                if (c3 != '_') break block15;
                bl2 = true;
            } while (++n3 != n2);
            this._numTypesValid = 0;
            if (bl2) {
                return this._cleanYamlInt(string);
            }
            this._cleanedTextValue = this._textValue;
            return JsonToken.VALUE_NUMBER_INT;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _decodeNumberIntBinary(String string, int n2, int n3, boolean bl2) throws IOException {
        String string2 = this._cleanUnderscores(string, n2, n3);
        int n4 = string2.length();
        if (n4 <= 31) {
            int n5 = this._decodeInt(string2, 2);
            if (bl2) {
                n5 = -n5;
            }
            this._numberInt = n5;
            this._numTypesValid = 1;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (n4 <= 63) {
            return this._decodeFromLong(this._decodeLong(string2, 2), bl2, n4 == 32);
        }
        return this._decodeFromBigInteger(this._decodeBigInt(string2, 2), bl2);
    }

    protected JsonToken _decodeNumberIntOctal(String string, int n2, int n3, boolean bl2) throws IOException {
        String string2 = this._cleanUnderscores(string, n2, n3);
        int n4 = string2.length();
        if (n4 <= 10) {
            int n5 = this._decodeInt(string2, 8);
            if (bl2) {
                n5 = -n5;
            }
            this._numberInt = n5;
            this._numTypesValid = 1;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (n4 <= 21) {
            return this._decodeFromLong(this._decodeLong(string2, 8), bl2, false);
        }
        return this._decodeFromBigInteger(this._decodeBigInt(string2, 8), bl2);
    }

    protected JsonToken _decodeNumberIntHex(String string, int n2, int n3, boolean bl2) throws IOException {
        String string2 = this._cleanUnderscores(string, n2, n3);
        int n4 = string2.length();
        if (n4 <= 7) {
            int n5 = this._decodeInt(string2, 16);
            if (bl2) {
                n5 = -n5;
            }
            this._numberInt = n5;
            this._numTypesValid = 1;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (n4 <= 15) {
            return this._decodeFromLong(this._decodeLong(string2, 16), bl2, n4 == 8);
        }
        return this._decodeFromBigInteger(this._decodeBigInt(string2, 16), bl2);
    }

    private JsonToken _decodeFromLong(long l2, boolean bl2, boolean bl3) {
        long l3;
        if (bl2) {
            l3 = -l2;
            if (bl3 && l3 >= Integer.MIN_VALUE) {
                this._numberInt = (int)l3;
                this._numTypesValid = 1;
                return JsonToken.VALUE_NUMBER_INT;
            }
        } else {
            if (bl3 && l2 < Integer.MAX_VALUE) {
                this._numberInt = (int)l2;
                this._numTypesValid = 1;
                return JsonToken.VALUE_NUMBER_INT;
            }
            l3 = l2;
        }
        this._numberLong = l3;
        this._numTypesValid = 2;
        return JsonToken.VALUE_NUMBER_INT;
    }

    private JsonToken _decodeFromBigInteger(BigInteger bigInteger, boolean bl2) {
        this._numberBigInt = bl2 ? bigInteger.negate() : bigInteger;
        this._numTypesValid = 4;
        return JsonToken.VALUE_NUMBER_INT;
    }

    private int _decodeInt(String string, int n2) throws IOException {
        try {
            return Integer.parseInt(string, n2);
        }
        catch (NumberFormatException numberFormatException) {
            return (Integer)this._reportInvalidNumber(string, n2, numberFormatException);
        }
    }

    private long _decodeLong(String string, int n2) throws IOException {
        try {
            return Long.parseLong(string, n2);
        }
        catch (NumberFormatException numberFormatException) {
            return (Long)this._reportInvalidNumber(string, n2, numberFormatException);
        }
    }

    private BigInteger _decodeBigInt(String string, int n2) throws IOException {
        try {
            return n2 == 10 ? NumberInput.parseBigInteger(string) : new BigInteger(string, n2);
        }
        catch (NumberFormatException numberFormatException) {
            return (BigInteger)this._reportInvalidNumber(string, n2, numberFormatException);
        }
    }

    private <T> T _reportInvalidNumber(String string, int n2, Exception exception) throws IOException {
        this._reportError(String.format("Invalid base-%d number ('%s'), problem: %s", n2, string, exception.getMessage()));
        return null;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textValue;
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentFieldName;
        }
        if (this._currToken != null) {
            if (this._currToken.isScalarValue()) {
                return this._textValue;
            }
            return this._currToken.asString();
        }
        return null;
    }

    @Override
    public String getCurrentName() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentFieldName;
        }
        return super.getCurrentName();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        String string = this.getText();
        return string == null ? null : string.toCharArray();
    }

    @Override
    public int getTextLength() throws IOException {
        String string = this.getText();
        return string == null ? 0 : string.length();
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public int getText(Writer writer) throws IOException {
        String string = this.getText();
        if (string == null) {
            return 0;
        }
        writer.write(string);
        return string.length();
    }

    @Override
    public Object getEmbeddedObject() throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException {
        byte[] byArray = this.getBinaryValue(base64Variant);
        outputStream.write(byArray);
        return byArray.length;
    }

    @Override
    protected void _parseNumericValue(int n2) throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            int n3 = this._cleanedTextValue.length();
            if (this._numberNegative) {
                --n3;
            }
            if (n3 <= 9) {
                this._numberInt = Integer.parseInt(this._cleanedTextValue);
                this._numTypesValid = 1;
                return;
            }
            if (n3 <= 18) {
                long l2 = Long.parseLong(this._cleanedTextValue);
                if (n3 == 10) {
                    if (this._numberNegative) {
                        if (l2 >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l2;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l2 <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l2;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l2;
                this._numTypesValid = 2;
                return;
            }
            try {
                BigInteger bigInteger = NumberInput.parseBigInteger(this._cleanedTextValue);
                if (n3 == 19 && bigInteger.bitLength() <= 63) {
                    this._numberLong = bigInteger.longValue();
                    this._numTypesValid = 2;
                    return;
                }
                this._numberBigInt = bigInteger;
                this._numTypesValid = 4;
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this._wrapError("Malformed numeric value '" + this._textValue + "'", numberFormatException);
            }
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            String string = this._cleanedTextValue;
            try {
                if (n2 == 16) {
                    this._numberBigDecimal = NumberInput.parseBigDecimal(string);
                    this._numTypesValid = 16;
                } else {
                    this._numberDouble = NumberInput.parseDouble(string, this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
                    this._numTypesValid = 8;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this._wrapError("Malformed numeric value '" + this._textValue + "'", numberFormatException);
            }
            return;
        }
        this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, can not use numeric value accessors");
    }

    @Override
    protected int _parseIntValue() throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            int n2 = this._cleanedTextValue.length();
            if (this._numberNegative) {
                --n2;
            }
            if (n2 <= 9) {
                this._numTypesValid = 1;
                this._numberInt = Integer.parseInt(this._cleanedTextValue);
                return this._numberInt;
            }
        }
        this._parseNumericValue(1);
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    @Override
    public String getObjectId() throws IOException {
        return this._currentAnchor;
    }

    @Override
    public String getTypeId() throws IOException {
        String string;
        if (this._lastTagEvent instanceof CollectionStartEvent) {
            string = ((CollectionStartEvent)this._lastTagEvent).getTag();
        } else if (this._lastTagEvent instanceof ScalarEvent) {
            string = ((ScalarEvent)this._lastTagEvent).getTag();
        } else {
            return null;
        }
        if (string != null) {
            while (string.startsWith("!")) {
                string = string.substring(1);
            }
            return string;
        }
        return null;
    }

    private JsonToken _cleanYamlInt(String string) {
        int n2;
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = n2 = string.charAt(0) == '+' ? 1 : 0;
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 != '_') {
                stringBuilder.append(c2);
            }
            ++n2;
        }
        this._cleanedTextValue = stringBuilder.toString();
        return JsonToken.VALUE_NUMBER_INT;
    }

    private String _cleanUnderscores(String string, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(n3);
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 != '_') {
                stringBuilder.append(c2);
            }
            ++n2;
        }
        if (stringBuilder.length() == n3) {
            return string;
        }
        return stringBuilder.toString();
    }

    private JsonToken _cleanYamlFloat(String string) {
        int n2;
        int n3 = string.length();
        int n4 = string.indexOf(95);
        if (n4 < 0 || n3 == 0) {
            this._cleanedTextValue = string;
            return JsonToken.VALUE_NUMBER_FLOAT;
        }
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n5 = n2 = string.charAt(0) == '+' ? 1 : 0;
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 != '_') {
                stringBuilder.append(c2);
            }
            ++n2;
        }
        this._cleanedTextValue = stringBuilder.toString();
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    public static enum Feature implements FormatFeature
    {
        EMPTY_STRING_AS_NULL(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public boolean enabledIn(int n2) {
            return (n2 & this._mask) != 0;
        }

        @Override
        public int getMask() {
            return this._mask;
        }
    }
}

