/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;

public class YAMLMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public YAMLMapper() {
        this(new YAMLFactory());
    }

    public YAMLMapper(YAMLFactory yAMLFactory) {
        super(yAMLFactory);
    }

    public YAMLMapper(YAMLMapper yAMLMapper) {
        super(yAMLMapper);
    }

    public static Builder builder() {
        return new Builder(new YAMLMapper());
    }

    public static Builder builder(YAMLFactory yAMLFactory) {
        return new Builder(new YAMLMapper(yAMLFactory));
    }

    @Override
    public YAMLMapper copy() {
        this._checkInvalidCopy(YAMLMapper.class);
        return new YAMLMapper(this);
    }

    public YAMLMapper configure(YAMLGenerator.Feature feature, boolean bl2) {
        return bl2 ? this.enable(feature) : this.disable(feature);
    }

    public YAMLMapper configure(YAMLParser.Feature feature, boolean bl2) {
        return bl2 ? this.enable(feature) : this.disable(feature);
    }

    public YAMLMapper enable(YAMLGenerator.Feature feature) {
        ((YAMLFactory)this._jsonFactory).enable(feature);
        return this;
    }

    public YAMLMapper enable(YAMLParser.Feature feature) {
        ((YAMLFactory)this._jsonFactory).enable(feature);
        return this;
    }

    public YAMLMapper disable(YAMLGenerator.Feature feature) {
        ((YAMLFactory)this._jsonFactory).disable(feature);
        return this;
    }

    public YAMLMapper disable(YAMLParser.Feature feature) {
        ((YAMLFactory)this._jsonFactory).disable(feature);
        return this;
    }

    @Override
    public final YAMLFactory getFactory() {
        return (YAMLFactory)this._jsonFactory;
    }

    public static class Builder
    extends MapperBuilder<YAMLMapper, Builder> {
        public Builder(YAMLMapper yAMLMapper) {
            super(yAMLMapper);
        }

        public Builder enable(YAMLParser.Feature ... featureArray) {
            for (YAMLParser.Feature feature : featureArray) {
                ((YAMLMapper)this._mapper).enable(feature);
            }
            return this;
        }

        public Builder disable(YAMLParser.Feature ... featureArray) {
            for (YAMLParser.Feature feature : featureArray) {
                ((YAMLMapper)this._mapper).disable(feature);
            }
            return this;
        }

        public Builder configure(YAMLParser.Feature feature, boolean bl2) {
            if (bl2) {
                ((YAMLMapper)this._mapper).enable(feature);
            } else {
                ((YAMLMapper)this._mapper).disable(feature);
            }
            return this;
        }

        public Builder enable(YAMLGenerator.Feature ... featureArray) {
            for (YAMLGenerator.Feature feature : featureArray) {
                ((YAMLMapper)this._mapper).enable(feature);
            }
            return this;
        }

        public Builder disable(YAMLGenerator.Feature ... featureArray) {
            for (YAMLGenerator.Feature feature : featureArray) {
                ((YAMLMapper)this._mapper).disable(feature);
            }
            return this;
        }

        public Builder configure(YAMLGenerator.Feature feature, boolean bl2) {
            if (bl2) {
                ((YAMLMapper)this._mapper).enable(feature);
            } else {
                ((YAMLMapper)this._mapper).disable(feature);
            }
            return this;
        }
    }
}

