/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.dataformat.yaml.PackageVersion;
import com.fasterxml.jackson.dataformat.yaml.util.StringQuotingChecker;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.nodes.Tag;

public class YAMLGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected static final Pattern PLAIN_NUMBER_P = Pattern.compile("-?[0-9]*(\\.[0-9]*)?");
    protected static final String TAG_BINARY = Tag.BINARY.toString();
    protected final IOContext _ioContext;
    protected int _formatFeatures;
    protected Writer _writer;
    protected DumperOptions _outputOptions;
    protected final DumperOptions.Version _docVersion;
    private static final DumperOptions.ScalarStyle STYLE_UNQUOTED_NAME = DumperOptions.ScalarStyle.PLAIN;
    private static final DumperOptions.ScalarStyle STYLE_SCALAR = DumperOptions.ScalarStyle.PLAIN;
    private static final DumperOptions.ScalarStyle STYLE_QUOTED = DumperOptions.ScalarStyle.DOUBLE_QUOTED;
    private static final DumperOptions.ScalarStyle STYLE_LITERAL;
    private static final DumperOptions.ScalarStyle STYLE_BASE64;
    private static final DumperOptions.ScalarStyle STYLE_PLAIN;
    protected Emitter _emitter;
    protected String _objectId;
    protected String _typeId;
    protected int _rootValueCount;
    protected final StringQuotingChecker _quotingChecker;
    private static final ImplicitTuple NO_TAGS;
    private static final ImplicitTuple EXPLICIT_TAGS;

    public YAMLGenerator(IOContext iOContext, int n2, int n3, StringQuotingChecker stringQuotingChecker, ObjectCodec objectCodec, Writer writer, DumperOptions.Version version) throws IOException {
        super(n2, objectCodec);
        this._ioContext = iOContext;
        this._formatFeatures = n3;
        this._quotingChecker = stringQuotingChecker == null ? StringQuotingChecker.Default.instance() : stringQuotingChecker;
        this._writer = writer;
        this._docVersion = version;
        this._outputOptions = this.buildDumperOptions(n2, n3, version);
        this._emitter = new Emitter(this._writer, this._outputOptions);
        this._emit(new StreamStartEvent(null, null));
        this._emitStartDocument();
    }

    public YAMLGenerator(IOContext iOContext, int n2, int n3, StringQuotingChecker stringQuotingChecker, ObjectCodec objectCodec, Writer writer, DumperOptions dumperOptions) throws IOException {
        super(n2, objectCodec);
        this._ioContext = iOContext;
        this._formatFeatures = n3;
        this._quotingChecker = stringQuotingChecker == null ? StringQuotingChecker.Default.instance() : stringQuotingChecker;
        this._writer = writer;
        this._docVersion = dumperOptions.getVersion();
        this._outputOptions = dumperOptions;
        this._emitter = new Emitter(this._writer, this._outputOptions);
        this._emit(new StreamStartEvent(null, null));
        this._emitStartDocument();
    }

    @Deprecated
    public YAMLGenerator(IOContext iOContext, int n2, int n3, ObjectCodec objectCodec, Writer writer, DumperOptions.Version version) throws IOException {
        this(iOContext, n2, n3, null, objectCodec, writer, version);
    }

    protected DumperOptions buildDumperOptions(int n2, int n3, DumperOptions.Version version) {
        DumperOptions dumperOptions = new DumperOptions();
        if (Feature.CANONICAL_OUTPUT.enabledIn(this._formatFeatures)) {
            dumperOptions.setCanonical(true);
        } else {
            dumperOptions.setCanonical(false);
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        }
        dumperOptions.setSplitLines(Feature.SPLIT_LINES.enabledIn(this._formatFeatures));
        if (Feature.INDENT_ARRAYS.enabledIn(this._formatFeatures)) {
            dumperOptions.setIndicatorIndent(1);
            dumperOptions.setIndent(2);
        }
        if (Feature.INDENT_ARRAYS_WITH_INDICATOR.enabledIn(this._formatFeatures)) {
            dumperOptions.setIndicatorIndent(2);
            dumperOptions.setIndentWithIndicator(true);
        }
        if (Feature.USE_PLATFORM_LINE_BREAKS.enabledIn(this._formatFeatures)) {
            dumperOptions.setLineBreak(DumperOptions.LineBreak.getPlatformLineBreak());
        }
        if (Feature.ALLOW_LONG_KEYS.enabledIn(this._formatFeatures)) {
            dumperOptions.setMaxSimpleKeyLength(1024);
        }
        return dumperOptions;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public YAMLGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public YAMLGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._writer;
    }

    @Override
    public int getOutputBuffered() {
        return -1;
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonGenerator overrideFormatFeatures(int n2, int n3) {
        this._formatFeatures = this._formatFeatures & ~n3 | n2 & n3;
        return this;
    }

    @Override
    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    @Override
    public boolean canWriteFormattedNumbers() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return DEFAULT_TEXTUAL_WRITE_CAPABILITIES;
    }

    public YAMLGenerator enable(Feature feature) {
        this._formatFeatures |= feature.getMask();
        return this;
    }

    public YAMLGenerator disable(Feature feature) {
        this._formatFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._formatFeatures & feature.getMask()) != 0;
    }

    public YAMLGenerator configure(Feature feature, boolean bl2) {
        if (bl2) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    @Override
    public final void writeFieldName(String string) throws IOException {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
    }

    @Override
    public final void writeFieldName(SerializableString serializableString) throws IOException {
        if (this._writeContext.writeFieldName(serializableString.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString.getValue());
    }

    @Override
    public void writeFieldId(long l2) throws IOException {
        String string = Long.valueOf(l2).toString();
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field id, expecting a value");
        }
        this._writeScalar(string, "int", STYLE_SCALAR);
    }

    private final void _writeFieldName(String string) throws IOException {
        this._writeScalar(string, "string", this._quotingChecker.needToQuoteName(string) ? STYLE_QUOTED : STYLE_UNQUOTED_NAME);
    }

    @Override
    public final void flush() throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            this._emitEndDocument();
            this._emit(new StreamEndEvent(null, null));
            super.close();
            if (this._writer != null) {
                if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                    this._writer.close();
                } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                    this._writer.flush();
                }
            }
        }
    }

    @Override
    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        DumperOptions.FlowStyle flowStyle = this._outputOptions.getDefaultFlowStyle();
        String string = this._typeId;
        boolean bl2 = string == null;
        String string2 = this._objectId;
        if (string2 != null) {
            this._objectId = null;
        }
        this._emit(new SequenceStartEvent(string2, string, bl2, null, null, flowStyle));
    }

    @Override
    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        this._emit(new SequenceEndEvent(null, null));
    }

    @Override
    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        DumperOptions.FlowStyle flowStyle = this._outputOptions.getDefaultFlowStyle();
        String string = this._typeId;
        boolean bl2 = string == null;
        String string2 = this._objectId;
        if (string2 != null) {
            this._objectId = null;
        }
        this._emit(new MappingStartEvent(string2, string, bl2, null, null, flowStyle));
    }

    @Override
    public final void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        this._emit(new MappingEndEvent(null, null));
    }

    @Override
    public void writeString(String string) throws IOException, JsonGenerationException {
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        if (string.isEmpty()) {
            this._writeScalar(string, "string", STYLE_QUOTED);
            return;
        }
        DumperOptions.ScalarStyle scalarStyle = Feature.MINIMIZE_QUOTES.enabledIn(this._formatFeatures) ? (string.indexOf(10) >= 0 ? STYLE_LITERAL : (this._quotingChecker.needToQuoteValue(string) || Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS.enabledIn(this._formatFeatures) && PLAIN_NUMBER_P.matcher(string).matches() ? STYLE_QUOTED : STYLE_PLAIN)) : (Feature.LITERAL_BLOCK_STYLE.enabledIn(this._formatFeatures) && string.indexOf(10) >= 0 ? STYLE_LITERAL : STYLE_QUOTED);
        this._writeScalar(string, "string", scalarStyle);
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) throws IOException {
        this.writeString(new String(cArray, n2, n3));
    }

    @Override
    public final void writeString(SerializableString serializableString) throws IOException {
        this.writeString(serializableString.toString());
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public final void writeUTF8String(byte[] byArray, int n2, int n3) throws IOException {
        this.writeString(new String(byArray, n2, n3, "UTF-8"));
    }

    @Override
    public void writeRaw(String string) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string, int n2, int n3) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c2) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string, int n2, int n3) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(char[] cArray, int n2, int n3) throws IOException {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (n2 > 0 || n2 + n3 != byArray.length) {
            byArray = Arrays.copyOfRange(byArray, n2, n2 + n3);
        }
        this._writeScalarBinary(base64Variant, byArray);
    }

    @Override
    public void writeBoolean(boolean bl2) throws IOException {
        this._verifyValueWrite("write boolean value");
        this._writeScalar(bl2 ? "true" : "false", "bool", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(int n2) throws IOException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(n2), "int", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(long l2) throws IOException {
        if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
            this.writeNumber((int)l2);
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(l2), "long", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException {
        if (bigInteger == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(bigInteger.toString()), "java.math.BigInteger", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(double d2) throws IOException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(d2), "double", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(float f2) throws IOException {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(f2), "float", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        String string = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? bigDecimal.toPlainString() : bigDecimal.toString();
        this._writeScalar(string, "java.math.BigDecimal", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(String string) throws IOException, JsonGenerationException, UnsupportedOperationException {
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(string, "number", STYLE_SCALAR);
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        this._writeScalar("null", "object", STYLE_SCALAR);
    }

    @Override
    public boolean canWriteObjectId() {
        return Feature.USE_NATIVE_OBJECT_ID.enabledIn(this._formatFeatures);
    }

    @Override
    public boolean canWriteTypeId() {
        return Feature.USE_NATIVE_TYPE_ID.enabledIn(this._formatFeatures);
    }

    @Override
    public void writeTypeId(Object object) throws IOException {
        this._typeId = String.valueOf(object);
    }

    @Override
    public void writeObjectRef(Object object) throws IOException {
        this._verifyValueWrite("write Object reference");
        AliasEvent aliasEvent = new AliasEvent(String.valueOf(object), null, null);
        this._emit(aliasEvent);
    }

    @Override
    public void writeObjectId(Object object) throws IOException {
        this._objectId = object == null ? null : String.valueOf(object);
    }

    @Override
    protected final void _verifyValueWrite(String string) throws IOException {
        int n2 = this._writeContext.writeValue();
        if (n2 == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
        if (this._writeContext.inRoot() && this._writeContext.getCurrentIndex() > 0) {
            this._emitEndDocument();
            this._emitStartDocument();
        }
    }

    @Override
    protected void _releaseBuffers() {
    }

    protected void _writeScalar(String string, String string2, DumperOptions.ScalarStyle scalarStyle) throws IOException {
        this._emit(this._scalarEvent(string, scalarStyle));
    }

    private void _writeScalarBinary(Base64Variant base64Variant, byte[] byArray) throws IOException {
        if (base64Variant == Base64Variants.getDefaultVariant()) {
            base64Variant = Base64Variants.MIME;
        }
        String string = this._lf();
        String string2 = this._base64encode(base64Variant, byArray, string);
        this._emit(new ScalarEvent(null, TAG_BINARY, EXPLICIT_TAGS, string2, null, null, STYLE_BASE64));
    }

    protected ScalarEvent _scalarEvent(String string, DumperOptions.ScalarStyle scalarStyle) {
        String string2;
        String string3 = this._typeId;
        if (string3 != null) {
            this._typeId = null;
        }
        if ((string2 = this._objectId) != null) {
            this._objectId = null;
        }
        return new ScalarEvent(string2, string3, NO_TAGS, string, null, null, scalarStyle);
    }

    private String _base64encode(Base64Variant base64Variant, byte[] byArray, String string) {
        int n2;
        int n3 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n3 + (n3 >> 2) + (n3 >> 3));
        int n4 = base64Variant.getMaxLineLength() >> 2;
        int n5 = 0;
        int n6 = n3 - 3;
        while (n5 <= n6) {
            n2 = byArray[n5++] << 8;
            n2 |= byArray[n5++] & 0xFF;
            n2 = n2 << 8 | byArray[n5++] & 0xFF;
            base64Variant.encodeBase64Chunk(stringBuilder, n2);
            if (--n4 > 0) continue;
            stringBuilder.append(string);
            n4 = base64Variant.getMaxLineLength() >> 2;
        }
        n2 = n3 - n5;
        if (n2 > 0) {
            int n7 = byArray[n5++] << 16;
            if (n2 == 2) {
                n7 |= (byArray[n5++] & 0xFF) << 8;
            }
            base64Variant.encodeBase64Partial(stringBuilder, n7, n2);
        }
        return stringBuilder.toString();
    }

    protected String _lf() {
        return this._outputOptions.getLineBreak().getString();
    }

    protected void _emitStartDocument() throws IOException {
        Map<String, String> map = Collections.emptyMap();
        boolean bl2 = Feature.WRITE_DOC_START_MARKER.enabledIn(this._formatFeatures);
        this._emit(new DocumentStartEvent(null, null, bl2, this._docVersion, map));
    }

    protected void _emitEndDocument() throws IOException {
        this._emit(new DocumentEndEvent(null, null, false));
    }

    protected final void _emit(Event event) throws IOException {
        this._emitter.emit(event);
    }

    static {
        STYLE_BASE64 = STYLE_LITERAL = DumperOptions.ScalarStyle.LITERAL;
        STYLE_PLAIN = DumperOptions.ScalarStyle.PLAIN;
        NO_TAGS = new ImplicitTuple(true, true);
        EXPLICIT_TAGS = new ImplicitTuple(false, false);
    }

    public static enum Feature implements FormatFeature
    {
        WRITE_DOC_START_MARKER(true),
        USE_NATIVE_OBJECT_ID(true),
        USE_NATIVE_TYPE_ID(true),
        CANONICAL_OUTPUT(false),
        SPLIT_LINES(true),
        MINIMIZE_QUOTES(false),
        ALWAYS_QUOTE_NUMBERS_AS_STRINGS(false),
        LITERAL_BLOCK_STYLE(false),
        INDENT_ARRAYS(false),
        INDENT_ARRAYS_WITH_INDICATOR(false),
        USE_PLATFORM_LINE_BREAKS(false),
        ALLOW_LONG_KEYS(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public boolean enabledIn(int n2) {
            return (n2 & this._mask) != 0;
        }

        @Override
        public int getMask() {
            return this._mask;
        }
    }
}

