/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AsDeductionTypeDeserializer
extends AsPropertyTypeDeserializer {
    private static final long serialVersionUID = 1L;
    private static final BitSet EMPTY_CLASS_FINGERPRINT = new BitSet(0);
    private final Map<String, Integer> fieldBitIndex;
    private final Map<BitSet, String> subtypeFingerprints;

    public AsDeductionTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, JavaType javaType2, DeserializationConfig deserializationConfig, Collection<NamedType> collection) {
        super(javaType, typeIdResolver, null, false, javaType2, null);
        this.fieldBitIndex = new HashMap<String, Integer>();
        this.subtypeFingerprints = this.buildFingerprints(deserializationConfig, collection);
    }

    public AsDeductionTypeDeserializer(AsDeductionTypeDeserializer asDeductionTypeDeserializer, BeanProperty beanProperty) {
        super(asDeductionTypeDeserializer, beanProperty);
        this.fieldBitIndex = asDeductionTypeDeserializer.fieldBitIndex;
        this.subtypeFingerprints = asDeductionTypeDeserializer.subtypeFingerprints;
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty beanProperty) {
        return beanProperty == this._property ? this : new AsDeductionTypeDeserializer(this, beanProperty);
    }

    protected Map<BitSet, String> buildFingerprints(DeserializationConfig deserializationConfig, Collection<NamedType> collection) {
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        int n2 = 0;
        HashMap<BitSet, String> hashMap = new HashMap<BitSet, String>();
        for (NamedType namedType : collection) {
            JavaType javaType = deserializationConfig.getTypeFactory().constructType(namedType.getType());
            List<BeanPropertyDefinition> list = deserializationConfig.introspect(javaType).findProperties();
            BitSet bitSet = new BitSet(n2 + list.size());
            for (BeanPropertyDefinition beanPropertyDefinition : list) {
                Integer n3;
                String string = beanPropertyDefinition.getName();
                if (bl2) {
                    string = string.toLowerCase();
                }
                if ((n3 = this.fieldBitIndex.get(string)) == null) {
                    n3 = n2;
                    this.fieldBitIndex.put(string, n2++);
                }
                bitSet.set(n3);
            }
            String string = hashMap.put(bitSet, namedType.getType().getName());
            if (string == null) continue;
            throw new IllegalStateException(String.format("Subtypes %s and %s have the same signature and cannot be uniquely deduced.", string, namedType.getType().getName()));
        }
        return hashMap;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        Object object;
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        } else if (jsonToken != JsonToken.FIELD_NAME) {
            return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, null, "Unexpected input");
        }
        if (jsonToken == JsonToken.END_OBJECT && (object = this.subtypeFingerprints.get(EMPTY_CLASS_FINGERPRINT)) != null) {
            return this._deserializeTypedForId(jsonParser, deserializationContext, null, (String)object);
        }
        object = new LinkedList<BitSet>(this.subtypeFingerprints.keySet());
        TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
        boolean bl2 = deserializationContext.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        while (jsonToken == JsonToken.FIELD_NAME) {
            string = jsonParser.currentName();
            if (bl2) {
                string = string.toLowerCase();
            }
            tokenBuffer.copyCurrentStructure(jsonParser);
            Integer n2 = this.fieldBitIndex.get(string);
            if (n2 != null) {
                AsDeductionTypeDeserializer.prune((List<BitSet>)object, n2);
                if (object.size() == 1) {
                    return this._deserializeTypedForId(jsonParser, deserializationContext, tokenBuffer, this.subtypeFingerprints.get(object.get(0)));
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        string = String.format("Cannot deduce unique subtype of %s (%d candidates match)", ClassUtil.getTypeDescription(this._baseType), object.size());
        return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, tokenBuffer, string);
    }

    private static void prune(List<BitSet> list, int n2) {
        Iterator<BitSet> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().get(n2)) continue;
            iterator.remove();
        }
    }
}

