/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class DefaultDeserializationContext
extends DeserializationContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LinkedHashMap<ObjectIdGenerator.IdKey, ReadableObjectId> _objectIds;
    private List<ObjectIdResolver> _objectIdResolvers;

    protected DefaultDeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        super(deserializerFactory, deserializerCache);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        super(defaultDeserializationContext, deserializationConfig, jsonParser, injectableValues);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializationConfig deserializationConfig) {
        super((DeserializationContext)defaultDeserializationContext, deserializationConfig);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializerFactory deserializerFactory) {
        super((DeserializationContext)defaultDeserializationContext, deserializerFactory);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext) {
        super(defaultDeserializationContext);
    }

    public DefaultDeserializationContext copy() {
        throw new IllegalStateException("DefaultDeserializationContext sub-class not overriding copy()");
    }

    @Override
    public ReadableObjectId findObjectId(Object object, ObjectIdGenerator<?> objectIdGenerator, ObjectIdResolver objectIdResolver) {
        Object object2;
        if (object == null) {
            return null;
        }
        ObjectIdGenerator.IdKey idKey = objectIdGenerator.key(object);
        if (this._objectIds == null) {
            this._objectIds = new LinkedHashMap();
        } else {
            object2 = this._objectIds.get(idKey);
            if (object2 != null) {
                return object2;
            }
        }
        object2 = null;
        if (this._objectIdResolvers == null) {
            this._objectIdResolvers = new ArrayList<ObjectIdResolver>(8);
        } else {
            for (ObjectIdResolver objectIdResolver2 : this._objectIdResolvers) {
                if (!objectIdResolver2.canUseFor(objectIdResolver)) continue;
                object2 = objectIdResolver2;
                break;
            }
        }
        if (object2 == null) {
            object2 = objectIdResolver.newForDeserialization(this);
            this._objectIdResolvers.add((ObjectIdResolver)object2);
        }
        ReadableObjectId readableObjectId = this.createReadableObjectId(idKey);
        readableObjectId.setResolver((ObjectIdResolver)object2);
        this._objectIds.put(idKey, readableObjectId);
        return readableObjectId;
    }

    protected ReadableObjectId createReadableObjectId(ObjectIdGenerator.IdKey idKey) {
        return new ReadableObjectId(idKey);
    }

    @Override
    public void checkUnresolvedObjectId() throws UnresolvedForwardReference {
        if (this._objectIds == null) {
            return;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS)) {
            return;
        }
        UnresolvedForwardReference unresolvedForwardReference = null;
        for (Map.Entry<ObjectIdGenerator.IdKey, ReadableObjectId> entry : this._objectIds.entrySet()) {
            ReadableObjectId readableObjectId = entry.getValue();
            if (!readableObjectId.hasReferringProperties() || this.tryToResolveUnresolvedObjectId(readableObjectId)) continue;
            if (unresolvedForwardReference == null) {
                unresolvedForwardReference = new UnresolvedForwardReference(this.getParser(), "Unresolved forward references for: ").withStackTrace();
            }
            Object object = readableObjectId.getKey().key;
            Iterator<ReadableObjectId.Referring> iterator = readableObjectId.referringProperties();
            while (iterator.hasNext()) {
                ReadableObjectId.Referring referring = iterator.next();
                unresolvedForwardReference.addUnresolvedId(object, referring.getBeanType(), referring.getLocation());
            }
        }
        if (unresolvedForwardReference != null) {
            throw unresolvedForwardReference;
        }
    }

    protected boolean tryToResolveUnresolvedObjectId(ReadableObjectId readableObjectId) {
        return readableObjectId.tryToResolveUnresolved(this);
    }

    @Override
    public JsonDeserializer<Object> deserializerInstance(Annotated annotated, Object object) throws JsonMappingException {
        JsonDeserializer jsonDeserializer;
        if (object == null) {
            return null;
        }
        if (object instanceof JsonDeserializer) {
            jsonDeserializer = (JsonDeserializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + object.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == JsonDeserializer.None.class || ClassUtil.isBogusClass(clazz)) {
                return null;
            }
            if (!JsonDeserializer.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<JsonDeserializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            JsonDeserializer jsonDeserializer2 = jsonDeserializer = handlerInstantiator == null ? null : handlerInstantiator.deserializerInstance(this._config, annotated, clazz);
            if (jsonDeserializer == null) {
                jsonDeserializer = (JsonDeserializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
            }
        }
        if (jsonDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)jsonDeserializer)).resolve(this);
        }
        return jsonDeserializer;
    }

    @Override
    public final KeyDeserializer keyDeserializerInstance(Annotated annotated, Object object) throws JsonMappingException {
        KeyDeserializer keyDeserializer;
        if (object == null) {
            return null;
        }
        if (object instanceof KeyDeserializer) {
            keyDeserializer = (KeyDeserializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == KeyDeserializer.None.class || ClassUtil.isBogusClass(clazz)) {
                return null;
            }
            if (!KeyDeserializer.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<KeyDeserializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            KeyDeserializer keyDeserializer2 = keyDeserializer = handlerInstantiator == null ? null : handlerInstantiator.keyDeserializerInstance(this._config, annotated, clazz);
            if (keyDeserializer == null) {
                keyDeserializer = (KeyDeserializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
            }
        }
        if (keyDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)keyDeserializer)).resolve(this);
        }
        return keyDeserializer;
    }

    public abstract DefaultDeserializationContext with(DeserializerFactory var1);

    public abstract DefaultDeserializationContext createInstance(DeserializationConfig var1, JsonParser var2, InjectableValues var3);

    public abstract DefaultDeserializationContext createDummyInstance(DeserializationConfig var1);

    public Object readRootValue(JsonParser jsonParser, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object) throws IOException {
        if (this._config.useRootWrapping()) {
            return this._unwrapAndDeserialize(jsonParser, javaType, jsonDeserializer, object);
        }
        if (object == null) {
            return jsonDeserializer.deserialize(jsonParser, this);
        }
        return jsonDeserializer.deserialize(jsonParser, this, object);
    }

    protected Object _unwrapAndDeserialize(JsonParser jsonParser, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object) throws IOException {
        String string;
        PropertyName propertyName = this._config.findRootName(javaType);
        String string2 = propertyName.getSimpleName();
        if (jsonParser.currentToken() != JsonToken.START_OBJECT) {
            this.reportWrongTokenException(javaType, JsonToken.START_OBJECT, "Current token not START_OBJECT (needed to unwrap root name %s), but %s", new Object[]{ClassUtil.name(string2), jsonParser.currentToken()});
        }
        if (jsonParser.nextToken() != JsonToken.FIELD_NAME) {
            this.reportWrongTokenException(javaType, JsonToken.FIELD_NAME, "Current token not FIELD_NAME (to contain expected root name %s), but %s", new Object[]{ClassUtil.name(string2), jsonParser.currentToken()});
        }
        if (!string2.equals(string = jsonParser.currentName())) {
            this.reportPropertyInputMismatch(javaType, string, "Root name (%s) does not match expected (%s) for type %s", ClassUtil.name(string), ClassUtil.name(string2), ClassUtil.getTypeDescription(javaType));
        }
        jsonParser.nextToken();
        Object object2 = object == null ? jsonDeserializer.deserialize(jsonParser, this) : jsonDeserializer.deserialize(jsonParser, this, object);
        if (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            this.reportWrongTokenException(javaType, JsonToken.END_OBJECT, "Current token not END_OBJECT (to match wrapper object with root name %s), but %s", new Object[]{ClassUtil.name(string2), jsonParser.currentToken()});
        }
        return object2;
    }

    public static final class Impl
    extends DefaultDeserializationContext {
        private static final long serialVersionUID = 1L;

        public Impl(DeserializerFactory deserializerFactory) {
            super(deserializerFactory, null);
        }

        private Impl(Impl impl, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
            super(impl, deserializationConfig, jsonParser, injectableValues);
        }

        private Impl(Impl impl) {
            super(impl);
        }

        private Impl(Impl impl, DeserializerFactory deserializerFactory) {
            super((DefaultDeserializationContext)impl, deserializerFactory);
        }

        private Impl(Impl impl, DeserializationConfig deserializationConfig) {
            super((DefaultDeserializationContext)impl, deserializationConfig);
        }

        @Override
        public DefaultDeserializationContext copy() {
            ClassUtil.verifyMustOverride(Impl.class, this, "copy");
            return new Impl(this);
        }

        @Override
        public DefaultDeserializationContext createInstance(DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
            return new Impl(this, deserializationConfig, jsonParser, injectableValues);
        }

        @Override
        public DefaultDeserializationContext createDummyInstance(DeserializationConfig deserializationConfig) {
            return new Impl(this, deserializationConfig);
        }

        @Override
        public DefaultDeserializationContext with(DeserializerFactory deserializerFactory) {
            return new Impl(this, deserializerFactory);
        }
    }
}

