/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.AbstractFloatingPointBitsFromCharArray;
import com.fasterxml.jackson.core.io.doubleparser.FastFloatMath;

class FloatBitsFromCharArray
extends AbstractFloatingPointBitsFromCharArray {
    @Override
    long nan() {
        return Float.floatToRawIntBits(Float.NaN);
    }

    @Override
    long negativeInfinity() {
        return Float.floatToRawIntBits(Float.NEGATIVE_INFINITY);
    }

    @Override
    long positiveInfinity() {
        return Float.floatToRawIntBits(Float.POSITIVE_INFINITY);
    }

    @Override
    long valueOfFloatLiteral(char[] cArray, int n2, int n3, boolean bl2, long l2, int n4, boolean bl3, int n5) {
        float f2 = FastFloatMath.decFloatLiteralToFloat(bl2, l2, n4, bl3, n5);
        return Float.isNaN(f2) ? (long)Float.floatToRawIntBits(Float.parseFloat(new String(cArray, n2, n3 - n2))) : (long)Float.floatToRawIntBits(f2);
    }

    @Override
    long valueOfHexLiteral(char[] cArray, int n2, int n3, boolean bl2, long l2, int n4, boolean bl3, int n5) {
        float f2 = FastFloatMath.hexFloatLiteralToFloat(bl2, l2, n4, bl3, n5);
        return Float.floatToRawIntBits(Float.isNaN(f2) ? Float.parseFloat(new String(cArray, n2, n3 - n2)) : f2);
    }
}

