/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.FloatBitsFromCharArray;
import com.fasterxml.jackson.core.io.doubleparser.FloatBitsFromCharSequence;

public class FastFloatParser {
    private static final FloatBitsFromCharArray CHAR_ARRAY_PARSER = new FloatBitsFromCharArray();
    private static final FloatBitsFromCharSequence CHAR_SEQ_PARSER = new FloatBitsFromCharSequence();

    private FastFloatParser() {
    }

    public static float parseFloat(CharSequence charSequence) throws NumberFormatException {
        return FastFloatParser.parseFloat(charSequence, 0, charSequence.length());
    }

    public static float parseFloat(CharSequence charSequence, int n2, int n3) throws NumberFormatException {
        long l2 = CHAR_SEQ_PARSER.parseFloatingPointLiteral(charSequence, n2, n3);
        if (l2 == -1L) {
            throw new NumberFormatException("Illegal input");
        }
        return Float.intBitsToFloat((int)l2);
    }

    public static float parseFloat(char[] cArray) throws NumberFormatException {
        return FastFloatParser.parseFloat(cArray, 0, cArray.length);
    }

    public static float parseFloat(char[] cArray, int n2, int n3) throws NumberFormatException {
        long l2 = CHAR_ARRAY_PARSER.parseFloatingPointLiteral(cArray, n2, n3);
        if (l2 == -1L) {
            throw new NumberFormatException("Illegal input");
        }
        return Float.intBitsToFloat((int)l2);
    }

    public static long parseFloatBits(CharSequence charSequence, int n2, int n3) {
        return CHAR_SEQ_PARSER.parseFloatingPointLiteral(charSequence, n2, n3);
    }

    public static long parseFloatBits(char[] cArray, int n2, int n3) {
        return CHAR_ARRAY_PARSER.parseFloatingPointLiteral(cArray, n2, n3);
    }
}

