/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.AbstractFloatValueParser;
import com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;

abstract class AbstractFloatingPointBitsFromCharArray
extends AbstractFloatValueParser {
    AbstractFloatingPointBitsFromCharArray() {
    }

    private static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    private int skipWhitespace(char[] cArray, int n2, int n3) {
        while (n2 < n3 && (cArray[n2] & 0xFF) <= 32) {
            ++n2;
        }
        return n2;
    }

    private long parseDecFloatLiteral(char[] cArray, int n2, int n3, int n4, boolean bl2, boolean bl3) {
        int n5;
        boolean bl4;
        int n6;
        int n7;
        long l2 = 0L;
        int n8 = n2;
        int n9 = -1;
        boolean bl5 = false;
        char c2 = '\u0000';
        while (n2 < n4) {
            c2 = cArray[n2];
            if (AbstractFloatingPointBitsFromCharArray.isDigit(c2)) {
                l2 = 10L * l2 + (long)c2 - 48L;
            } else {
                if (c2 != '.') break;
                bl5 |= n9 >= 0;
                n9 = n2;
                while (n2 < n4 - 8 && (n7 = this.tryToParseEightDigits(cArray, n2 + 1)) >= 0) {
                    l2 = 100000000L * l2 + (long)n7;
                    n2 += 8;
                }
            }
            ++n2;
        }
        int n10 = n2;
        if (n9 < 0) {
            n7 = n2 - n8;
            n9 = n2;
            n6 = 0;
        } else {
            n7 = n2 - n8 - 1;
            n6 = n9 - n2 + 1;
        }
        int n11 = 0;
        if (c2 == 'e' || c2 == 'E') {
            c2 = ++n2 < n4 ? cArray[n2] : (char)'\u0000';
            boolean bl6 = bl4 = c2 == '-';
            if (bl4 || c2 == '+') {
                c2 = ++n2 < n4 ? cArray[n2] : (char)'\u0000';
            }
            bl5 |= !AbstractFloatingPointBitsFromCharArray.isDigit(c2);
            do {
                if (n11 >= 1024) continue;
                n11 = 10 * n11 + c2 - 48;
            } while (AbstractFloatingPointBitsFromCharArray.isDigit(c2 = ++n2 < n4 ? cArray[n2] : (char)'\u0000'));
            if (bl4) {
                n11 = -n11;
            }
            n6 += n11;
        }
        if (n2 < n4 && (c2 == 'd' || c2 == 'D' || c2 == 'f' || c2 == 'F')) {
            ++n2;
        }
        n2 = this.skipWhitespace(cArray, n2, n4);
        if (bl5 || n2 < n4 || !bl3 && n7 == 0) {
            return -1L;
        }
        int n12 = 0;
        if (n7 > 19) {
            l2 = 0L;
            for (n2 = n8; n2 < n10; ++n2) {
                c2 = cArray[n2];
                if (c2 == '.') {
                    ++n12;
                    continue;
                }
                if (Long.compareUnsigned(l2, 1000000000000000000L) >= 0) break;
                l2 = 10L * l2 + (long)c2 - 48L;
            }
            bl4 = n2 < n10;
            n5 = n9 - n2 + n12 + n11;
        } else {
            bl4 = false;
            n5 = 0;
        }
        return this.valueOfFloatLiteral(cArray, n3, n4, bl2, l2, n6, bl4, n5);
    }

    public long parseFloatingPointLiteral(char[] cArray, int n2, int n3) {
        boolean bl2;
        boolean bl3;
        int n4 = n2 + n3;
        if (n2 < 0 || n4 > cArray.length) {
            return -1L;
        }
        int n5 = this.skipWhitespace(cArray, n2, n4);
        if (n5 == n4) {
            return -1L;
        }
        char c2 = cArray[n5];
        boolean bl4 = bl3 = c2 == '-';
        if (bl3 || c2 == '+') {
            char c3 = c2 = ++n5 < n4 ? cArray[n5] : (char)'\u0000';
            if (c2 == '\u0000') {
                return -1L;
            }
        }
        if (c2 >= 'I') {
            return c2 == 'N' ? this.parseNaN(cArray, n5, n4) : this.parseInfinity(cArray, n5, n4, bl3);
        }
        boolean bl5 = bl2 = c2 == '0';
        if (bl2) {
            char c4 = c2 = ++n5 < n4 ? cArray[n5] : (char)'\u0000';
            if (c2 == 'x' || c2 == 'X') {
                return this.parseHexFloatLiteral(cArray, n5 + 1, n2, n4, bl3);
            }
        }
        return this.parseDecFloatLiteral(cArray, n5, n2, n4, bl3, bl2);
    }

    private long parseHexFloatLiteral(char[] cArray, int n2, int n3, int n4, boolean bl2) {
        boolean bl3;
        boolean bl4;
        int n5;
        int n6;
        long l2 = 0L;
        int n7 = 0;
        int n8 = n2;
        int n9 = -1;
        boolean bl5 = false;
        char c2 = '\u0000';
        while (n2 < n4) {
            c2 = cArray[n2];
            int n10 = n6 = c2 > '\u007f' ? -1 : AbstractFloatValueParser.CHAR_TO_HEX_MAP[c2];
            if (n6 >= 0) {
                l2 = l2 << 4 | (long)n6;
            } else {
                if (n6 != -4) break;
                bl5 |= n9 >= 0;
                n9 = n2;
            }
            ++n2;
        }
        n6 = n2;
        if (n9 < 0) {
            n5 = n6 - n8;
            n9 = n6;
        } else {
            n5 = n6 - n8 - 1;
            n7 = Math.min(n9 - n2 + 1, 1024) * 4;
        }
        int n11 = 0;
        boolean bl6 = bl4 = c2 == 'p' || c2 == 'P';
        if (bl4) {
            c2 = ++n2 < n4 ? cArray[n2] : (char)'\u0000';
            boolean bl7 = bl3 = c2 == '-';
            if (bl3 || c2 == '+') {
                c2 = ++n2 < n4 ? cArray[n2] : (char)'\u0000';
            }
            bl5 |= !AbstractFloatingPointBitsFromCharArray.isDigit(c2);
            do {
                if (n11 >= 1024) continue;
                n11 = 10 * n11 + c2 - 48;
            } while (AbstractFloatingPointBitsFromCharArray.isDigit(c2 = ++n2 < n4 ? cArray[n2] : (char)'\u0000'));
            if (bl3) {
                n11 = -n11;
            }
            n7 += n11;
        }
        if (n2 < n4 && (c2 == 'd' || c2 == 'D' || c2 == 'f' || c2 == 'F')) {
            ++n2;
        }
        n2 = this.skipWhitespace(cArray, n2, n4);
        if (bl5 || n2 < n4 || n5 == 0 || !bl4) {
            return -1L;
        }
        int n12 = 0;
        if (n5 > 16) {
            l2 = 0L;
            for (n2 = n8; n2 < n6; ++n2) {
                int n13;
                c2 = cArray[n2];
                int n14 = n13 = c2 > '\u007f' ? -1 : AbstractFloatValueParser.CHAR_TO_HEX_MAP[c2];
                if (n13 >= 0) {
                    if (Long.compareUnsigned(l2, 1000000000000000000L) >= 0) break;
                    l2 = l2 << 4 | (long)n13;
                    continue;
                }
                ++n12;
            }
            bl3 = n2 < n6;
        } else {
            bl3 = false;
        }
        return this.valueOfHexLiteral(cArray, n3, n4, bl2, l2, n7, bl3, n9 - n2 + n12 + n11);
    }

    private long parseInfinity(char[] cArray, int n2, int n3, boolean bl2) {
        if (n2 + 7 < n3 && cArray[n2] == 'I' && cArray[n2 + 1] == 'n' && cArray[n2 + 2] == 'f' && cArray[n2 + 3] == 'i' && cArray[n2 + 4] == 'n' && cArray[n2 + 5] == 'i' && cArray[n2 + 6] == 't' && cArray[n2 + 7] == 'y' && (n2 = this.skipWhitespace(cArray, n2 + 8, n3)) == n3) {
            return bl2 ? this.negativeInfinity() : this.positiveInfinity();
        }
        return -1L;
    }

    private long parseNaN(char[] cArray, int n2, int n3) {
        if (n2 + 2 < n3 && cArray[n2 + 1] == 'a' && cArray[n2 + 2] == 'N' && (n2 = this.skipWhitespace(cArray, n2 + 3, n3)) == n3) {
            return this.nan();
        }
        return -1L;
    }

    private int tryToParseEightDigits(char[] cArray, int n2) {
        return FastDoubleSwar.tryToParseEightDigitsUtf16(cArray, n2);
    }

    abstract long nan();

    abstract long negativeInfinity();

    abstract long positiveInfinity();

    abstract long valueOfFloatLiteral(char[] var1, int var2, int var3, boolean var4, long var5, int var7, boolean var8, int var9);

    abstract long valueOfHexLiteral(char[] var1, int var2, int var3, boolean var4, long var5, int var7, boolean var8, int var9);
}

