/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.filter;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.filter.TokenFilter;

public class JsonPointerBasedFilter
extends TokenFilter {
    protected final JsonPointer _pathToMatch;

    public JsonPointerBasedFilter(String string) {
        this(JsonPointer.compile(string));
    }

    public JsonPointerBasedFilter(JsonPointer jsonPointer) {
        this._pathToMatch = jsonPointer;
    }

    @Override
    public TokenFilter includeElement(int n2) {
        JsonPointer jsonPointer = this._pathToMatch.matchElement(n2);
        if (jsonPointer == null) {
            return null;
        }
        if (jsonPointer.matches()) {
            return TokenFilter.INCLUDE_ALL;
        }
        return new JsonPointerBasedFilter(jsonPointer);
    }

    @Override
    public TokenFilter includeProperty(String string) {
        JsonPointer jsonPointer = this._pathToMatch.matchProperty(string);
        if (jsonPointer == null) {
            return null;
        }
        if (jsonPointer.matches()) {
            return TokenFilter.INCLUDE_ALL;
        }
        return new JsonPointerBasedFilter(jsonPointer);
    }

    @Override
    public TokenFilter filterStartArray() {
        return this;
    }

    @Override
    public TokenFilter filterStartObject() {
        return this;
    }

    @Override
    protected boolean _includeScalar() {
        return this._pathToMatch.matches();
    }

    @Override
    public String toString() {
        return "[JsonPointerFilter at: " + this._pathToMatch + "]";
    }
}

