/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.io.NumberInput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class JsonPointer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char SEPARATOR = '/';
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected volatile JsonPointer _head;
    protected final String _asString;
    protected final int _asStringOffset;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;
    protected int _hashCode;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = null;
        this._matchingElementIndex = -1;
        this._asString = "";
        this._asStringOffset = 0;
    }

    protected JsonPointer(String string, int n2, String string2, JsonPointer jsonPointer) {
        this._asString = string;
        this._asStringOffset = n2;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = JsonPointer._parseIndex(string2);
    }

    protected JsonPointer(String string, int n2, String string2, int n3, JsonPointer jsonPointer) {
        this._asString = string;
        this._asStringOffset = n2;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = n3;
    }

    public static JsonPointer compile(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        if (string.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + string + "\"");
        }
        return JsonPointer._parseTail(string);
    }

    public static JsonPointer valueOf(String string) {
        return JsonPointer.compile(string);
    }

    public static JsonPointer empty() {
        return EMPTY;
    }

    public static JsonPointer forPath(JsonStreamContext jsonStreamContext, boolean bl2) {
        if (jsonStreamContext == null) {
            return EMPTY;
        }
        if (!(jsonStreamContext.hasPathSegment() || bl2 && jsonStreamContext.inRoot() && jsonStreamContext.hasCurrentIndex())) {
            jsonStreamContext = jsonStreamContext.getParent();
        }
        PointerSegment pointerSegment = null;
        int n2 = 0;
        while (jsonStreamContext != null) {
            if (jsonStreamContext.inObject()) {
                String string = jsonStreamContext.getCurrentName();
                if (string == null) {
                    string = "";
                }
                n2 += 2 + string.length();
                pointerSegment = new PointerSegment(pointerSegment, string, -1);
            } else if (jsonStreamContext.inArray() || bl2) {
                int n3 = jsonStreamContext.getCurrentIndex();
                n2 += 6;
                pointerSegment = new PointerSegment(pointerSegment, null, n3);
            }
            jsonStreamContext = jsonStreamContext.getParent();
        }
        if (pointerSegment == null) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        PointerSegment pointerSegment2 = null;
        while (pointerSegment != null) {
            pointerSegment2 = pointerSegment;
            pointerSegment.pathOffset = stringBuilder.length();
            stringBuilder.append('/');
            if (pointerSegment.property != null) {
                JsonPointer._appendEscaped(stringBuilder, pointerSegment.property);
            } else {
                stringBuilder.append(pointerSegment.index);
            }
            pointerSegment = pointerSegment.next;
        }
        String string = stringBuilder.toString();
        PointerSegment pointerSegment3 = pointerSegment2;
        JsonPointer jsonPointer = EMPTY;
        while (pointerSegment3 != null) {
            if (pointerSegment3.property != null) {
                jsonPointer = new JsonPointer(string, pointerSegment3.pathOffset, pointerSegment3.property, jsonPointer);
            } else {
                int n4 = pointerSegment3.index;
                jsonPointer = new JsonPointer(string, pointerSegment3.pathOffset, String.valueOf(n4), n4, jsonPointer);
            }
            pointerSegment3 = pointerSegment3.prev;
        }
        return jsonPointer;
    }

    private static void _appendEscaped(StringBuilder stringBuilder, String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '/') {
                stringBuilder.append("~1");
                continue;
            }
            if (c2 == '~') {
                stringBuilder.append("~0");
                continue;
            }
            stringBuilder.append(c2);
        }
    }

    public int length() {
        return this._asString.length() - this._asStringOffset;
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer last() {
        JsonPointer jsonPointer;
        JsonPointer jsonPointer2 = this;
        if (jsonPointer2 == EMPTY) {
            return null;
        }
        while ((jsonPointer = jsonPointer2._nextSegment) != EMPTY) {
            jsonPointer2 = jsonPointer;
        }
        return jsonPointer2;
    }

    public JsonPointer append(JsonPointer jsonPointer) {
        if (this == EMPTY) {
            return jsonPointer;
        }
        if (jsonPointer == EMPTY) {
            return this;
        }
        String string = this._asString;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return JsonPointer.compile(string + jsonPointer._asString);
    }

    public JsonPointer appendProperty(String string) {
        String string2;
        if (string == null || string.isEmpty()) {
            return this;
        }
        if (string.charAt(0) != '/') {
            string = '/' + string;
        }
        if ((string2 = this._asString).endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return JsonPointer.compile(string2 + string);
    }

    public JsonPointer appendIndex(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative index cannot be appended");
        }
        String string = this._asString;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return JsonPointer.compile(string + '/' + n2);
    }

    public boolean matchesProperty(String string) {
        return this._nextSegment != null && this._matchingPropertyName.equals(string);
    }

    public JsonPointer matchProperty(String string) {
        if (this._nextSegment != null && this._matchingPropertyName.equals(string)) {
            return this._nextSegment;
        }
        return null;
    }

    public boolean matchesElement(int n2) {
        return n2 == this._matchingElementIndex && n2 >= 0;
    }

    public JsonPointer matchElement(int n2) {
        if (n2 != this._matchingElementIndex || n2 < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public JsonPointer head() {
        JsonPointer jsonPointer = this._head;
        if (jsonPointer == null) {
            if (this != EMPTY) {
                jsonPointer = this._constructHead();
            }
            this._head = jsonPointer;
        }
        return jsonPointer;
    }

    public String toString() {
        if (this._asStringOffset <= 0) {
            return this._asString;
        }
        return this._asString.substring(this._asStringOffset);
    }

    public int hashCode() {
        int n2 = this._hashCode;
        if (n2 == 0) {
            n2 = this.toString().hashCode();
            if (n2 == 0) {
                n2 = -1;
            }
            this._hashCode = n2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonPointer)) {
            return false;
        }
        JsonPointer jsonPointer = (JsonPointer)object;
        return this._compare(this._asString, this._asStringOffset, jsonPointer._asString, jsonPointer._asStringOffset);
    }

    private final boolean _compare(String string, int n2, String string2, int n3) {
        int n4 = string.length();
        if (n4 - n2 != string2.length() - n3) {
            return false;
        }
        while (n2 < n4) {
            if (string.charAt(n2++) == string2.charAt(n3++)) continue;
            return false;
        }
        return true;
    }

    private static final int _parseIndex(String string) {
        long l2;
        int n2 = string.length();
        if (n2 == 0 || n2 > 10) {
            return -1;
        }
        char c2 = string.charAt(0);
        if (c2 <= '0') {
            return n2 == 1 && c2 == '0' ? 0 : -1;
        }
        if (c2 > '9') {
            return -1;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            c2 = string.charAt(i2);
            if (c2 <= '9' && c2 >= '0') continue;
            return -1;
        }
        if (n2 == 10 && (l2 = NumberInput.parseLong(string)) > Integer.MAX_VALUE) {
            return -1;
        }
        return NumberInput.parseInt(string);
    }

    protected static JsonPointer _parseTail(String string) {
        PointerParent pointerParent = null;
        int n2 = 1;
        int n3 = string.length();
        int n4 = 0;
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 == '/') {
                pointerParent = new PointerParent(pointerParent, n4, string.substring(n4 + 1, n2));
                n4 = n2++;
                continue;
            }
            if (c2 != '~' || ++n2 >= n3) continue;
            StringBuilder stringBuilder = new StringBuilder(32);
            n2 = JsonPointer._extractEscapedSegment(string, n4 + 1, n2, stringBuilder);
            String string2 = stringBuilder.toString();
            if (n2 < 0) {
                return JsonPointer._buildPath(string, n4, string2, pointerParent);
            }
            pointerParent = new PointerParent(pointerParent, n4, string2);
            n4 = n2++;
        }
        return JsonPointer._buildPath(string, n4, string.substring(n4 + 1), pointerParent);
    }

    private static JsonPointer _buildPath(String string, int n2, String string2, PointerParent pointerParent) {
        JsonPointer jsonPointer = new JsonPointer(string, n2, string2, EMPTY);
        while (pointerParent != null) {
            jsonPointer = new JsonPointer(string, pointerParent.fullPathOffset, pointerParent.segment, jsonPointer);
            pointerParent = pointerParent.parent;
        }
        return jsonPointer;
    }

    protected static int _extractEscapedSegment(String string, int n2, int n3, StringBuilder stringBuilder) {
        int n4 = string.length();
        int n5 = n3 - 1 - n2;
        if (n5 > 0) {
            stringBuilder.append(string, n2, n3 - 1);
        }
        JsonPointer._appendEscape(stringBuilder, string.charAt(n3++));
        while (n3 < n4) {
            char c2 = string.charAt(n3);
            if (c2 == '/') {
                return n3;
            }
            if (c2 == '~' && ++n3 < n4) {
                JsonPointer._appendEscape(stringBuilder, string.charAt(n3++));
                continue;
            }
            stringBuilder.append(c2);
        }
        return -1;
    }

    private static void _appendEscape(StringBuilder stringBuilder, char c2) {
        if (c2 == '0') {
            c2 = (char)126;
        } else if (c2 == '1') {
            c2 = (char)47;
        } else {
            stringBuilder.append('~');
        }
        stringBuilder.append(c2);
    }

    protected JsonPointer _constructHead() {
        JsonPointer jsonPointer = this.last();
        if (jsonPointer == this) {
            return EMPTY;
        }
        int n2 = jsonPointer.length();
        JsonPointer jsonPointer2 = this._nextSegment;
        String string = this.toString();
        return new JsonPointer(string.substring(0, string.length() - n2), 0, this._matchingPropertyName, this._matchingElementIndex, jsonPointer2._constructHead(n2, jsonPointer));
    }

    protected JsonPointer _constructHead(int n2, JsonPointer jsonPointer) {
        if (this == jsonPointer) {
            return EMPTY;
        }
        JsonPointer jsonPointer2 = this._nextSegment;
        String string = this.toString();
        return new JsonPointer(string.substring(0, string.length() - n2), 0, this._matchingPropertyName, this._matchingElementIndex, jsonPointer2._constructHead(n2, jsonPointer));
    }

    private Object writeReplace() {
        return new Serialization(this.toString());
    }

    static class Serialization
    implements Externalizable {
        private String _fullPath;

        public Serialization() {
        }

        Serialization(String string) {
            this._fullPath = string;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this._fullPath);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this._fullPath = objectInput.readUTF();
        }

        private Object readResolve() throws ObjectStreamException {
            return JsonPointer.compile(this._fullPath);
        }
    }

    private static class PointerSegment {
        public final PointerSegment next;
        public final String property;
        public final int index;
        public int pathOffset;
        public PointerSegment prev;

        public PointerSegment(PointerSegment pointerSegment, String string, int n2) {
            this.next = pointerSegment;
            this.property = string;
            this.index = n2;
            if (pointerSegment != null) {
                pointerSegment.prev = this;
            }
        }
    }

    private static class PointerParent {
        public final PointerParent parent;
        public final int fullPathOffset;
        public final String segment;

        PointerParent(PointerParent pointerParent, int n2, String string) {
            this.parent = pointerParent;
            this.fullPathOffset = n2;
            this.segment = string;
        }
    }
}

