/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import atlantafx.base.util.MaskChar;
import atlantafx.base.util.SimpleMaskChar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import org.jetbrains.annotations.Nullable;

public class MaskTextFormatter
extends TextFormatter<String> {
    protected final MaskTextFilter filter;

    protected MaskTextFormatter(MaskTextFilter maskTextFilter) {
        super((UnaryOperator)maskTextFilter);
        this.filter = maskTextFilter;
    }

    public static TextField createTextField(String string) {
        return MaskTextFormatter.createTextField(MaskTextFormatter.fromString(string));
    }

    public static TextField createTextField(List<MaskChar> list) {
        TextField textField = new TextField();
        MaskTextFormatter.create(textField, list);
        return textField;
    }

    public static MaskTextFormatter create(TextField textField, String string) {
        return MaskTextFormatter.create(textField, MaskTextFormatter.fromString(string));
    }

    public static MaskTextFormatter create(TextField textField, List<MaskChar> list) {
        Objects.requireNonNull(textField, "Text field can't be null");
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Input mask can't be null or empty.");
        }
        String string = MaskTextFormatter.createPlaceholderMask(list);
        MaskTextFilter maskTextFilter = new MaskTextFilter(list);
        textField.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            String string2 = textField.getText();
            String string3 = textField.getPromptText();
            if (bl3.booleanValue()) {
                if (string2 == null || string2.isBlank()) {
                    maskTextFilter.doInternalChange(() -> textField.setText(string));
                    int n3 = IntStream.range(0, list.size()).filter(n2 -> !((MaskChar)list.get(n2)).isFixed()).findFirst().orElse(0);
                    Platform.runLater(() -> {
                        textField.deselect();
                        textField.positionCaret(n3);
                    });
                }
            } else if (string3 != null && !string3.isBlank() && Objects.equals(string, string2)) {
                maskTextFilter.doInternalChange(() -> textField.setText(""));
            }
        });
        textField.promptTextProperty().addListener((observableValue, string2, string3) -> {
            if (string3 == null || string3.isBlank()) {
                maskTextFilter.doInternalChange(() -> textField.setText(string));
            } else {
                maskTextFilter.doInternalChange(() -> textField.setText(""));
            }
        });
        MaskTextFormatter maskTextFormatter = new MaskTextFormatter(maskTextFilter);
        textField.setTextFormatter((TextFormatter)maskTextFormatter);
        maskTextFilter.doInternalChange(() -> textField.setText(string));
        return maskTextFormatter;
    }

    protected static String createPlaceholderMask(String string) {
        return MaskTextFormatter.createPlaceholderMask(MaskTextFormatter.fromString(string));
    }

    protected static String createPlaceholderMask(List<MaskChar> list) {
        return list.stream().map(maskChar -> Character.toString(maskChar.getPlaceholder())).collect(Collectors.joining());
    }

    protected static List<MaskChar> fromString(String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("Input mask can't be null or empty.");
        }
        ArrayList<SimpleMaskChar> arrayList = new ArrayList<SimpleMaskChar>(string.trim().length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            SimpleMaskChar simpleMaskChar = switch (c3) {
                case 'A' -> new SimpleMaskChar(Character::isLetter);
                case 'N' -> new SimpleMaskChar(Character::isLetterOrDigit);
                case 'X' -> new SimpleMaskChar(c2 -> !Character.isSpaceChar(c2.charValue()));
                case 'H' -> new SimpleMaskChar(c2 -> c2.charValue() >= 'A' && c2.charValue() <= 'F' || c2.charValue() >= 'a' && c2.charValue() <= 'f' || Character.isDigit(c2.charValue()));
                case 'D' -> new SimpleMaskChar(c2 -> Character.isDigit(c2.charValue()) && c2.charValue() != '0');
                case '9' -> new SimpleMaskChar(Character::isDigit);
                case '8' -> new SimpleMaskChar(c2 -> c2.charValue() >= '0' && c2.charValue() <= '8');
                case '7' -> new SimpleMaskChar(c2 -> c2.charValue() >= '0' && c2.charValue() <= '7');
                case '6' -> new SimpleMaskChar(c2 -> c2.charValue() >= '0' && c2.charValue() <= '6');
                case '5' -> new SimpleMaskChar(c2 -> c2.charValue() >= '0' && c2.charValue() <= '5');
                case '4' -> new SimpleMaskChar(c2 -> c2.charValue() >= '0' && c2.charValue() <= '4');
                case '3' -> new SimpleMaskChar(c2 -> c2.charValue() >= '0' && c2.charValue() <= '3');
                case '2' -> new SimpleMaskChar(c2 -> c2.charValue() >= '0' && c2.charValue() <= '2');
                case '1' -> new SimpleMaskChar(c2 -> c2.charValue() >= '0' && c2.charValue() <= '1');
                case '0' -> new SimpleMaskChar(c2 -> c2.charValue() == '0');
                default -> SimpleMaskChar.fixed(c3);
            };
            arrayList.add(simpleMaskChar);
        }
        return Collections.unmodifiableList(arrayList);
    }

    protected static class MaskTextFilter
    implements UnaryOperator<TextFormatter.Change> {
        protected final List<MaskChar> mask;
        protected boolean ignoreFilter;

        public MaskTextFilter(List<MaskChar> list) {
            this.mask = Objects.requireNonNull(list);
        }

        public boolean isInternalChange() {
            return this.ignoreFilter;
        }

        public void doInternalChange(Runnable runnable) {
            try {
                this.ignoreFilter = true;
                runnable.run();
            }
            finally {
                this.ignoreFilter = false;
            }
        }

        @Override
        public TextFormatter.Change apply(TextFormatter.Change change) {
            if (!change.isContentChange() || this.isInternalChange()) {
                return change;
            }
            return this.correctContentChange(change);
        }

        @Nullable
        protected TextFormatter.Change correctContentChange(TextFormatter.Change change) {
            String string = null;
            if (change.isReplaced()) {
                string = this.correctReplacedText(change);
            } else if (change.isAdded()) {
                string = this.correctAddedText(change);
            } else if (change.isDeleted()) {
                string = this.correctDeletedText(change);
            }
            if (string != null) {
                int n2 = change.getRangeStart();
                change.setRange(n2, Math.min(n2 + string.length(), change.getControlText().length()));
                change.setText(string);
            }
            this.adjustCaretPosition(change);
            return string != null ? change : null;
        }

        @Nullable
        protected String correctReplacedText(TextFormatter.Change change) {
            int n2;
            int n3 = change.getRangeStart();
            int n4 = change.getRangeEnd();
            String string = change.getText();
            StringBuilder stringBuilder = new StringBuilder(n4 - n3);
            for (n2 = n3; n2 - n3 < string.length() && n2 < n4 && n2 < this.mask.size(); ++n2) {
                char c2 = string.charAt(n2 - n3);
                if (!this.mask.get(n2).isAllowed(c2)) {
                    return null;
                }
                stringBuilder.append(this.mask.get(n2).transform(c2));
            }
            for (n2 = n3 + string.length(); n2 < n4 && n2 < this.mask.size(); ++n2) {
                stringBuilder.append(this.mask.get(n2).getPlaceholder());
            }
            return stringBuilder.toString();
        }

        @Nullable
        protected String correctAddedText(TextFormatter.Change change) {
            int n2 = change.getRangeStart();
            String string = change.getText();
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (int i2 = n2; i2 - n2 < string.length() && i2 < this.mask.size(); ++i2) {
                char c2 = string.charAt(i2 - n2);
                if (!this.mask.get(i2).isAllowed(c2)) {
                    return null;
                }
                stringBuilder.append(this.mask.get(i2).transform(c2));
            }
            return stringBuilder.toString();
        }

        protected String correctDeletedText(TextFormatter.Change change) {
            int n2;
            int n3 = change.getRangeStart();
            int n4 = change.getRangeEnd();
            StringBuilder stringBuilder = new StringBuilder(n4 - n3);
            for (n2 = n3; n2 < n4; ++n2) {
                stringBuilder.append(this.mask.get(n2).getPlaceholder());
            }
            n2 = n3;
            while (n2 > 0 && this.mask.get(n2).isFixed()) {
                stringBuilder.insert(0, this.mask.get(n2 - 1).getPlaceholder());
                --n2;
                --n3;
            }
            change.setRange(n3, n4);
            return stringBuilder.toString();
        }

        protected void adjustCaretPosition(TextFormatter.Change change) {
            int n2;
            int n3 = change.getControlCaretPosition();
            if (n3 != (n2 = Math.min(change.getCaretPosition(), this.mask.size()))) {
                int n4;
                int n5 = n4 = n2 > n3 ? 1 : -1;
                while (n2 > 0 && n2 < this.mask.size() && this.mask.get(n2).isFixed()) {
                    n2 += n4;
                }
                while (n2 < this.mask.size() && this.mask.get(n2).isFixed()) {
                    ++n2;
                }
            }
            n2 = Math.min(n2, change.getControlNewText().length());
            if (change.getAnchor() == change.getCaretPosition()) {
                change.setAnchor(n2);
            }
            change.setCaretPosition(n2);
        }
    }
}

