/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.util.StringConverter;

public class IntegerStringConverter
extends StringConverter<Integer> {
    private Runnable reset;

    public IntegerStringConverter() {
    }

    public IntegerStringConverter(Runnable runnable) {
        this.reset = runnable;
    }

    public IntegerStringConverter(TextField textField, int n2, int n3) {
        if (textField == null) {
            throw new NullPointerException("Input cannot be null!");
        }
        int n4 = Math.min(Math.max(0, n2), n3);
        this.reset = () -> textField.setText(Integer.toString(n4));
        textField.textProperty().addListener((observableValue, string, string2) -> {
            if (string2 == null || string2.isEmpty()) {
                return;
            }
            if (n2 < 0 && string2.endsWith("-")) {
                if (string2.length() > 1) {
                    Platform.runLater(() -> textField.setText("-"));
                }
                return;
            }
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Platform.runLater(() -> textField.setText(string));
            }
        });
        EventHandler eventHandler = textField.getOnAction();
        textField.setOnAction(actionEvent -> {
            int n4;
            int n5 = this.fromString(textField.getText());
            if (n5 != (n4 = Math.min(Math.max(n5, n2), n3))) {
                textField.setText(Integer.toString(n4));
            }
            if (eventHandler != null) {
                eventHandler.handle(actionEvent);
            }
        });
    }

    public static IntegerStringConverter createFor(Spinner<Integer> spinner) {
        SpinnerValueFactory.IntegerSpinnerValueFactory integerSpinnerValueFactory = (SpinnerValueFactory.IntegerSpinnerValueFactory)spinner.getValueFactory();
        IntegerStringConverter integerStringConverter = new IntegerStringConverter(spinner.getEditor(), integerSpinnerValueFactory.getMin(), integerSpinnerValueFactory.getMax());
        integerSpinnerValueFactory.setConverter((StringConverter)integerStringConverter);
        spinner.setTooltip(new Tooltip(String.format("Enter a value between %d and %d", integerSpinnerValueFactory.getMin(), integerSpinnerValueFactory.getMax())));
        return integerStringConverter;
    }

    public void setReset(Runnable runnable) {
        this.reset = runnable;
    }

    public Integer fromString(String string) {
        if (string == null || string.isEmpty()) {
            if (this.reset != null) {
                this.reset.run();
            }
            return 0;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.reset != null) {
                this.reset.run();
            }
            return 0;
        }
    }

    public String toString(Integer n2) {
        if (n2 == null) {
            return "0";
        }
        return Integer.toString(n2);
    }
}

